/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.rmi.RemoteTreeCache;

public class RemoteTreeCacheImpl
extends UnicastRemoteObject
implements RemoteTreeCache {
    private TreeCache cache;

    public RemoteTreeCacheImpl(TreeCache cache) throws RemoteException {
        this.cache = cache;
    }

    public Set getChildrenNames(Fqn fqn) throws Exception, RemoteException {
        return this.cache.getChildrenNames(fqn);
    }

    public Object get(Fqn name, Object key) throws Exception, RemoteException {
        return this.cache.get(name, key);
    }

    public DataNode get(Fqn name) throws Exception, RemoteException {
        return this.cache.get(name);
    }

    public boolean exists(Fqn name) throws Exception, RemoteException {
        return this.cache.exists(name);
    }

    public Object put(Fqn name, Object key, Object value) throws Exception, RemoteException {
        return this.cache.put(name, key, value);
    }

    public void put(Fqn name, Map attributes) throws Exception, RemoteException {
        this.cache.put(name, attributes);
    }

    public void put(List modifications) throws Exception, RemoteException {
        Iterator it = modifications.iterator();
        block8: while (it.hasNext()) {
            Modification m = (Modification)it.next();
            switch (m.getType()) {
                case 2: {
                    this.cache.put(m.getFqn(), m.getData());
                    continue block8;
                }
                case 3: {
                    this.cache.put(m.getFqn(), m.getData());
                    continue block8;
                }
                case 1: {
                    this.cache.put(m.getFqn(), m.getKey(), m.getValue());
                    continue block8;
                }
                case 6: {
                    this.cache.removeData(m.getFqn());
                    continue block8;
                }
                case 5: {
                    this.cache.remove(m.getFqn(), m.getKey());
                    continue block8;
                }
                case 4: {
                    this.cache.remove(m.getFqn());
                    continue block8;
                }
            }
            System.err.println("modification type " + m.getType() + " not known");
        }
    }

    public Object remove(Fqn name, Object key) throws Exception, RemoteException {
        return this.cache.remove(name, key);
    }

    public void remove(Fqn name) throws Exception, RemoteException {
        this.cache.remove(name);
    }

    public void removeData(Fqn name) throws Exception, RemoteException {
        this.cache.removeData(name);
    }

    public byte[] getState() throws Exception, RemoteException {
        return this.cache.getStateBytes();
    }

    public void setState(byte[] state) throws Exception, RemoteException {
        this.cache.setStateBytes(state);
    }
}

