/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionNameConflictException;

public class RegionManager {
    private Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$marshall$RegionManager == null ? (class$org$jboss$cache$marshall$RegionManager = RegionManager.class$("org.jboss.cache.marshall.RegionManager")) : class$org$jboss$cache$marshall$RegionManager));
    private Map regionMap_ = new HashMap();
    private Region[] regions_ = null;
    static final String DEFAULT_REGION = "/_default_/";
    static /* synthetic */ Class class$org$jboss$cache$marshall$RegionManager;

    public Region createRegion(String fqn, ClassLoader cl) throws RegionNameConflictException {
        return this.createRegion(fqn, cl, false);
    }

    public Region createRegion(String fqn, ClassLoader cl, boolean inactive) throws RegionNameConflictException {
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("createRegion(): creating region for fqn- " + fqn));
        }
        String newFqn = this.appendFqn(fqn);
        this.checkConflict(newFqn);
        Region region = new Region(newFqn, cl, inactive);
        this.regionMap_.put(newFqn, region);
        return region;
    }

    public void removeRegion(String fqn) {
        if (!this.hasRegion(fqn)) {
            return;
        }
        this.regionMap_.remove(this.appendFqn(fqn));
        this.regions_ = null;
    }

    private String appendFqn(String fqn) {
        if (!fqn.endsWith("/")) {
            return fqn + "/";
        }
        return fqn;
    }

    public boolean hasRegion(String myFqn) {
        String newFqn = this.appendFqn(myFqn);
        return this.regionMap_.containsKey(newFqn);
    }

    public Region getRegion(String myFqn) {
        Region[] regions = this.getRegions();
        String myRFqn = this.appendFqn(myFqn);
        for (int i = regions.length - 1; i >= 0; --i) {
            String fqn = regions[i].getFqn();
            if (!myRFqn.startsWith(fqn)) continue;
            return regions[i];
        }
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("getRegion(): no user-specified region found for this fqn- " + myFqn));
        }
        return null;
    }

    public Region[] getRegions() {
        if (this.regions_ != null && this.regions_.length == this.regionMap_.size()) {
            return this.regions_;
        }
        Object[] objs = this.regionMap_.values().toArray();
        Region[] regions = new Region[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            regions[i] = (Region)objs[i];
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("getRegions(): size of region " + regions.length));
        }
        this.regions_ = regions;
        return regions;
    }

    public void checkConflict(String myFqn) throws RegionNameConflictException {
        Region[] regions = this.getRegions();
        for (int i = 0; i < regions.length; ++i) {
            String fqn = regions[i].getFqn();
            if (!myFqn.equals(fqn) && !myFqn.startsWith(fqn)) continue;
            throw new RegionNameConflictException("RegionManager.checkConflict(): new region fqn " + myFqn + " is in conflict with current region fqn- " + fqn);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

