/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.xml;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlHelper {
    public static String getAttr(Element elem, String myName, String tagName, String attributeName) {
        NodeList list = elem.getElementsByTagName(tagName);
        for (int s = 0; s < list.getLength(); ++s) {
            Element element;
            String name;
            Node node = list.item(s);
            if (node.getNodeType() != 1 || !(name = (element = (Element)node).getAttribute(attributeName)).equals(myName)) continue;
            String valueStr = XmlHelper.getElementContent(element, true);
            return valueStr;
        }
        return null;
    }

    public static String getElementContent(Element element, boolean trim) {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            attributeText = attributeText + ((Text)n).getData();
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        return attributeText;
    }

    public static String readStringContents(Element element, String tagName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            Element ne = (Element)node;
            NodeList nl2 = ne.getChildNodes();
            Node node2 = nl2.item(0);
            if (node2 != null) {
                String value = node2.getNodeValue();
                return value.trim();
            }
            return "";
        }
        return "";
    }

    public static boolean readBooleanContents(Element element, String tagName) {
        String val = XmlHelper.readStringContents(element, tagName);
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false")) {
            return Boolean.valueOf(val);
        }
        return false;
    }

    public static Element stringToElement(String xml) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = builder.parse(bais);
        bais.close();
        return d.getDocumentElement();
    }
}

