/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.ContextValue;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.model.CompletionDirective;
import org.jboss.ide.eclipse.freemarker.model.CompletionInterpolation;
import org.jboss.ide.eclipse.freemarker.model.CompletionMacroInstance;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.MacroInstance;

public class CompletionProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor {
    private Editor editor;

    public CompletionProcessor(Editor editor) {
        this.editor = editor;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            char c2;
            char c;
            int i;
            ItemSet directiveSet = this.editor.getItemSet();
            HashMap<String, Class> context = new HashMap<String, Class>();
            ContextValue[] values = ConfigurationManager.getInstance(this.editor.getProject()).getContextValues((IResource)this.editor.getFile(), true);
            int i2 = 0;
            while (i2 < values.length) {
                context.put(values[i2].name, values[i2].objClass);
                ++i2;
            }
            Item directive = directiveSet.getSelectedItem(offset);
            if (directive != null) {
                return directive.getCompletionProposals(offset, context);
            }
            Item item = this.editor.getItemSet().getPreviousItem(offset);
            int topOffset = 0;
            if (item != null) {
                topOffset = item.getRegion().getOffset() + item.getRegion().getLength();
            }
            try {
                i = offset - 1;
                while (i >= topOffset) {
                    c = this.editor.getDocument().getChar(i);
                    if (c != '>' && c != ']') {
                        if ((c == '<' || c == '[') && this.editor.getDocument().getLength() > i) {
                            c2 = this.editor.getDocument().getChar(i + 1);
                            if (c2 == '#') {
                                CompletionDirective completionDirective = new CompletionDirective(i, offset - i, this.editor.getItemSet(), (ISourceViewer)viewer, (IResource)this.editor.getFile());
                                completionDirective.setItemSet(this.editor.getItemSet());
                                return completionDirective.getCompletionProposals(offset, context);
                            }
                            if (c2 == '@') {
                                CompletionMacroInstance completionMacroInstance = new CompletionMacroInstance(this.editor.getDocument().get(i, offset - i), i, this.editor.getItemSet(), (IResource)this.editor.getFile());
                                completionMacroInstance.setItemSet(this.editor.getItemSet());
                                return completionMacroInstance.getCompletionProposals(offset, context);
                            }
                            if (c2 == '/') {
                                if (this.editor.getDocument().getLength() < i + 3 || this.editor.getDocument().getChar(i + 2) == ' ' || this.editor.getDocument().getChar(i + 2) == '\r' || this.editor.getDocument().getChar(i + 2) == '\n') {
                                    Item stackItem = this.editor.getItemSet().getPreviousStartItem(offset);
                                    StringBuffer value = new StringBuffer();
                                    if (stackItem != null && stackItem instanceof MacroInstance) {
                                        value.append("@");
                                    } else {
                                        value.append("#");
                                    }
                                    String name = null;
                                    if (stackItem != null) {
                                        name = stackItem.getFirstToken();
                                    }
                                    if (name != null) {
                                        value.append(name);
                                    }
                                    if (c == '<') {
                                        value.append('>');
                                    } else {
                                        value.append(']');
                                    }
                                    CompletionProposal completionProposal = new CompletionProposal(value.toString(), offset, 0, offset + value.toString().length());
                                    return new ICompletionProposal[]{completionProposal};
                                }
                            } else {
                                return null;
                            }
                        }
                        --i;
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            try {
                i = offset - 1;
                while (i >= topOffset) {
                    c = this.editor.getDocument().getChar(i);
                    if (c != '\n') {
                        if (c == '$' && this.editor.getDocument().getLength() > i && (c2 = this.editor.getDocument().getChar(i + 1)) == '{') {
                            int j = offset;
                            while (this.editor.getDocument().getLength() > j) {
                                char c3 = this.editor.getDocument().getChar(j);
                                if (Character.isWhitespace(c3) || c3 == '(' || c3 == '.' || c3 == ')' || c3 == '}' || c3 == '?') break;
                                ++j;
                            }
                            CompletionInterpolation interpolation = new CompletionInterpolation(this.editor.getDocument().get(i, j - i), i, this.editor.getItemSet(), (IResource)this.editor.getFile());
                            interpolation.setParentItem(this.editor.getItemSet().getPreviousStartItem(offset));
                            return interpolation.getCompletionProposals(offset, context);
                        }
                        --i;
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        catch (Exception e) {
            Plugin.log(e);
        }
        return null;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return null;
    }

    protected Image getImage(Template template) {
        return null;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '$', '#', '@', '/', '?', '{'};
    }
}

