/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.editor.FreemarkerMultiPageEditor;
import org.jboss.ide.eclipse.freemarker.model.MacroInstance;

public class MacroHyperlink
implements IHyperlink {
    private MacroInstance macroInstance;
    private IFile file;
    private int offset;
    private int length;

    public MacroHyperlink(MacroInstance macroInstance, IFile file, int offset, int length) {
        this.macroInstance = macroInstance;
        this.file = file;
        this.offset = offset;
        this.length = length;
    }

    public void open() {
        try {
            IEditorPart editorPart = Plugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.file), "org.jboss.ide.eclipse.freemarker.editor.FreemarkerEditor");
            if (this.offset >= 0 && this.length > 0 && editorPart instanceof FreemarkerMultiPageEditor) {
                ((FreemarkerMultiPageEditor)editorPart).selectAndReveal(this.offset, this.length);
            }
        }
        catch (PartInitException e) {
            Plugin.error(e);
        }
    }

    public IRegion getHyperlinkRegion() {
        return this.macroInstance.getRegion();
    }

    public String getHyperlinkText() {
        return this.macroInstance.getName();
    }

    public String getTypeLabel() {
        return "Macro Definition";
    }
}

