/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.MacroLibrary;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.editor.MacroHyperlink;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroInstance;

public class MacroHyperlinkDetector
implements IHyperlinkDetector {
    private Editor editor;

    public MacroHyperlinkDetector(ITextViewer textViewer, Editor editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Item item = this.editor.getItemSet().getItem(region.getOffset());
        if (item != null && item instanceof MacroInstance) {
            MacroInstance instance = (MacroInstance)item;
            int index = instance.getName().indexOf(46);
            if (index > 0) {
                String namespace = instance.getName().substring(0, index);
                MacroLibrary macroLibrary = ConfigurationManager.getInstance(this.editor.getProject()).getMacroLibrary(namespace);
                if (macroLibrary != null) {
                    int i = 0;
                    while (i < macroLibrary.getMacros().length) {
                        if (macroLibrary.getMacros()[i].getName().equals(instance.getName())) {
                            return new IHyperlink[]{new MacroHyperlink(instance, macroLibrary.getFile(), macroLibrary.getMacros()[i].getOffset(), macroLibrary.getMacros()[i].getLength())};
                        }
                        ++i;
                    }
                }
                if (macroLibrary != null) {
                    return new IHyperlink[]{new MacroHyperlink(instance, macroLibrary.getFile(), -1, -1)};
                }
            } else {
                List macroDefinitions = instance.getItemSet().getMacroDefinitions();
                Iterator i = macroDefinitions.iterator();
                while (i.hasNext()) {
                    MacroDirective macroDefinition = (MacroDirective)i.next();
                    if (!macroDefinition.getName().equals(instance.getName())) continue;
                    return new IHyperlink[]{new MacroHyperlink(instance, this.editor.getFile(), macroDefinition.getOffset(), macroDefinition.getLength())};
                }
            }
        }
        return null;
    }

    public void init(ITextViewer viewer) {
    }
}

