/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.actions;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.ui.preferences.ProjectSelectionDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;

public class AddMacroLibrary
implements IObjectActionDelegate {
    private IWorkbenchPart part;

    public void run(IAction action) {
        ISelectionProvider provider = this.part.getSite().getSelectionProvider();
        if (provider != null && provider.getSelection() instanceof IStructuredSelection) {
            try {
                IStructuredSelection selection = (IStructuredSelection)provider.getSelection();
                Object[] obj = selection.toArray();
                ArrayList<Object> documents = new ArrayList<Object>();
                int i = 0;
                while (i < obj.length) {
                    if (obj[i] instanceof IFile) {
                        IFile file = (IFile)obj[i];
                        documents.add(file);
                    } else if (obj[i] instanceof JarEntryFile) {
                        JarEntryFile jef = (JarEntryFile)obj[i];
                        documents.add(jef);
                        System.out.println(jef.getFullPath().makeAbsolute());
                        System.out.println(jef.getFullPath().makeRelative());
                        IPath path = jef.getFullPath();
                        System.out.println(path);
                        System.out.println(jef.getName());
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(jef.getFullPath());
                        System.out.println(resource);
                    } else {
                        boolean cfr_ignored_0 = obj[i] instanceof IStorage;
                    }
                    ++i;
                }
                IProject project = null;
                if (documents.size() > 0) {
                    HashSet<IProject> projects = new HashSet<IProject>();
                    IProject[] p = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int i2 = 0;
                    while (i2 < p.length) {
                        projects.add(p[i2]);
                        ++i2;
                    }
                    ProjectSelectionDialog dialog = new ProjectSelectionDialog(Display.getCurrent().getActiveShell(), projects);
                    dialog.setTitle("Please choose the associated Java project");
                    dialog.setMessage("Please choose the Java project that will use the FreeMarker libraries");
                    int rtn = dialog.open();
                    if (rtn == 0) {
                        if (dialog.getFirstResult() instanceof IJavaProject) {
                            project = ((IJavaProject)dialog.getFirstResult()).getProject();
                        } else {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Java Project Required", (String)"You must choose a Java project");
                        }
                    }
                }
                if (project != null) {
                    ConfigurationManager.getInstance(project).associateMappingLibraries(documents, Display.getCurrent().getActiveShell());
                }
            }
            catch (Exception e) {
                Plugin.error(e);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean shouldForce() {
        return false;
    }
}

