/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.StringTokenizer;
import java.text.MessageFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;

public class MinmaxValidator
implements ICellEditorValidator,
IExecutableExtension {
    public static final String MIN_ONLY = "minonly";
    public static final String MAX_ONLY = "maxonly";
    public static final Long LONG_UNDERFLOW = new Long(-42L);
    public static final Long LONG_OVERFLOW = new Long(42L);
    protected static final MessageFormat sMinMaxError = new MessageFormat(PropertysheetMessages.minmax_bad_WARN_);
    protected static final MessageFormat sMinError = new MessageFormat(PropertysheetMessages.min_bad_WARN_);
    protected static final MessageFormat sMaxError = new MessageFormat(PropertysheetMessages.max_bad_WARN_);
    protected static final String sNotNumberError = PropertysheetMessages.not_number_WARN_;
    protected static final NumberFormat sNumberFormat = NumberFormat.getInstance();
    protected String fType = null;
    protected Number fMinValue;
    protected Number fMaxValue;

    static {
        sNumberFormat.setMaximumFractionDigits(8);
    }

    public MinmaxValidator() {
        this((Number)new Long(Integer.MIN_VALUE), new Long(Integer.MAX_VALUE));
    }

    public MinmaxValidator(int min, int max) {
        this((Number)new Long(min), new Long(max));
    }

    public MinmaxValidator(int in, String type) {
        this((Number)new Long(in), type);
    }

    public MinmaxValidator(Number min, Number max) {
        this.setMinMax(min, max);
    }

    public MinmaxValidator(Number in, String type) {
        this.setOnly(in, type);
    }

    public void setMinMax(int min, int max) {
        this.setMinMax(new Long(min), new Long(max));
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        if (initData instanceof String) {
            StringTokenizer st = new StringTokenizer((String)initData, ":,", true);
            String s = null;
            if (st.hasMoreTokens()) {
                s = st.nextToken();
            }
            if ("min".equalsIgnoreCase(s)) {
                if (!st.hasMoreTokens()) {
                    return;
                }
                s = st.nextToken();
                if (!st.hasMoreTokens()) {
                    return;
                }
                s = st.nextToken();
                try {
                    Number min = sNumberFormat.parse(s);
                    this.setOnly(min, MIN_ONLY);
                }
                catch (ParseException parseException) {}
            } else if ("max".equalsIgnoreCase(s)) {
                try {
                    if (!st.hasMoreTokens()) {
                        return;
                    }
                    s = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        return;
                    }
                    s = st.nextToken();
                    Number max = sNumberFormat.parse(s);
                    this.setOnly(max, MAX_ONLY);
                }
                catch (ParseException parseException) {}
            } else {
                try {
                    Number min = sNumberFormat.parse(s);
                    if (!st.hasMoreTokens()) {
                        return;
                    }
                    s = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        return;
                    }
                    s = st.nextToken();
                    Number max = sNumberFormat.parse(s);
                    this.setMinMax(min, max);
                }
                catch (ParseException parseException) {}
            }
        }
    }

    public void setMinMax(Number min, Number max) {
        this.fType = null;
        this.fMinValue = min;
        this.fMaxValue = max;
    }

    public void setOnly(int in, String type) {
        this.setOnly(new Long(in), type);
    }

    public void setOnly(Number in, String type) {
        if (MIN_ONLY.equals(type)) {
            this.fType = MIN_ONLY;
            this.fMinValue = in;
        } else {
            this.fType = MAX_ONLY;
            this.fMaxValue = in;
        }
    }

    public String isValid(Object value) {
        if (value instanceof Number) {
            if (value == LONG_UNDERFLOW || value == LONG_OVERFLOW) {
                if (this.fType == null) {
                    return sMinMaxError.format(new Object[]{sNumberFormat.format(this.fMinValue.longValue()), sNumberFormat.format(this.fMaxValue.longValue())});
                }
                if (this.fType == MIN_ONLY) {
                    return value != LONG_UNDERFLOW ? null : sMinError.format(new Object[]{sNumberFormat.format(this.fMinValue.longValue())});
                }
                return value != LONG_OVERFLOW ? null : sMaxError.format(new Object[]{sNumberFormat.format(this.fMaxValue.longValue())});
            }
            if (!(value instanceof Double) && !(value instanceof Float)) {
                long l = ((Number)value).longValue();
                if (this.fType == null) {
                    return this.fMinValue.longValue() <= l && l <= this.fMaxValue.longValue() ? null : sMinMaxError.format(new Object[]{sNumberFormat.format(this.fMinValue.longValue()), sNumberFormat.format(this.fMaxValue.longValue())});
                }
                if (this.fType == MIN_ONLY) {
                    return this.fMinValue.longValue() <= l ? null : sMinError.format(new Object[]{sNumberFormat.format(this.fMinValue.longValue())});
                }
                return l <= this.fMaxValue.longValue() ? null : sMaxError.format(new Object[]{sNumberFormat.format(this.fMaxValue.longValue())});
            }
            double d = ((Number)value).doubleValue();
            if (this.fType == null) {
                return this.fMinValue.doubleValue() <= d && d <= this.fMaxValue.doubleValue() ? null : sMinMaxError.format(new Object[]{sNumberFormat.format(this.fMinValue.doubleValue()), sNumberFormat.format(this.fMaxValue.doubleValue())});
            }
            if (this.fType == MIN_ONLY) {
                return this.fMinValue.doubleValue() <= d ? null : sMinError.format(new Object[]{sNumberFormat.format(this.fMinValue.doubleValue())});
            }
            return d <= this.fMaxValue.doubleValue() ? null : sMaxError.format(new Object[]{sNumberFormat.format(this.fMaxValue.doubleValue())});
        }
        if (value != null) {
            return sNotNumberError;
        }
        return null;
    }
}

