/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.commands;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ve.internal.cde.commands.AbstractApplyAttributeCommand;
import org.eclipse.ve.internal.cde.core.CDEPlugin;

public class ApplyAttributeSettingCommand
extends AbstractApplyAttributeCommand {
    protected Object oldValue;
    protected boolean oldSet;
    protected int fInsertionIndex = -1;
    protected Object fInsertBeforeValue;

    public ApplyAttributeSettingCommand(String name) {
        super(name);
    }

    public ApplyAttributeSettingCommand() {
    }

    public void execute() {
        this.cancelOldContainment();
        EObject target = this.getTarget();
        if (!this.feature.isMany()) {
            this.oldSet = target.eIsSet(this.feature);
            if (this.oldSet) {
                this.oldValue = target.eGet(this.feature);
            }
            try {
                target.eSet(this.feature, this.getAttributeSettingValues().get(0));
            }
            catch (RuntimeException e) {
                try {
                    this.undo();
                    throw e;
                }
                catch (RuntimeException e2) {
                    CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e2));
                }
            }
        } else {
            int insertAt = this.fInsertionIndex;
            List featureList = (List)target.eGet(this.feature);
            if (this.fInsertBeforeValue != null) {
                insertAt = featureList.indexOf(this.fInsertBeforeValue);
            }
            try {
                if (insertAt == -1) {
                    featureList.addAll(this.getAttributeSettingValues());
                } else {
                    featureList.addAll(insertAt, this.getAttributeSettingValues());
                }
            }
            catch (RuntimeException e) {
                featureList.removeAll(this.getAttributeSettingValues());
                throw e;
            }
        }
    }

    public void undo() {
        EObject target = this.getTarget();
        if (this.feature.isMany()) {
            ((List)target.eGet(this.feature)).removeAll(this.getAttributeSettingValues());
        } else if (!this.oldSet) {
            target.eUnset(this.feature);
        } else {
            target.eSet(this.feature, this.oldValue);
        }
        this.oldValue = null;
        this.restoreOldContainment();
    }

    public void setInsertionIndex(int newIndex) {
        this.fInsertionIndex = newIndex;
        this.fInsertBeforeValue = null;
    }

    public void setInsertBeforeValue(Object insertBefore) {
        this.fInsertionIndex = -1;
        this.fInsertBeforeValue = insertBefore;
    }
}

