/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.commands;

import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.ve.internal.cdm.KeyedValueHolder;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class ApplyKeyedValueCommand
extends AbstractCommand {
    protected KeyedValueHolder target;
    protected BasicEMap.Entry newValue;
    protected BasicEMap.Entry oldValue;

    public ApplyKeyedValueCommand(String name) {
        super(name);
    }

    public ApplyKeyedValueCommand() {
    }

    public void setTarget(KeyedValueHolder target) {
        this.target = target;
    }

    public void setValue(BasicEMap.Entry value) {
        this.newValue = value;
    }

    public boolean canExecute() {
        return this.target != null && this.newValue != null && this.newValue.getKey() != null;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        EMap kvs = this.target.getKeyedValues();
        this.oldValue = this.updateKeyedValue(kvs, this.newValue);
    }

    protected BasicEMap.Entry updateKeyedValue(EMap kvs, BasicEMap.Entry newValue) {
        int keyPos = kvs.indexOfKey(newValue.getKey());
        BasicEMap.Entry old = null;
        if (keyPos != -1) {
            old = (BasicEMap.Entry)kvs.set(keyPos, (Object)newValue);
        } else {
            kvs.add((Object)newValue);
        }
        return old;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        if (this.oldValue != null) {
            this.updateKeyedValue(this.target.getKeyedValues(), this.oldValue);
        } else {
            this.target.getKeyedValues().removeKey(this.newValue.getKey());
        }
        this.oldValue = null;
    }
}

