/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;

public class CDELayoutEditPolicy
extends LayoutEditPolicy {
    protected ContainerPolicy containerPolicy;
    private Figure targetFeedback;

    public CDELayoutEditPolicy(ContainerPolicy aPolicy) {
        this.containerPolicy = aPolicy;
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    public EditPolicy createChildEditPolicy(EditPart aChild) {
        return new NonResizableEditPolicy();
    }

    protected Command getAddCommand(Request request) {
        Command addContributionCmd = this.containerPolicy.getCommand(request);
        if (addContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return addContributionCmd;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Command createContributionCmd = this.containerPolicy.getCommand((Request)request);
        if (createContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return createContributionCmd;
    }

    protected Command getDeleteDependantCommand(Request request) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(request);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getMoveChildrenCommand(Request request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        Command orphanContributionCmd = this.containerPolicy.getCommand(request);
        if (orphanContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return orphanContributionCmd;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        super.eraseLayoutTargetFeedback(request);
        if (this.targetFeedback != null) {
            this.removeFeedback((IFigure)this.targetFeedback);
            this.targetFeedback = null;
        }
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (("add children".equals(request.getType()) || "create child".equals(request.getType())) && this.targetFeedback == null) {
            RectangleFigure rf = new RectangleFigure();
            this.targetFeedback = rf;
            rf.setFill(false);
            Rectangle rect = new Rectangle(this.getHostFigure().getBounds());
            rf.setBounds(rect.expand(5, 5));
            this.addFeedback((IFigure)this.targetFeedback);
        }
    }
}

