/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.ve.internal.cde.core.DistributeFigure;

public class DistributeHandle
extends Figure
implements FigureListener {
    protected Cursor cursor;
    protected Locator locator;
    protected DistributeFigure owner;
    protected int fLocatorType;
    protected static final int DEFAULT_HANDLE_SIZE = 7;

    public DistributeHandle(DistributeFigure fig, int locatorType) {
        this.owner = fig;
        this.fLocatorType = locatorType;
        this.createRelativeLocator();
        this.setDragCursor(Cursors.getDirectionalCursor((int)locatorType));
        this.setPreferredSize(new Dimension(7, 7));
    }

    public void addNotify() {
        this.getOwner().addFigureListener(this);
        this.addMouseMotionListener(this.getOwner());
    }

    protected void createRelativeLocator() {
        switch (this.fLocatorType) {
            case 1: {
                this.locator = new RelativeLocator((IFigure)this.owner, this.fLocatorType);
                break;
            }
            case 4: {
                this.locator = new RelativeLocator((IFigure)this.owner, this.fLocatorType);
                break;
            }
            case 16: {
                this.locator = new RelativeLocator((IFigure)this.owner, this.fLocatorType);
                break;
            }
            case 8: {
                this.locator = new RelativeLocator((IFigure)this.owner, this.fLocatorType);
                break;
            }
            case 9: {
                this.locator = new RelativeLocator((IFigure)this.owner, this.fLocatorType);
                break;
            }
            case 17: {
                this.locator = new RelativeLocator((IFigure)this.owner, this.fLocatorType);
                break;
            }
            case 12: {
                this.locator = new RelativeLocator((IFigure)this.owner, this.fLocatorType);
                break;
            }
            case 20: {
                this.locator = new RelativeLocator((IFigure)this.owner, this.fLocatorType);
                break;
            }
            default: {
                this.locator = new RelativeLocator((IFigure)this.owner, 1);
            }
        }
    }

    public void figureMoved(IFigure source) {
        this.revalidate();
    }

    protected Color getBorderColor() {
        return ColorConstants.blue;
    }

    protected Color getFillColor() {
        return ColorConstants.blue;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public int getLocatorType() {
        return this.fLocatorType;
    }

    public DistributeFigure getOwner() {
        return this.owner;
    }

    public void handleMousePressed(MouseEvent e) {
        super.handleMousePressed(e);
        e.consume();
    }

    public void handleMouseReleased(MouseEvent e) {
        super.handleMouseReleased(e);
        e.consume();
    }

    public void handleMouseMoved(MouseEvent e) {
        super.handleMouseMoved(e);
        e.consume();
    }

    protected boolean isMouseEventTarget() {
        return true;
    }

    public void removeNotify() {
        this.getOwner().removeFigureListener(this);
    }

    public void handleMouseDragged(MouseEvent e) {
        super.handleMouseDragged(e);
        e.consume();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r.shrink(1, 1);
        try {
            g.setBackgroundColor(this.getFillColor());
            g.fillRectangle(r.x, r.y, r.width, r.height);
            g.setForegroundColor(this.getBorderColor());
            g.drawRectangle(r.x, r.y, r.width, r.height);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            r.expand(1, 1);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        r.expand(1, 1);
    }

    public void setDragCursor(Cursor c) {
        this.cursor = c;
    }

    public void validate() {
        this.getLocator().relocate((IFigure)this);
        super.validate();
    }
}

