/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ve.internal.cde.core.IErrorHolder;

public interface IErrorNotifier
extends IErrorHolder {
    public static final Class ERROR_NOTIFIER_TYPE;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.ve.internal.cde.core.IErrorNotifier");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ERROR_NOTIFIER_TYPE = clazz;
    }

    public void addErrorListener(ErrorListener var1);

    public void removeErrorListener(ErrorListener var1);

    public static interface ErrorListener {
        public void errorStatusChanged();

        public void errorCleared(IErrorHolder.ErrorType var1);

        public void errorAdded(IErrorHolder.ErrorType var1);
    }

    public static class CompoundErrorNotifier
    implements IErrorNotifier,
    ErrorListener {
        protected List notifiers;
        protected ListenerList errorListeners;

        public void addErrorListener(ErrorListener aListener) {
            if (this.errorListeners == null) {
                this.errorListeners = new ListenerList(1);
            }
            this.errorListeners.add((Object)aListener);
        }

        public void removeErrorListener(ErrorListener aListener) {
            if (this.errorListeners != null) {
                this.errorListeners.remove((Object)aListener);
            }
        }

        protected void fireErrorStatusChanged() {
            if (this.errorListeners != null) {
                Object[] listeners = this.errorListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((ErrorListener)listeners[i]).errorStatusChanged();
                    ++i;
                }
            }
        }

        protected void fireAddedError(IErrorHolder.ErrorType e) {
            if (this.errorListeners != null) {
                Object[] listeners = this.errorListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((ErrorListener)listeners[i]).errorAdded(e);
                    ++i;
                }
            }
        }

        protected void fireClearedError(IErrorHolder.ErrorType e) {
            if (this.errorListeners != null) {
                Object[] listeners = this.errorListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((ErrorListener)listeners[i]).errorCleared(e);
                    ++i;
                }
            }
        }

        public void addErrorNotifier(IErrorNotifier notifier) {
            if (notifier == null) {
                return;
            }
            if (this.notifiers == null) {
                this.notifiers = new ArrayList(2);
            }
            if (!this.notifiers.contains(notifier)) {
                int currentStatus = this.getErrorStatus();
                this.notifiers.add(notifier);
                notifier.addErrorListener(this);
                if (currentStatus < this.getErrorStatus()) {
                    this.fireErrorStatusChanged();
                }
            }
        }

        public void removeErrorNotifier(IErrorNotifier notifier) {
            if (this.notifiers != null && notifier != null) {
                int currentStatus = this.getErrorStatus();
                this.notifiers.remove(notifier);
                notifier.removeErrorListener(this);
                if (currentStatus > this.getErrorStatus()) {
                    this.fireErrorStatusChanged();
                }
            }
        }

        public void dispose() {
            if (this.notifiers != null) {
                int i = 0;
                while (i < this.notifiers.size()) {
                    IErrorNotifier notifier = (IErrorNotifier)this.notifiers.get(i);
                    notifier.removeErrorListener(this);
                    ++i;
                }
                this.notifiers = null;
            }
        }

        public int getErrorStatus() {
            if (this.notifiers == null) {
                return 0;
            }
            int maxStatus = 0;
            int i = 0;
            while (i < this.notifiers.size()) {
                IErrorNotifier notifier = (IErrorNotifier)this.notifiers.get(i);
                int status = notifier.getErrorStatus();
                if (status == 3) {
                    return 3;
                }
                maxStatus = Math.max(maxStatus, status);
                ++i;
            }
            return maxStatus;
        }

        public List getErrors() {
            if (this.notifiers == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList errors = new ArrayList();
            int i = 0;
            while (i < this.notifiers.size()) {
                IErrorNotifier notifier = (IErrorNotifier)this.notifiers.get(i);
                errors.addAll(notifier.getErrors());
                ++i;
            }
            return errors;
        }

        public void errorStatusChanged() {
            this.fireErrorStatusChanged();
        }

        public void errorCleared(IErrorHolder.ErrorType error) {
            this.fireClearedError(error);
        }

        public void errorAdded(IErrorHolder.ErrorType error) {
            this.fireAddedError(error);
        }
    }

    public static abstract class ErrorListenerAdapter
    implements ErrorListener {
        public void errorCleared(IErrorHolder.ErrorType error) {
        }

        public void errorAdded(IErrorHolder.ErrorType error) {
        }
    }
}

