/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.IVisualComponent;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;

public class VisualComponentsLayoutPolicy
extends AbstractEditPolicy {
    public static final String LAYOUT_POLICY = "com.ibm.etools.visualcomponentslayoutpolicy";
    public static final String CONSTRAINT_REFRESH_POLICY = "com.ibm.etools.componentconstraintrefreshpolicy";
    public static boolean DO_VC_TRACING = false;
    private EditPartListener editPartListener;
    protected boolean relative;
    protected IVisualComponent parentVisualComponent;
    static /* synthetic */ Class class$0;

    public VisualComponentsLayoutPolicy(boolean relative) {
        this.relative = relative;
    }

    public void activate() {
        EditPart editPart = this.getHost();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IVisualComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.parentVisualComponent = (IVisualComponent)editPart.getAdapter((Class)clazz);
        this.setEditPartListener(this.createEditPartListener());
        this.decorateChildren();
        super.activate();
    }

    public void deactivate() {
        this.parentVisualComponent = null;
        this.undecorateChildren();
        this.setEditPartListener(null);
        super.deactivate();
    }

    public EditPart getTargetEditPart(Request request) {
        return null;
    }

    protected EditPartListener createEditPartListener() {
        return new EditPartListener.Stub(){

            public void childAdded(EditPart child, int index) {
                VisualComponentsLayoutPolicy.this.decorateChild(child);
            }

            public void removingChild(EditPart child, int index) {
                VisualComponentsLayoutPolicy.this.undecorateChild(child);
            }
        };
    }

    protected void setEditPartListener(EditPartListener listener) {
        if (this.editPartListener != null) {
            this.getHost().removeEditPartListener(this.editPartListener);
        }
        this.editPartListener = listener;
        if (this.editPartListener != null) {
            this.getHost().addEditPartListener(this.editPartListener);
        }
    }

    protected void decorateChildren() {
        Iterator children = this.getHost().getChildren().iterator();
        while (children.hasNext()) {
            this.decorateChild((EditPart)children.next());
        }
    }

    protected void decorateChild(EditPart child) {
        child.installEditPolicy((Object)CONSTRAINT_REFRESH_POLICY, (EditPolicy)this.createConstraintRefreshPolicy(child));
    }

    protected ConstraintRefreshPolicy createConstraintRefreshPolicy(EditPart child) {
        return new ConstraintRefreshPolicy(this.relative);
    }

    protected void undecorateChildren() {
        Iterator children = this.getHost().getChildren().iterator();
        while (children.hasNext()) {
            this.undecorateChild((EditPart)children.next());
        }
    }

    protected void undecorateChild(EditPart child) {
        child.removeEditPolicy((Object)CONSTRAINT_REFRESH_POLICY);
    }

    protected void constrain(Rectangle bounds, IFigure parentFigure, EditPart childEP) {
    }

    protected class ConstraintRefreshPolicy
    extends AbstractEditPolicy
    implements IVisualComponentListener {
        IVisualComponent visualComponent;
        protected final boolean relative2;
        static /* synthetic */ Class class$0;

        public ConstraintRefreshPolicy(boolean relative) {
            this.relative2 = relative;
        }

        protected Display getDisplay() {
            return this.getHost().getRoot().getViewer().getControl().getDisplay();
        }

        public void activate() {
            super.activate();
            EditPart editPart = this.getHost();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IVisualComponent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.visualComponent = (IVisualComponent)editPart.getAdapter((Class)clazz);
            if (this.visualComponent != null) {
                ((GraphicalEditPart)VisualComponentsLayoutPolicy.this.getHost()).setLayoutConstraint(this.getHost(), ((GraphicalEditPart)this.getHost()).getFigure(), (Object)new Rectangle());
                this.visualComponent.addComponentListener(this);
                this.signalRefresh();
            }
        }

        public void deactivate() {
            super.deactivate();
            if (this.visualComponent != null) {
                this.visualComponent.removeComponentListener(this);
            }
            this.visualComponent = null;
            this.setHost(null);
        }

        public EditPart getTargetEditPart(Request request) {
            return null;
        }

        protected void signalRefresh() {
            if (this.visualComponent != null) {
                Rectangle oBounds = this.visualComponent.getBounds();
                if (DO_VC_TRACING) {
                    System.out.println("VC Component notification: " + ((IJavaObjectInstance)this.getHost().getModel()).eClass().getName() + " refreshed to: " + oBounds);
                }
                CDEUtilities.displayExec(this.getHost(), "REFRESH", new Runnable(this){
                    final /* synthetic */ ConstraintRefreshPolicy this$1;
                    {
                        this.this$1 = constraintRefreshPolicy;
                    }

                    public void run() {
                        EditPart ep = this.this$1.getHost();
                        if (ep != null && ep.isActive()) {
                            Rectangle oBounds = this.this$1.visualComponent.getBounds();
                            Rectangle bounds = this.this$1.convertBounds(oBounds.getCopy());
                            if (DO_VC_TRACING) {
                                System.out.println("VC Component " + ((IJavaObjectInstance)this.this$1.getHost().getModel()).eClass().getName() + " refreshed to (beforeConvert)" + oBounds + " (afterConvert)" + bounds);
                            }
                            IFigure parent = ((GraphicalEditPart)this.this$1.getHost()).getFigure().getParent();
                            ConstraintRefreshPolicy.access$0(this.this$1).constrain(bounds, parent, this.this$1.getHost());
                            parent.setConstraint(((GraphicalEditPart)this.this$1.getHost()).getFigure(), (Object)bounds);
                        }
                    }
                });
            }
        }

        protected Rectangle convertBounds(Rectangle rect) {
            if (!this.relative2) {
                Point parentAbsolute = VisualComponentsLayoutPolicy.this.parentVisualComponent.getAbsoluteLocation();
                rect.setLocation(rect.x - parentAbsolute.x, rect.y - parentAbsolute.y);
            }
            return rect;
        }

        public void componentMoved(int x, int y) {
            IFigure child = ((GraphicalEditPart)this.getHost()).getFigure();
            if (DO_VC_TRACING) {
                System.out.println("VC Component notification: " + ((IJavaObjectInstance)this.getHost().getModel()).eClass().getName() + " moved to (" + x + ',' + y + ')');
            }
            CDEUtilities.displayExec(this.getHost(), "MOVED", new Runnable(this, child){
                final /* synthetic */ ConstraintRefreshPolicy this$1;
                private final /* synthetic */ IFigure val$child;
                {
                    this.this$1 = constraintRefreshPolicy;
                    this.val$child = iFigure;
                }

                public void run() {
                    IFigure parent;
                    Rectangle bounds;
                    if (this.this$1.getHost() != null && this.this$1.getHost().isActive() && (bounds = (Rectangle)(parent = this.val$child.getParent()).getLayoutManager().getConstraint(this.val$child)) != null) {
                        bounds = bounds.getCopy();
                        Point currentLoc = this.this$1.visualComponent.getLocation();
                        if (DO_VC_TRACING) {
                            System.out.print("VC Component " + ((IJavaObjectInstance)this.this$1.getHost().getModel()).eClass().getName() + " moved to (beforeConvert)" + currentLoc);
                        }
                        bounds.setLocation(currentLoc.x, currentLoc.y);
                        bounds = this.this$1.convertBounds(bounds);
                        if (DO_VC_TRACING) {
                            System.out.println(" (afterConvert)" + bounds.getLocation());
                        }
                        ConstraintRefreshPolicy.access$0(this.this$1).constrain(bounds, parent, this.this$1.getHost());
                        parent.setConstraint(this.val$child, (Object)bounds);
                    }
                }
            });
        }

        public void componentResized(int width, int height) {
            IFigure child = ((GraphicalEditPart)this.getHost()).getFigure();
            CDEUtilities.displayExec(this.getHost(), "SIZED", new Runnable(this, child){
                final /* synthetic */ ConstraintRefreshPolicy this$1;
                private final /* synthetic */ IFigure val$child;
                {
                    this.this$1 = constraintRefreshPolicy;
                    this.val$child = iFigure;
                }

                public void run() {
                    IFigure parent;
                    Rectangle bounds;
                    if (this.this$1.getHost() != null && this.this$1.getHost().isActive() && (bounds = (Rectangle)(parent = this.val$child.getParent()).getLayoutManager().getConstraint(this.val$child)) != null) {
                        bounds = bounds.getCopy();
                        Dimension size = this.this$1.visualComponent.getSize();
                        if (DO_VC_TRACING) {
                            System.out.println("VC Component " + ((IJavaObjectInstance)this.this$1.getHost().getModel()).eClass().getName() + " resized to " + size);
                        }
                        bounds.setSize(size.width, size.height);
                        ConstraintRefreshPolicy.access$0(this.this$1).constrain(bounds, parent, this.this$1.getHost());
                        parent.setConstraint(this.val$child, (Object)bounds);
                    }
                }
            });
        }

        public void componentRefreshed() {
            this.signalRefresh();
        }

        public void componentShown() {
        }

        public void componentHidden() {
        }

        public void componentValidated() {
        }

        static /* synthetic */ VisualComponentsLayoutPolicy access$0(ConstraintRefreshPolicy constraintRefreshPolicy) {
            return constraintRefreshPolicy.VisualComponentsLayoutPolicy.this;
        }
    }
}

