/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.ZoomController;
import org.eclipse.ve.internal.cde.core.ZoomHelperDialog;

public class ZoomAction
extends EditorPartAction {
    public static final String ACTION_ID = "cdm.ZOOM";
    public static int ZOOM_DELTA = 20;

    public ZoomAction(IEditorPart part) {
        super(part);
        this.setText(CDEMessages.ZoomAction_label);
        this.setToolTipText(CDEMessages.ZoomAction_tooltip);
        this.setId(ACTION_ID);
        this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)CDEMessages.ZoomAction_image));
        this.setEnabled(true);
    }

    public void run() {
        ZoomController zoomController = ZoomController.getZoomController(this.getEditorPart());
        if (zoomController != null) {
            ZoomHelperDialog dialog = new ZoomHelperDialog(this.getEditorPart().getSite().getWorkbenchWindow().getShell(), zoomController.getZoomValue());
            dialog.open();
            int zoomValue = dialog.getZoomValue();
            if (zoomValue != 0) {
                zoomController.setZoomValue(zoomValue);
            }
        }
    }

    protected boolean calculateEnabled() {
        return false;
    }
}

