/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.utility.impl;

import java.util.Arrays;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.ve.internal.cde.utility.ConstantString;
import org.eclipse.ve.internal.cde.utility.GIFFileGraphic;
import org.eclipse.ve.internal.cde.utility.ResourceBundle;
import org.eclipse.ve.internal.cde.utility.TranslatableString;
import org.eclipse.ve.internal.cde.utility.URLResourceBundle;
import org.eclipse.ve.internal.cde.utility.UtilityFactory;
import org.eclipse.ve.internal.cde.utility.UtilityPackage;
import org.eclipse.ve.internal.cde.utility.impl.ConstantStringImpl;
import org.eclipse.ve.internal.cde.utility.impl.GIFFileGraphicImpl;
import org.eclipse.ve.internal.cde.utility.impl.TranslatableStringImpl;
import org.eclipse.ve.internal.cde.utility.impl.URLResourceBundleImpl;

public class UtilityFactoryImpl
extends EFactoryImpl
implements UtilityFactory {
    public static UtilityFactory init() {
        try {
            UtilityFactory theUtilityFactory = (UtilityFactory)EPackage.Registry.INSTANCE.getEFactory("http:///org/eclipse/ve/internal/cde/utility.ecore");
            if (theUtilityFactory != null) {
                return theUtilityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new UtilityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createConstantString();
            }
            case 3: {
                return this.createURLResourceBundle();
            }
            case 5: {
                return this.createGIFFileGraphic();
            }
            case 6: {
                return this.createTranslatableString();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public ConstantString createConstantString(String aString) {
        ConstantString o = this.createConstantString();
        o.setString(aString);
        return o;
    }

    public TranslatableString createTranslatableString(ResourceBundle bundle, String key) {
        TranslatableString o = this.createTranslatableString();
        o.setBundle(bundle);
        o.setKey(key);
        return o;
    }

    public ResourceBundle createURLResourceBundle(String[] urls, String bundleName) {
        URLResourceBundle o = this.createURLResourceBundle();
        o.getBundleURLs().add(Arrays.asList(urls));
        o.setBundleName(bundleName);
        return o;
    }

    public ResourceBundle createURLResourceBundle(String url, String bundleName) {
        URLResourceBundle o = this.createURLResourceBundle();
        o.getBundleURLs().add((Object)url);
        o.setBundleName(bundleName);
        return o;
    }

    public GIFFileGraphic createGIFFileGraphic(String resourceName) {
        GIFFileGraphic o = this.createGIFFileGraphic();
        o.setResourceName(resourceName);
        return o;
    }

    public GIFFileGraphic createGIFFileGraphic() {
        GIFFileGraphicImpl gifFileGraphic = new GIFFileGraphicImpl();
        return gifFileGraphic;
    }

    public ConstantString createConstantString() {
        ConstantStringImpl constantString = new ConstantStringImpl();
        return constantString;
    }

    public TranslatableString createTranslatableString() {
        TranslatableStringImpl translatableString = new TranslatableStringImpl();
        return translatableString;
    }

    public URLResourceBundle createURLResourceBundle() {
        URLResourceBundleImpl urlResourceBundle = new URLResourceBundleImpl();
        return urlResourceBundle;
    }

    public UtilityPackage getUtilityPackage() {
        return (UtilityPackage)this.getEPackage();
    }

    public static UtilityPackage getPackage() {
        return UtilityPackage.eINSTANCE;
    }
}

