/*******************************************************************************
 * Copyright (c) 2001, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ve.internal.jfc.beaninfo;
/*
 *  $RCSfile: ColorCellRenderer.java,v $
 *  $Revision: 1.4 $  $Date: 2005/08/24 23:38:11 $ 
 */

import java.awt.Color;
import java.awt.Component;

import javax.swing.*;
/**
 * This type was generated by a SmartGuide.
 */
public class ColorCellRenderer extends DefaultListCellRenderer {
	/**
	 * Comment for <code>serialVersionUID</code>
	 * 
	 * @since 1.1.0
	 */
	private static final long serialVersionUID = -4527896636294741007L;
	String colorNames[];
	Color colorValues[];
	SwatchIcon colorIcons[];
/**
 * ColorCellRenderer constructor comment.
 */
public ColorCellRenderer(String[] names, Color[] values) {
	super();

	colorNames = names;
	colorValues = values;
	colorIcons = new SwatchIcon[colorValues.length];
	for (int i=0; i<colorValues.length; i++) {
		colorIcons[i] = new SwatchIcon(colorValues[i]);
	}
}

public Component getListCellRendererComponent( JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
	//the second argument "value" is not used to get index
	String text = colorNames[index];
	super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
	setIcon(colorIcons[index]);
	setIconTextGap(5);
	setVerticalTextPosition(SwingConstants.CENTER);
	return this;
	
}

}
