/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.property;

import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.internal.propertysheet.StringPropertyDescriptor;

public class EmployeePropertySource
implements IPropertySource {
    protected Employee employee;
    protected IPropertyDescriptor[] descriptors;

    public EmployeePropertySource(Employee employee) {
        this.employee = employee;
    }

    public Object getEditableValue() {
        return this.employee;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new IPropertyDescriptor[]{new StringPropertyDescriptor((Object)"name", "name"), new StringPropertyDescriptor((Object)"phone", "phone number")};
            StringPropertyDescriptor pd = (StringPropertyDescriptor)this.descriptors[0];
            pd.setValidator((ICellEditorValidator)new NameValidator());
            pd.setAlwaysIncompatible(true);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object propertyKey) {
        if ("name".equals(propertyKey)) {
            return this.employee.getName();
        }
        if ("phone".equals(propertyKey)) {
            return this.employee.getPhone();
        }
        return null;
    }

    public boolean isPropertySet(Object propertyKey) {
        if ("name".equals(propertyKey)) {
            return this.employee.getName() != null;
        }
        if ("phone".equals(propertyKey)) {
            return this.employee.getPhone() != null;
        }
        return false;
    }

    public void resetPropertyValue(Object propertyKey) {
        if ("name".equals(propertyKey)) {
            this.employee.setName(PropertySupport.getUniqueEmployeeName(this.employee.getCompany(), null));
        } else if ("phone".equals(propertyKey)) {
            this.employee.setPhone(null);
        }
    }

    public void setPropertyValue(Object propertyKey, Object value) {
        if ("name".equals(propertyKey)) {
            this.employee.setName((String)value);
        } else if ("phone".equals(propertyKey)) {
            this.employee.setPhone((String)value);
        }
    }

    private class NameValidator
    implements ICellEditorValidator {
        protected Object[] sources;

        NameValidator() {
        }

        public String isValid(Object value) {
            if (value == null) {
                return null;
            }
            String name = (String)value;
            if (name.length() == 0) {
                return "There must be a name.";
            }
            if (name.equals(EmployeePropertySource.this.employee.getName())) {
                return null;
            }
            String newName = PropertySupport.getUniqueEmployeeName(EmployeePropertySource.this.employee.getCompany(), name);
            if (newName.equals(name)) {
                return null;
            }
            return "The name is not unique.";
        }

        public void setSources(Object[] sources) {
            this.sources = sources;
        }
    }
}

