/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.internal.cde.core.GenericAnnotationLinkagePolicy;
import org.eclipse.ve.internal.cdm.AnnotationGeneric;

public class CompanyAnnotationLinkagePolicy
extends GenericAnnotationLinkagePolicy {
    protected Company company;
    public static final String EMPLOYEE_PROTOCOL = "emp:";
    public static final String DEPARTMENT_PROTOCOL = "dept:";
    public static final String MANAGED_PROTOCOL = "managed:";
    protected PropertyChangeListener departmentListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("deptname".equals(evt.getPropertyName())) {
                CompanyAnnotationLinkagePolicy.this.changeID(CompanyAnnotationLinkagePolicy.DEPARTMENT_PROTOCOL + (String)evt.getOldValue(), CompanyAnnotationLinkagePolicy.DEPARTMENT_PROTOCOL + (String)evt.getNewValue());
                CompanyAnnotationLinkagePolicy.this.changeID(CompanyAnnotationLinkagePolicy.MANAGED_PROTOCOL + (String)evt.getOldValue(), CompanyAnnotationLinkagePolicy.MANAGED_PROTOCOL + (String)evt.getNewValue());
            }
        }
    };
    protected PropertyChangeListener employeeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("name".equals(evt.getPropertyName())) {
                CompanyAnnotationLinkagePolicy.this.changeID(CompanyAnnotationLinkagePolicy.EMPLOYEE_PROTOCOL + (String)evt.getOldValue(), CompanyAnnotationLinkagePolicy.EMPLOYEE_PROTOCOL + (String)evt.getNewValue());
            }
        }
    };

    public void setCompany(Company company) {
        this.company = company;
    }

    public Object getModelFromID(String id) {
        block4: {
            block3: {
                if (id.startsWith(EMPLOYEE_PROTOCOL)) {
                    String employeeid = id.substring(EMPLOYEE_PROTOCOL.length());
                    return this.company.getEmployee(employeeid);
                }
                if (!id.startsWith(DEPARTMENT_PROTOCOL)) break block3;
                String deptid = id.substring(DEPARTMENT_PROTOCOL.length());
                Iterator depts = this.company.getDepartments().iterator();
                while (depts.hasNext()) {
                    Department dept = (Department)depts.next();
                    if (!deptid.equals(dept.getDepartmentName())) continue;
                    return dept;
                }
                break block4;
            }
            if (!id.startsWith(MANAGED_PROTOCOL)) break block4;
            String deptid = id.substring(MANAGED_PROTOCOL.length());
            Iterator depts = this.company.getDepartments().iterator();
            while (depts.hasNext()) {
                Department dept = (Department)depts.next();
                if (!deptid.equals(dept.getDepartmentName())) continue;
                return new ManagedConnection(dept);
            }
        }
        return null;
    }

    protected boolean isAnnotationValidGeneric(AnnotationGeneric annotation) {
        if (!annotation.isSetAnnotatesID()) {
            return false;
        }
        String id = annotation.getAnnotatesID();
        Object model = this.getModelFromID(id);
        if (model != null) {
            if (model instanceof ManagedConnection) {
                Department d = ((ManagedConnection)model).department;
                return d.getManager() != null;
            }
            return true;
        }
        return false;
    }

    public String getIDFromModel(Object model) {
        if (model instanceof Employee) {
            return EMPLOYEE_PROTOCOL + ((Employee)model).getName();
        }
        if (model instanceof Department) {
            return DEPARTMENT_PROTOCOL + ((Department)model).getDepartmentName();
        }
        if (model instanceof ManagedConnection) {
            return MANAGED_PROTOCOL + ((ManagedConnection)model).department.getDepartmentName();
        }
        return null;
    }

    public List getContainedChildren(Object model) {
        if (model instanceof Department) {
            return ((Department)model).getEmployees();
        }
        if (model instanceof Company) {
            return ((Company)model).getDepartments();
        }
        return Collections.EMPTY_LIST;
    }

    protected Object linkingToID(String id) {
        Object model = this.getModelFromID(id);
        if (id != null) {
            if (model instanceof Employee) {
                ((Employee)model).addPropertyChangeListener("name", this.employeeListener);
            } else if (model instanceof Department) {
                ((Department)model).addPropertyChangeListener("deptname", this.departmentListener);
            } else {
                return null;
            }
            return model;
        }
        return null;
    }

    protected void unlinkingFromID(String id, Object model) {
        if (model != null) {
            if (model instanceof Employee) {
                ((Employee)model).removePropertyChangeListener("name", this.employeeListener);
            } else if (model instanceof Department) {
                ((Department)model).removePropertyChangeListener("deptname", this.departmentListener);
            }
        }
    }

    public static class ManagedConnection {
        public Department department;

        public ManagedConnection(Department department) {
            this.department = department;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ManagedConnection)) {
                return false;
            }
            return this.department.equals(((ManagedConnection)other).department);
        }

        public int hashCode() {
            return this.department.hashCode();
        }
    }
}

