/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.java.beaninfo;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import org.eclipse.ve.examples.java.beaninfo.DayCustomEditor;
import org.eclipse.ve.examples.java.beaninfo.DayHelper;

public class DayPropertyEditor
extends PropertyEditorSupport {
    protected int fDay;
    protected DayCustomEditor fEditor;

    public void setAsText(String text) throws IllegalArgumentException {
        int i = 0;
        while (i <= 6) {
            if (DayHelper.DAY_NAMES[i].equals(text)) {
                this.setValue(new Integer(i));
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException(String.valueOf(text) + " is not a valid weekday, e.g. Monday, Tuesday, etc...");
    }

    public Object getValue() {
        return new Integer(this.fEditor != null ? this.fEditor.getDay() : this.fDay);
    }

    public void setValue(Object aValue) {
        this.fDay = (Integer)aValue;
        if (this.fEditor != null) {
            this.fEditor.setDay(this.fDay);
        }
    }

    public String getAsText() {
        int day = (Integer)this.getValue();
        if (day >= 0 || day <= 6) {
            return DayHelper.DAY_NAMES[day];
        }
        return "UNKNOWN";
    }

    public String getJavaInitializationString() {
        return DayHelper.INIT_STRINGS[(Integer)this.getValue()];
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.fEditor == null) {
            this.fEditor = new DayCustomEditor(this.fDay);
        }
        return this.fEditor;
    }
}

