package com.abc.wizzowidgets;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Rectangle;

/**
 * Example JavaBean that has a shape property that takes a set of magic integer values
 * Based on the shape property the class will draw a shape
 */
public class Shape extends Canvas {
	
	public static final int NONE=0;
	public static final int OVAL = 1;
	public static final int DIAMOND = 2;
	private int shape;
	
	public Shape(){
	}
	
	public int getShape(){
		return shape;
	}
	public void setShape(int aShape){
		shape = aShape;
	}
	
	public void paint(Graphics g ){

		Rectangle bounds = getBounds();
		switch (shape) {
			case OVAL :
				g.fillOval(0,0,bounds.width,bounds.height);
				break;
			case DIAMOND :
				int centerX = bounds.width /2;
				int centerY = bounds.height/2;
				int[] xPoints = new int[] { centerX , bounds.width , centerX , 0 };
				int[] yPoints = new int[] { 0 , centerY , bounds.height , centerY };
				g.fillPolygon(xPoints,yPoints,4);
			default :
				break;
		}
	}
}
