/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout;

import java.util.List;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAddProperties;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.swt.model.layout.ILayoutDataInfo;
import org.eclipse.wb.internal.xwt.model.layout.LayoutDataPresentation;
import org.eclipse.wb.internal.xwt.model.layout.VirtualLayoutDataCreationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutDataInfo
extends XmlObjectInfo
implements ILayoutDataInfo {
    private ComplexProperty m_complexProperty;

    public LayoutDataInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.contributeLayoutDataProperty_toControl();
        this.deleteIfDefault();
    }

    private boolean isVirtual() {
        return this.getCreationSupport() instanceof VirtualLayoutDataCreationSupport;
    }

    public final IObjectPresentation getPresentation() {
        return new LayoutDataPresentation(this);
    }

    private void contributeLayoutDataProperty_toControl() {
        this.addBroadcastListener(new XmlObjectAddProperties(){

            public void invoke(XmlObjectInfo object, List<Property> properties) throws Exception {
                if (this.isActiveForControl(object)) {
                    LayoutDataInfo.this.addLayoutDataProperty(properties);
                }
            }

            private boolean isActiveForControl(XmlObjectInfo control) {
                return control.getChildren().contains((Object)LayoutDataInfo.this);
            }
        });
    }

    private void deleteIfDefault() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void endEdit_aboutToRefresh() throws Exception {
                if (!LayoutDataInfo.this.isDeleted() && LayoutDataInfo.this.getCreationSupport() instanceof ElementCreationSupport && LayoutDataInfo.this.getElement().getDocumentAttributes().isEmpty() && LayoutDataInfo.this.getElement().getChildren().isEmpty()) {
                    LayoutDataInfo.this.delete();
                }
            }
        });
    }

    private void addLayoutDataProperty(List<Property> properties) throws Exception {
        if (this.m_complexProperty == null) {
            Class componentClass = this.getDescription().getComponentClass();
            String text = "(" + componentClass.getName() + ")";
            this.m_complexProperty = new ComplexProperty("LayoutData", text){

                public boolean isModified() throws Exception {
                    return !LayoutDataInfo.this.isVirtual();
                }

                public void setValue(Object value) throws Exception {
                    if (value == UNKNOWN_VALUE) {
                        LayoutDataInfo.this.delete();
                    }
                }
            };
            this.m_complexProperty.setCategory(PropertyCategory.system((int)5));
            this.m_complexProperty.setProperties(this.getProperties());
        }
        properties.add((Property)this.m_complexProperty);
    }
}

