/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.parser;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.xwt.DefaultLoadingContext;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTLoaderManager;
import org.eclipse.e4.xwt.core.IElementLoaderFactory;
import org.eclipse.e4.xwt.core.IRenderingContext;
import org.eclipse.e4.xwt.core.IVisualElementLoader;
import org.eclipse.e4.xwt.internal.core.Core;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.javabean.ResourceLoader;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.metadata.ISetPostAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectSetObjectAfter;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.xml.model.utils.GlobalStateXml;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.xwt.parser.XwtParser;

public final class XwtRenderer {
    private final Map<String, XmlObjectInfo> m_pathToModelMap = Maps.newHashMap();
    private final Map<Object, XmlObjectInfo> m_objectToModelMap = Maps.newHashMap();
    private final XmlObjectInfo m_rootModel;
    private final EditorContext m_context;
    private final ISetPostAction m_setPostAction;
    private final IXWTLoader m_loaderXWT;
    private final Set<IMetaclass> m_knownMetaclassXWT = Sets.newHashSet();
    private final XmlObjectSetObjectAfter m_broadcast_setObjectAfter;

    public XwtRenderer(ControlInfo rootControl) throws Exception {
        this.m_loaderXWT = XWTLoaderManager.getActive();
        this.m_rootModel = rootControl;
        this.m_context = this.m_rootModel.getContext();
        this.m_broadcast_setObjectAfter = new XmlObjectSetObjectAfter(){

            public void invoke(XmlObjectInfo target, Object o) throws Exception {
                XwtRenderer.this.m_objectToModelMap.put(o, target);
            }
        };
        this.m_setPostAction = new ISetPostAction(){

            public void action(Object target, IProperty property, Object value) {
                XmlObjectInfo xmlObject = (XmlObjectInfo)XwtRenderer.this.m_objectToModelMap.get(target);
                if (xmlObject != null) {
                    xmlObject.registerAttributeValue(property.getName(), value);
                }
            }
        };
    }

    public void render() throws Exception {
        GlobalStateXml.activate((XmlObjectInfo)this.m_rootModel);
        this.m_rootModel.accept(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                XmlObjectInfo xmlObjectInfo;
                CreationSupport creationSupport;
                if (objectInfo instanceof XmlObjectInfo && !((creationSupport = (xmlObjectInfo = (XmlObjectInfo)objectInfo).getCreationSupport()) instanceof IImplicitCreationSupport)) {
                    DocumentElement element = creationSupport.getElement();
                    String path = XwtParser.getPath(element);
                    XwtRenderer.this.m_pathToModelMap.put(path, xmlObjectInfo);
                }
            }
        });
        this.m_context.getBroadcastSupport().addListener(null, (Object)this.m_broadcast_setObjectAfter);
        final IXWTLoader loader0 = XWTLoaderManager.getActive();
        IXWTLoader loader = (IXWTLoader)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IXWTLoader.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke((Object)loader0, args);
                String methodSignature = ReflectionUtils.getMethodSignature((Method)method);
                if (methodSignature.equals("registerMetaclass(java.lang.Class)") || methodSignature.equals("getMetaclass(java.lang.String,java.lang.String)")) {
                    IMetaclass metaclass = (IMetaclass)result;
                    XwtRenderer.this.hookProperties(metaclass);
                    this.hookProperties_ofExposedWidgets(metaclass);
                }
                return result;
            }

            private void hookProperties_ofExposedWidgets(IMetaclass metaclass) throws Exception {
                Method[] methodArray = metaclass.getType().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method typeMethod = methodArray[n2];
                    Class<?> returnType = typeMethod.getReturnType();
                    if (typeMethod.getParameterTypes().length == 0 && Widget.class.isAssignableFrom(returnType)) {
                        metaclass = (IMetaclass)ReflectionUtils.invokeMethod((Object)loader0, (String)"registerMetaclass(java.lang.Class)", (Object[])new Object[]{returnType});
                        XwtRenderer.this.hookProperties(metaclass);
                    }
                    ++n2;
                }
            }
        });
        Core profile = new Core(new IElementLoaderFactory(){
            private int m_level;

            public IVisualElementLoader createElementLoader(IRenderingContext context, IXWTLoader loader) {
                return new ResourceLoader(context, loader){
                    private final Set<Element> m_processedElements;
                    {
                        this.m_processedElements = Sets.newHashSet();
                    }

                    protected Integer getStyleValue(Element element, int styles) {
                        Integer styleValue = super.getStyleValue(element, styles);
                        if (styleValue != null) {
                            String path = XwtParser.getPath(element);
                            XmlObjectInfo xmlObject = (XmlObjectInfo)XwtRenderer.this.m_pathToModelMap.get(path);
                            if (xmlObject != null) {
                                xmlObject.registerAttributeValue("x:Style", (Object)styleValue);
                            }
                        }
                        return styleValue;
                    }

                    protected void postCreation0(final Element element, final Object targetObject) {
                        if (m_level > 1) {
                            return;
                        }
                        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                            public void run() throws Exception {
                                this.postCreationEx(element, targetObject);
                            }
                        });
                    }

                    private void postCreationEx(Element element, Object targetObject) throws Exception {
                        String path = XwtParser.getPath(element);
                        XmlObjectInfo xmlObjectInfo = (XmlObjectInfo)XwtRenderer.this.m_pathToModelMap.get(path);
                        if (xmlObjectInfo == null) {
                            return;
                        }
                        Class<?> targetClass = targetObject.getClass();
                        if (targetClass != xmlObjectInfo.getDescription().getComponentClass() && targetClass == Shell.class) {
                            return;
                        }
                        xmlObjectInfo.setObject(targetObject);
                    }

                    private boolean isRoot(Element element) {
                        if (!this.m_processedElements.contains(element)) {
                            this.m_processedElements.add(element);
                            String path = element.getPath();
                            return "0".equals(path);
                        }
                        return false;
                    }

                    protected Object doCreate(Object parent, Element element, Class<?> constraintType, Map<String, Object> options) throws Exception {
                        boolean isRoot = this.isRoot(element);
                        try {
                            if (isRoot) {
                                5 v0 = this;
                                v0.m_level = v0.m_level + 1;
                            }
                            Object object = super.doCreate(parent, element, constraintType, options);
                            return object;
                        }
                        finally {
                            if (isRoot) {
                                5 v1 = this;
                                v1.m_level = v1.m_level - 1;
                            }
                        }
                    }
                };
            }
        }, loader);
        XWT.applyProfile((Object)profile);
        ILoadingContext _loadingContext = XWT.getLoadingContext();
        XWT.setLoadingContext((ILoadingContext)new DefaultLoadingContext(this.m_context.getClassLoader()));
        try {
            URL url = this.m_context.getFile().getLocationURI().toURL();
            String content = this.m_context.getContent();
            Map options = Maps.newHashMap();
            options.put("XWT.DesignMode", Boolean.TRUE);
            content = this.removeCompositeClassAttribute(content);
            XwtParser.configureForForms(this.m_context, options);
            XWT.loadWithOptions((InputStream)IOUtils.toInputStream((String)content), (URL)url, (Map)options);
        }
        finally {
            XWT.setLoadingContext((ILoadingContext)_loadingContext);
            XWT.restoreProfile();
        }
    }

    private String removeCompositeClassAttribute(String content) {
        DocumentElement rootElement = this.m_context.getRootElement();
        DocumentAttribute classAttribute = rootElement.getDocumentAttribute("x:Class");
        if (rootElement.getTagLocal().equals("Composite") && classAttribute != null) {
            int begin = classAttribute.getNameOffset();
            int end = classAttribute.getValueOffset() + classAttribute.getValueLength() + 1;
            content = String.valueOf(content.substring(0, begin)) + StringUtils.repeat((String)" ", (int)(end - begin)) + content.substring(end);
        }
        return content;
    }

    private void hookProperties(IMetaclass metaclass) {
        if (this.m_knownMetaclassXWT.contains(metaclass)) {
            return;
        }
        this.m_knownMetaclassXWT.add(metaclass);
        IProperty[] iPropertyArray = metaclass.getProperties();
        int n = iPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty property = iPropertyArray[n2];
            property.addSetPostAction(this.m_setPostAction);
            ++n2;
        }
    }

    public void dispose() {
        this.m_context.getBroadcastSupport().removeListener(null, (Object)this.m_broadcast_setObjectAfter);
        IMetaclass[] iMetaclassArray = this.m_loaderXWT.getAllMetaclasses();
        int n = iMetaclassArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetaclass metaclass = iMetaclassArray[n2];
            IProperty[] iPropertyArray = metaclass.getProperties();
            int n3 = iPropertyArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IProperty property = iPropertyArray[n4];
                property.removeSetPostAction(this.m_setPostAction);
                ++n4;
            }
            ++n2;
        }
    }
}

