/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions.errors;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.actions.errors.BadNodesParserErrorPage;
import org.eclipse.wb.internal.core.editor.actions.errors.BadNodesRefreshErrorPage;
import org.eclipse.wb.internal.core.editor.actions.errors.ErrorsDialog;
import org.eclipse.wb.internal.core.editor.actions.errors.IErrorPage;
import org.eclipse.wb.internal.core.editor.actions.errors.WarningsErrorPage;

public class ErrorsAction
extends Action {
    private final List<IErrorPage> m_pages = Lists.newArrayList();
    private ObjectInfo m_rootObject;

    public ErrorsAction() {
        this.setImageDescriptor(DesignerPlugin.getImageDescriptor("actions/errors/errors.gif"));
        this.setDisabledImageDescriptor(DesignerPlugin.getImageDescriptor("actions/errors/errors_disabled.gif"));
        this.setToolTipText(Messages.ErrorsAction_toolTip);
        this.m_pages.add(new BadNodesRefreshErrorPage());
        this.m_pages.add(new WarningsErrorPage());
        this.m_pages.add(new BadNodesParserErrorPage());
    }

    public void setRoot(ObjectInfo rootObject) {
        this.m_rootObject = rootObject;
        this.m_rootObject.addBroadcastListener(new ObjectEventListener(){

            public void refreshed() throws Exception {
                ErrorsAction.this.update();
            }
        });
        this.update();
    }

    public void run() {
        ErrorsDialog errorsDialog = new ErrorsDialog(DesignerPlugin.getShell(), this.m_rootObject, this.m_pages);
        errorsDialog.open();
    }

    private void update() {
        this.firePropertyChange("enabled", null, null);
    }

    public boolean isEnabled() {
        for (IErrorPage errorPage : this.m_pages) {
            errorPage.setRoot(this.m_rootObject);
            if (!errorPage.hasErrors()) continue;
            return true;
        }
        return false;
    }
}

