/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescriptionKey;
import org.eclipse.wb.internal.core.model.description.ConfigurablePropertyDescription;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.ExposingRule;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.order.ComponentOrder;
import org.eclipse.wb.internal.core.model.order.ComponentOrderDefault;
import org.eclipse.wb.internal.core.model.order.MethodOrder;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterCreation;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.ObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDescription
extends AbstractDescription
implements IComponentDescription {
    private final ComponentDescriptionKey m_key;
    private boolean m_cached;
    private boolean m_presentationCached;
    private ToolkitDescription m_toolkit;
    private final Class<?> m_componentClass;
    private Class<?> m_modelClass;
    private BeanInfo m_beanInfo;
    private BeanDescriptor m_beanDescriptor;
    private List<PropertyDescriptor> m_propertyDescriptors;
    private final List<ConstructorDescription> m_constructors = Lists.newArrayList();
    private final List<MethodDescription> m_methods = Lists.newArrayList();
    private final Map<String, MethodDescription> m_methodsMap = Maps.newTreeMap();
    private MethodOrder m_defaultMethodOrder = new MethodOrderAfterCreation();
    private ComponentOrder m_order = ComponentOrderDefault.INSTANCE;
    private final List<GenericPropertyDescription> m_properties = Lists.newArrayList();
    private final Map<String, GenericPropertyDescription> m_idToProperty = Maps.newHashMap();
    private final Map<String, ConfigurablePropertyDescription> m_idToConfigurableProperty = Maps.newHashMap();
    private final Map<String, String> m_parameters = Maps.newTreeMap();
    private CreationDescription m_creationDefault;
    private final Map<String, CreationDescription> m_creations = Maps.newHashMap();
    private final List<ExposingRule> m_exposingRules = Lists.newArrayList();
    private final List<MorphingTargetDescription> m_morphingTargets = Lists.newArrayList();
    private String m_description;
    private Class<?> m_currentClass;
    private Image m_icon;

    public ComponentDescription(ComponentDescriptionKey key) {
        this.m_key = key;
        if (this.m_key != null) {
            this.m_componentClass = this.m_key.getComponentClass();
            this.m_description = this.m_componentClass.getName();
        } else {
            this.m_componentClass = null;
        }
    }

    public ComponentDescriptionKey getKey() {
        return this.m_key;
    }

    public String toString() {
        String methods_toString = ", m=" + this.m_methods;
        String parameters_toString = ", p=" + this.m_parameters;
        return String.valueOf(this.m_modelClass.getName()) + "(" + this.m_componentClass.getName() + methods_toString + parameters_toString + ")";
    }

    public boolean isCached() {
        return this.m_cached;
    }

    public void setCached(boolean cached) {
        this.m_cached = cached;
    }

    public boolean isPresentationCached() {
        return this.m_presentationCached;
    }

    public void setPresentationCached(boolean presentationCached) {
        this.m_presentationCached = presentationCached;
    }

    @Override
    public ToolkitDescription getToolkit() {
        return this.m_toolkit;
    }

    public void setToolkit(ToolkitDescription toolkit) {
        this.m_toolkit = toolkit;
    }

    @Override
    public Class<?> getComponentClass() {
        return this.m_componentClass;
    }

    @Override
    public Class<?> getModelClass() {
        return this.m_modelClass;
    }

    public void setModelClass(Class<?> modelClass) {
        this.m_modelClass = modelClass;
    }

    public BeanInfo getBeanInfo() {
        return this.m_beanInfo;
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        Assert.isNull(this.m_beanInfo);
        this.m_beanInfo = beanInfo;
    }

    public BeanDescriptor getBeanDescriptor() {
        return this.m_beanDescriptor;
    }

    public void setBeanDescriptor(BeanDescriptor beanDescriptor) {
        this.m_beanDescriptor = beanDescriptor;
    }

    public List<PropertyDescriptor> getPropertyDescriptors() {
        return this.m_propertyDescriptors;
    }

    public void setPropertyDescriptors(List<PropertyDescriptor> propertyDescriptors) {
        this.m_propertyDescriptors = propertyDescriptors;
    }

    public List<ConstructorDescription> getConstructors() {
        return this.m_constructors;
    }

    public void addConstructor(ConstructorDescription constructor) {
        int index = this.m_constructors.indexOf(constructor);
        if (index != -1) {
            ConstructorDescription existingConstructor = this.m_constructors.get(index);
            existingConstructor.join(constructor);
        } else {
            Constructor<?> reflectionConstructor = ReflectionUtils.getConstructorBySignature(this.m_componentClass, constructor.getSignature());
            Assert.isNotNull2(reflectionConstructor, "{0} has no constructor with signature {1}", this.m_componentClass, constructor.getSignature());
            this.m_constructors.add(constructor);
        }
    }

    public ConstructorDescription getConstructor(IMethodBinding methodBinding) {
        if (!methodBinding.isConstructor()) {
            return null;
        }
        String signature = AstNodeUtils.getMethodDeclarationSignature(methodBinding);
        ConstructorDescription constructorDescription = this.getConstructor(signature);
        return constructorDescription;
    }

    @Deprecated
    public ConstructorDescription getConstructor(String signature) {
        for (ConstructorDescription constructor : this.m_constructors) {
            if (!constructor.getSignature().equals(signature)) continue;
            return constructor;
        }
        return null;
    }

    public List<MethodDescription> getMethods() {
        return this.m_methods;
    }

    public MethodDescription addMethod(Method method) throws Exception {
        String methodSignature = ReflectionUtils.getMethodSignature(method);
        MethodDescription methodDescription = this.getMethod(methodSignature);
        if (methodDescription == null) {
            methodDescription = new MethodDescription(method);
            this.addMethod(methodDescription);
        }
        return methodDescription;
    }

    public void addMethod(MethodDescription method) {
        int index = this.m_methods.indexOf(method);
        if (index != -1) {
            this.m_methods.get(index).join(method);
        } else {
            this.m_methods.add(method);
        }
        this.m_methodsMap.clear();
    }

    public MethodDescription getMethod(IMethodBinding methodBinding) {
        String signature = AstNodeUtils.getMethodSignature(methodBinding);
        return this.getMethod(signature);
    }

    public MethodDescription getMethod(String signature) {
        if (this.m_methodsMap.isEmpty()) {
            for (MethodDescription method : this.m_methods) {
                String methodSignature = method.getSignature();
                this.m_methodsMap.put(methodSignature, method);
            }
        }
        return this.m_methodsMap.get(signature);
    }

    public MethodOrder getDefaultMethodOrder() {
        return this.m_defaultMethodOrder;
    }

    public void setDefaultMethodOrder(MethodOrder defaultMethodOrder) {
        this.m_defaultMethodOrder = defaultMethodOrder;
    }

    public ComponentOrder getOrder() {
        return this.m_order;
    }

    public void setOrder(String specification) {
        this.m_order = ComponentOrder.parse(specification);
    }

    public List<GenericPropertyDescription> getProperties() {
        return Collections.unmodifiableList(this.m_properties);
    }

    public GenericPropertyDescription getProperty(String id) {
        GenericPropertyDescription property = this.m_idToProperty.get(id);
        if (property == null && !EnvironmentUtils.isTestingTime()) {
            property = new GenericPropertyDescription(id, "NO_SUCH_PROPERTY");
        }
        Assert.isNotNull(property, "Can not find property with id '" + id + "'.");
        return property;
    }

    public void addProperty(GenericPropertyDescription property) {
        String id = property.getId();
        GenericPropertyDescription existingProperty = this.m_idToProperty.get(id);
        if (existingProperty == null) {
            this.registerProperty(property);
            this.m_properties.add(property);
        } else {
            existingProperty.join(property);
        }
    }

    public void registerProperty(GenericPropertyDescription property) {
        String id = property.getId();
        this.m_idToProperty.put(id, property);
    }

    public Collection<ConfigurablePropertyDescription> getConfigurableProperties() {
        return this.m_idToConfigurableProperty.values();
    }

    public void addConfigurableProperty(ConfigurablePropertyDescription property) {
        this.m_idToConfigurableProperty.put(property.getId(), property);
    }

    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public boolean hasTrueParameter(String name) {
        String parameter = this.getParameter(name);
        return "true".equals(parameter);
    }

    public List<CreationDescription> getCreations() {
        List creations = Lists.newArrayList((Iterable)this.m_creations.values());
        creations.add(this.m_creationDefault);
        return creations;
    }

    public CreationDescription getCreation(String creationId) {
        CreationDescription creation = this.m_creations.get(creationId);
        if (creation != null) {
            return creation;
        }
        return this.m_creationDefault;
    }

    public void setCreationDefault(CreationDescription creationDefault) {
        this.m_creationDefault = creationDefault;
    }

    public void addCreation(CreationDescription creation) {
        this.m_creations.put(creation.getId(), creation);
    }

    public void clearCreations() {
        this.m_creations.clear();
    }

    public List<ExposingRule> getExposingRules() {
        return this.m_exposingRules;
    }

    public void addExposingRule(ExposingRule rule) {
        this.m_exposingRules.add(0, rule);
    }

    public List<MorphingTargetDescription> getMorphingTargets() {
        return this.m_morphingTargets;
    }

    public void addMorphingTarget(MorphingTargetDescription morphingTarget) {
        this.m_morphingTargets.add(morphingTarget);
    }

    public void clearMorphingTargets() {
        this.m_morphingTargets.clear();
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        if (description != null) {
            this.m_description = StringUtilities.normalizeWhitespaces(description);
            this.m_description = StringUtils.replace((String)this.m_description, (String)"\\n", (String)"\n");
        } else {
            this.m_description = this.m_componentClass.getName();
        }
    }

    public void joinProperties() throws Exception {
        for (ConstructorDescription constructor : this.getConstructors()) {
            for (ParameterDescription parameter : constructor.getParameters()) {
                GenericPropertyDescription property;
                PropertyEditor editor;
                String propertyId = parameter.getProperty();
                if (propertyId == null || (editor = (property = this.getProperty(propertyId)).getEditor()) == null) continue;
                parameter.setEditor(editor);
            }
        }
        this.useObjectPropertyEditor();
        Iterator<GenericPropertyDescription> I = this.m_properties.iterator();
        while (I.hasNext()) {
            GenericPropertyDescription property = I.next();
            if (property.getEditor() != null) continue;
            I.remove();
            this.m_idToProperty.remove(property.getId());
        }
    }

    private void useObjectPropertyEditor() {
        for (GenericPropertyDescription property : this.m_properties) {
            if (property.getEditor() != null || !ComponentDescription.shouldUseObjectPropertyEditor(property)) continue;
            property.setEditor(ObjectPropertyEditor.INSTANCE);
            if (property.getCategory() != PropertyCategory.NORMAL) continue;
            property.setCategory(PropertyCategory.ADVANCED);
        }
    }

    private static boolean shouldUseObjectPropertyEditor(GenericPropertyDescription property) {
        if (property.hasTrueTag("useObjectEditor")) {
            return true;
        }
        Method setter = property.getSetter();
        return setter != null && !ComponentDescription.isStandardMethod(setter);
    }

    private static boolean isStandardMethod(Method setter) {
        String declaringClassName = setter.getDeclaringClass().getName();
        List<IConfigurationElement> elements = ExternalFactoriesHelper.getElements("org.eclipse.wb.core.standardToolkitPackages", "package");
        for (IConfigurationElement element : elements) {
            String prefix = ExternalFactoriesHelper.getRequiredAttribute(element, "prefix");
            if (!declaringClassName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Class<?> getCurrentClass() {
        return this.m_currentClass;
    }

    public void setCurrentClass(Class<?> currentClass) {
        this.m_currentClass = currentClass;
    }

    @Override
    public Image getIcon() {
        return this.m_icon;
    }

    public void setIcon(Image icon) {
        this.m_icon = icon;
    }

    @Override
    public void visit(JavaInfo javaInfo, int state) throws Exception {
        super.visit(javaInfo, state);
        for (GenericPropertyDescription property : this.m_idToProperty.values()) {
            property.visit(javaInfo, state);
        }
    }
}

