/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generic;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerConfiguration;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleContainerConfigurable
implements SimpleContainer {
    private final JavaInfo m_container;
    private final SimpleContainerConfiguration m_configuration;

    public SimpleContainerConfigurable(JavaInfo container, SimpleContainerConfiguration configuration) {
        this.m_container = container;
        this.m_configuration = configuration;
    }

    @Override
    public boolean isEmpty() {
        return this.getChild() == null;
    }

    @Override
    public Object getChild() {
        for (ObjectInfo child : this.getContainerChildren()) {
            if (!this.validateComponent(child)) continue;
            return child;
        }
        return null;
    }

    @Override
    public boolean validateComponent(Object component) {
        return this.m_configuration.getComponentValidator().validate(this.m_container, component);
    }

    private List<ObjectInfo> getContainerChildren() {
        String signature = "getSimpleContainerChildren()";
        Method method = ReflectionUtils.getMethodBySignature(this.m_container.getClass(), signature);
        if (method != null) {
            return (List)ReflectionUtils.invokeMethodEx(this.m_container, signature, new Object[0]);
        }
        return this.m_container.getChildren();
    }

    @Override
    public void command_CREATE(Object newObject) throws Exception {
        if (!this.tryDuckTyping("command_CREATE", newObject)) {
            this.command_CREATE_default(newObject);
        }
        this.tryDuckTyping("command_CREATE_after", newObject);
        this.tryDuckTyping("command_TARGET_after", newObject);
    }

    @Override
    public void command_ADD(Object moveObject) throws Exception {
        if (!this.tryDuckTyping("command_ADD", moveObject)) {
            this.command_ADD_default(moveObject);
        }
        this.tryDuckTyping("command_ADD_after", moveObject);
        this.tryDuckTyping("command_TARGET_after", moveObject);
    }

    private void command_CREATE_default(Object newObject) throws Exception {
        JavaInfo component = (JavaInfo)newObject;
        AssociationObject associationObject = this.createAssociationObject();
        JavaInfoUtils.add(component, associationObject, this.m_container, null);
    }

    private void command_ADD_default(Object moveObject) throws Exception {
        JavaInfo component = (JavaInfo)moveObject;
        AssociationObject associationObject = this.createAssociationObject();
        JavaInfoUtils.move(component, associationObject, this.m_container, null);
    }

    private AssociationObject createAssociationObject() {
        return this.m_configuration.getAssociationObjectFactory().create();
    }

    private boolean tryDuckTyping(String methodName, Object object) throws Exception {
        Method method = this.getCommandMethod(methodName, object);
        if (method != null) {
            method.invoke((Object)this.m_container, object);
            return true;
        }
        return false;
    }

    private Method getCommandMethod(String methodName, Object object) {
        Method[] methodArray = this.m_container.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypes;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && (parameterTypes = method.getParameterTypes()).length == 1 && ReflectionUtils.isAssignableFrom(parameterTypes[0], object)) {
                return method;
            }
            ++n2;
        }
        return null;
    }
}

