/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetVariable;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyncParentChildVariableNameSupport<T extends JavaInfo> {
    protected final T m_childInfo;
    public static final String TEMPLATE_FOR_DEFAULT = "${defaultName}";

    public SyncParentChildVariableNameSupport(T layoutData) {
        this.m_childInfo = layoutData;
        ((ObjectInfo)this.m_childInfo).addBroadcastListener(new JavaInfoSetVariable(){

            public void invoke(JavaInfo javaInfo, VariableSupport oldVariable, VariableSupport newVariable) throws Exception {
                JavaInfo parent;
                if (javaInfo == SyncParentChildVariableNameSupport.this.m_childInfo && oldVariable instanceof EmptyVariableSupport && newVariable instanceof AbstractNamedVariableSupport && (parent = ((JavaInfo)SyncParentChildVariableNameSupport.this.m_childInfo).getParentJava()) != null && parent.getVariableSupport() instanceof AbstractNamedVariableSupport) {
                    SyncParentChildVariableNameSupport.this.setNewName();
                }
            }
        });
        ((ObjectInfo)this.m_childInfo).addBroadcastListener(new JavaEventListener(){

            public void variable_setName(AbstractNamedVariableSupport variableSupport) throws Exception {
                JavaInfo parent = ((JavaInfo)SyncParentChildVariableNameSupport.this.m_childInfo).getParentJava();
                if (variableSupport.getJavaInfo() == parent && ((JavaInfo)SyncParentChildVariableNameSupport.this.m_childInfo).getVariableSupport() instanceof AbstractNamedVariableSupport && parent.getVariableSupport() instanceof AbstractNamedVariableSupport) {
                    SyncParentChildVariableNameSupport.this.setNewName();
                }
            }
        });
    }

    private void setNewName() throws Exception {
        String newName = this.generateName();
        if (newName != null) {
            ((JavaInfo)this.m_childInfo).getVariableSupport().setName(newName);
        }
    }

    protected static boolean isValidTemplate(String[] templates, String template) {
        return ArrayUtils.contains((Object[])templates, (Object)template);
    }

    protected String generateName() {
        String template = this.getTemplate();
        if (template.equals(this.getTemplateForDefault()) || StringUtils.isEmpty((String)template)) {
            return null;
        }
        return StrSubstitutor.replace((Object)template, this.getValueMap());
    }

    protected String getTemplateForDefault() {
        return TEMPLATE_FOR_DEFAULT;
    }

    protected abstract String getTemplate();

    protected abstract Map<String, String> getValueMap();

    public String getClassName() {
        return CodeUtils.getShortClass(((JavaInfo)this.m_childInfo).getDescription().getComponentClass().getName());
    }

    public String getAcronym() {
        return StringUtilities.extractCamelCaps(this.getClassName()).toLowerCase();
    }

    public String getParentName() {
        return ((JavaInfo)this.m_childInfo).getParentJava().getVariableSupport().getComponentName();
    }

    public String getParentNameCap() {
        return StringUtils.capitalize((String)this.getParentName());
    }
}

