/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IExposedCreationSupport;
import org.eclipse.wb.internal.core.model.variable.AbstractNoNameVariableSupport;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public final class ThisVariableSupport
extends AbstractNoNameVariableSupport {
    private final MethodDeclaration m_constructor;

    public ThisVariableSupport(JavaInfo javaInfo, MethodDeclaration constructor) {
        super(javaInfo);
        this.m_constructor = constructor;
    }

    public String toString() {
        return "this";
    }

    public String getTitle() throws Exception {
        Class<?> objectClass = this.m_javaInfo.getDescription().getComponentClass();
        return "(" + objectClass.getName() + ")";
    }

    public String getComponentName() {
        return "this";
    }

    public boolean isValidStatementForChild(Statement statement) {
        return true;
    }

    public MethodDeclaration getConstructor() {
        return this.m_constructor;
    }

    public boolean hasExpression(NodeTarget target) {
        return true;
    }

    public String getReferenceExpression(NodeTarget target) throws Exception {
        return "this";
    }

    public String getAccessExpression(NodeTarget target) throws Exception {
        return "";
    }

    public StatementTarget getStatementTarget() throws Exception {
        Statement statement;
        MethodDeclaration forcedMethod = ThisVariableSupport.forced_getMethod(this.m_javaInfo);
        if (forcedMethod != null) {
            return new StatementTarget(forcedMethod, true);
        }
        List<Statement> statements = DomGenerics.statements(this.m_constructor.getBody());
        if (!statements.isEmpty() && (statement = statements.get(0)) instanceof SuperConstructorInvocation) {
            return new StatementTarget(statement, false);
        }
        return new StatementTarget(this.m_constructor, true);
    }

    public static StatementTarget getForcedTarget(JavaInfo javaInfo) throws Exception {
        if (!ThisVariableSupport.shouldUseForcedTarget(javaInfo)) {
            return null;
        }
        MethodDeclaration forcedMethod = ThisVariableSupport.forced_getMethod(javaInfo);
        if (forcedMethod != null) {
            return new StatementTarget(forcedMethod, false);
        }
        return null;
    }

    private static boolean shouldUseForcedTarget(JavaInfo container) {
        if (container.getVariableSupport() instanceof ThisVariableSupport) {
            return true;
        }
        if (container.getCreationSupport() instanceof IExposedCreationSupport) {
            IExposedCreationSupport exposedCreationSupport = (IExposedCreationSupport)((Object)container.getCreationSupport());
            JavaInfo host = exposedCreationSupport.getHostJavaInfo();
            return ThisVariableSupport.shouldUseForcedTarget(host);
        }
        if (ExposedPropertyCreationSupport.isReplacementForExposed(container)) {
            JavaInfo host = container.getParentJava();
            return ThisVariableSupport.shouldUseForcedTarget(host);
        }
        return false;
    }

    private static MethodDeclaration forced_getMethod(JavaInfo javaInfo) throws Exception {
        if (!((javaInfo = javaInfo.getRootJava()).getVariableSupport() instanceof ThisVariableSupport)) {
            return null;
        }
        MethodDeclaration constructor = ((ThisVariableSupport)javaInfo.getVariableSupport()).getConstructor();
        String forcedMethodName = ThisVariableSupport.forced_getMethodName(javaInfo);
        if (forcedMethodName == null) {
            return null;
        }
        MethodDeclaration existingMethod = ThisVariableSupport.forced_getExistingMethod(javaInfo, constructor, forcedMethodName);
        if (existingMethod != null) {
            return existingMethod;
        }
        return ThisVariableSupport.forced_getNewMethod(javaInfo, forcedMethodName);
    }

    private static MethodDeclaration forced_getExistingMethod(JavaInfo javaInfo, MethodDeclaration constructor, String forcedMethodName) {
        MethodInvocation invocation;
        ExpressionStatement expressionStatement;
        List<Statement> statements;
        Statement statement;
        Block body = constructor.getBody();
        while ((statement = GenericsUtils.getLastOrNull(statements = DomGenerics.statements(body))) instanceof TryStatement) {
            body = ((TryStatement)statement).getBody();
        }
        if (statement instanceof ExpressionStatement && (expressionStatement = (ExpressionStatement)statement).getExpression() instanceof MethodInvocation && (invocation = (MethodInvocation)expressionStatement.getExpression()).getName().getIdentifier().equals(forcedMethodName)) {
            String methodSignature = AstNodeUtils.getMethodSignature(invocation);
            TypeDeclaration typeDeclaration = (TypeDeclaration)constructor.getParent();
            MethodDeclaration methodDeclaration = AstNodeUtils.getMethodBySignature(typeDeclaration, methodSignature);
            if (methodDeclaration != null) {
                return methodDeclaration;
            }
        }
        return null;
    }

    private static MethodDeclaration forced_getNewMethod(JavaInfo parent, String forcedMethodName) throws Exception {
        JavaInfo root = parent.getRootJava();
        if (!(root.getVariableSupport() instanceof ThisVariableSupport)) {
            return null;
        }
        final MethodDeclaration constructor = ((ThisVariableSupport)root.getVariableSupport()).getConstructor();
        final boolean[] validNodes = new boolean[]{true};
        root.accept(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                if (objectInfo instanceof JavaInfo) {
                    JavaInfo javaInfo = (JavaInfo)objectInfo;
                    for (ASTNode node : javaInfo.getRelatedNodes()) {
                        MethodDeclaration method = AstNodeUtils.getEnclosingMethod(node);
                        if (method == null) continue;
                        validNodes[0] = validNodes[0] & method == constructor;
                    }
                }
            }
        });
        if (!validNodes[0]) {
            return null;
        }
        AstEditor editor = root.getEditor();
        MethodDeclaration forcedMethod = editor.addMethodDeclaration("private void " + forcedMethodName + "()", Collections.<String>emptyList(), new BodyDeclarationTarget((BodyDeclaration)constructor, false));
        ArrayList<Statement> statements = new ArrayList<Statement>(DomGenerics.statements(constructor));
        for (Statement statement : statements) {
            if (statement instanceof SuperConstructorInvocation || ThisVariableSupport.forced_hasReferenceOnMethodParameter(statement)) continue;
            editor.moveStatement(statement, new StatementTarget(forcedMethod, false));
        }
        editor.addStatement(String.valueOf(forcedMethodName) + "();", new StatementTarget(constructor, false));
        return forcedMethod;
    }

    private static String forced_getMethodName(JavaInfo javaInfo) {
        return javaInfo.getDescription().getToolkit().getGenerationSettings().getForcedMethodName();
    }

    private static boolean forced_hasReferenceOnMethodParameter(Statement statement) {
        final MethodDeclaration method = AstNodeUtils.getEnclosingMethod((ASTNode)statement);
        final AtomicBoolean result = new AtomicBoolean(false);
        statement.accept(new ASTVisitor(){

            public void endVisit(SimpleName node) {
                if (!result.get() && AstNodeUtils.isVariable((ASTNode)node) && this.isReferenceOnParameter(node)) {
                    result.set(true);
                }
            }

            private boolean isReferenceOnParameter(SimpleName variable) {
                IVariableBinding binding = AstNodeUtils.getVariableBinding((ASTNode)variable);
                for (SingleVariableDeclaration parameter : DomGenerics.parameters(method)) {
                    if (parameter.resolveBinding() != binding) continue;
                    return true;
                }
                return false;
            }
        });
        return result.get();
    }
}

