/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.AnonymousTypeDeclaration2;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstCodeGeneration;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstParser;
import org.eclipse.wb.internal.core.utils.ast.AstVisitorEx;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.IASTEditorCommitListener;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.ast.binding.BindingContext;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerMethodBinding;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerTypeBinding;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstEditor {
    public static final String DEFAULT_END_OF_LINE = System.getProperty("line.separator", "\n");
    private static final String REMOVED_COMMENT = "ASTEditor.REMOVED_COMMENT";
    private final ICompilationUnit m_modelUnit;
    private final CompilationUnit m_astUnit;
    private String m_oldContent;
    private final Document m_document;
    private IASTEditorCommitListener m_commitListener;
    private static final Set<Method> m_invalidNodeMethods = Sets.newHashSet();
    private final Map<String, Object> m_globalMap = Maps.newTreeMap();
    private final BindingContext m_bindingContext = new BindingContext();
    private final AstParser m_parser = new AstParser(this);
    private final AstCodeGeneration m_generation = new AstCodeGeneration(this);
    private boolean m_resolveImports = true;

    public AstEditor(ICompilationUnit modelUnit) throws Exception {
        this.m_modelUnit = modelUnit;
        this.m_astUnit = CodeUtils.parseCompilationUnit(modelUnit);
        this.m_oldContent = this.m_modelUnit.getBuffer().getContents();
        this.m_document = new Document(this.m_oldContent);
    }

    public IJavaProject getJavaProject() {
        return this.m_modelUnit.getJavaProject();
    }

    public IProject getProject() {
        return this.getJavaProject().getProject();
    }

    public ICompilationUnit getModelUnit() {
        return this.m_modelUnit;
    }

    public CompilationUnit getAstUnit() {
        return this.m_astUnit;
    }

    public boolean hasCompilationErrors() {
        IProblem[] iProblemArray = this.m_astUnit.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public TypeDeclaration getPrimaryType() {
        String unitName = this.m_modelUnit.getElementName();
        String typeName = StringUtils.removeEnd((String)unitName, (String)".java");
        return AstNodeUtils.getTypeByName(this.m_astUnit, typeName);
    }

    public IType getModelType(TypeDeclaration typeDeclaration) {
        String name = typeDeclaration.getName().getIdentifier();
        return this.m_modelUnit.getType(name);
    }

    public ASTNode getEnclosingNode(String source) {
        int position = this.getSource().indexOf(source);
        Assert.isTrue(position != -1, "Can not find %s in %s.", source, this.getSource());
        return AstNodeUtils.getEnclosingNode((ASTNode)this.m_astUnit, position);
    }

    public ASTNode getEnclosingNode(int position) {
        return AstNodeUtils.getEnclosingNode((ASTNode)this.m_astUnit, position);
    }

    public Statement getEnclosingStatement(int position) {
        return AstNodeUtils.getEnclosingStatement(this.getEnclosingNode(position));
    }

    public Block getEnclosingBlock(int position) {
        return AstNodeUtils.getEnclosingBlock(this.getEnclosingNode(position));
    }

    public MethodDeclaration getEnclosingMethod(int position) {
        return AstNodeUtils.getEnclosingMethod(this.getEnclosingNode(position));
    }

    public TypeDeclaration getEnclosingType(int position) {
        return AstNodeUtils.getEnclosingType(this.getEnclosingNode(position));
    }

    public void setCommitListener(IASTEditorCommitListener commitListener) {
        this.m_commitListener = commitListener;
    }

    public void commitChanges() throws Exception {
        String newContent;
        if (this.m_commitListener != null) {
            this.m_commitListener.aboutToCommit();
        }
        if (!this.m_oldContent.equals(newContent = this.m_document.get()) && (this.m_commitListener == null || this.m_commitListener.canEditBaseFile())) {
            int[] intervals = StringUtilities.getDifferenceIntervals(this.m_oldContent, newContent);
            this.m_modelUnit.getBuffer().replace(intervals[0], intervals[1], newContent.substring(intervals[2], intervals[2] + intervals[3]));
            this.m_oldContent = newContent;
        }
        if (this.m_commitListener != null) {
            this.m_commitListener.commitDone();
        }
    }

    public void saveChanges(boolean forceSave) throws Exception {
        this.commitChanges();
        if (forceSave || !this.m_modelUnit.isWorkingCopy()) {
            this.m_modelUnit.getBuffer().save(null, false);
            this.m_modelUnit.save(null, false);
        }
    }

    public char getChar(int position) {
        try {
            return this.m_document.getChar(position);
        }
        catch (BadLocationException e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public String getWhitespaceToLeft(int end, boolean includeEOL) {
        int start = end;
        while (start != 0) {
            char c = this.getChar(start - 1);
            if (!Character.isWhitespace(c) || !includeEOL && (c == '\r' || c == '\n')) break;
            --start;
        }
        return this.getSourceBeginEnd(start, end);
    }

    public int getLineNumber(int index) {
        try {
            return this.m_document.getLineOfOffset(index);
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public int getLineBegin(int index) {
        try {
            IRegion lineInformation = this.m_document.getLineInformationOfOffset(index);
            return lineInformation.getOffset();
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public int getLineEnd(int index) {
        try {
            IRegion lineInformation = this.m_document.getLineInformationOfOffset(index);
            return lineInformation.getOffset() + lineInformation.getLength();
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public int skipWhitespaceToLeft(int end, boolean includeEOL) {
        int start = end;
        while (start != 0) {
            char c = this.getChar(start - 1);
            if (!Character.isWhitespace(c) || !includeEOL && (c == '\r' || c == '\n')) break;
            --start;
        }
        return start;
    }

    public int skipWhitespaceAndPureEOLCToLeft(int end) throws Exception {
        int index = end - this.getWhitespaceToLeft(end, false).length();
        if (index == 0) {
            return index;
        }
        while (true) {
            int line;
            int lineOffset;
            String lineString;
            int firstNonWhitespace;
            if ((firstNonWhitespace = StringUtils.indexOfAnyBut((String)(lineString = this.getSource(lineOffset = this.m_document.getLineOffset(line = this.m_document.getLineOfOffset(index - 1)), this.m_document.getLineLength(line))), (String)" \t\r\n")) == -1) {
                index = lineOffset;
                continue;
            }
            if (!lineString.substring(firstNonWhitespace).startsWith("//")) break;
            index = lineOffset;
        }
        return index;
    }

    public int skipSingleEOLToLeft(int index) throws Exception {
        if (this.m_document.getChar(index - 1) == '\n') {
            --index;
        }
        if (this.m_document.getChar(index - 1) == '\r') {
            --index;
        }
        return index;
    }

    private static String getIndentedSource(List<String> lines, String indent, String singleIndent, String eol) {
        StringBuffer buffer = new StringBuffer();
        for (String line : lines) {
            if (buffer.length() != 0) {
                buffer.append(eol);
            }
            buffer.append(indent);
            if (line.length() == 0) continue;
            int tabsCount = StringUtils.indexOfAnyBut((String)line, (String)"\t");
            if (tabsCount != -1) {
                buffer.append(StringUtils.repeat((String)singleIndent, (int)tabsCount));
                buffer.append(line.substring(tabsCount));
                continue;
            }
            buffer.append(StringUtils.repeat((String)singleIndent, (int)line.length()));
        }
        return buffer.toString();
    }

    public int indexOf(String subString) {
        return this.indexOf(subString, 0);
    }

    public int indexOf(String subString, int startPos) {
        int index = this.indexOf_noEx(subString, startPos);
        if (index != -1) {
            return index;
        }
        throw new IllegalArgumentException("Can not find '" + subString + "' starting from " + startPos);
    }

    private int indexOf_noEx(String subString, int startPos) {
        return this.m_document.get().indexOf(subString, startPos);
    }

    private int indexOfAny(String searchChars, int startPos) throws Exception {
        int i = startPos;
        while (i < this.m_document.getLength()) {
            char c = this.m_document.getChar(i);
            int j = 0;
            while (j < searchChars.length()) {
                if (searchChars.charAt(j) == c) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        throw new IllegalArgumentException("Can not find '" + searchChars + "' starting from " + startPos);
    }

    private int indexOfAnyBut(String searchChars, int startPos) throws Exception {
        int i = startPos;
        while (i < this.m_document.getLength()) {
            block3: {
                char c = this.m_document.getChar(i);
                int j = 0;
                while (j < searchChars.length()) {
                    if (searchChars.charAt(j) != c) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Can not find '" + searchChars + "' starting from " + startPos);
    }

    public int indexOfCharBackward(char searchChar, int endPos) {
        int i = endPos - 1;
        while (i != 0) {
            char c = this.getChar(i);
            if (c == searchChar) {
                return i;
            }
            --i;
        }
        throw new IllegalArgumentException("Can not find '" + searchChar + "' starting from " + endPos);
    }

    private int indexOfAnyButBackward(String searchChars, int startPos) throws Exception {
        int i = startPos - 1;
        while (i != 0) {
            block3: {
                char c = this.m_document.getChar(i);
                int j = 0;
                while (j < searchChars.length()) {
                    if (searchChars.charAt(j) != c) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            --i;
        }
        throw new IllegalArgumentException("Can not find '" + searchChars + "' starting from " + startPos);
    }

    public int getStringLiteralNumberOnLine(StringLiteral stringLiteral) {
        final int slLine = this.getLineNumber(stringLiteral.getStartPosition());
        StringLiteral lineNode = stringLiteral;
        while (this.getLineNumber(lineNode.getStartPosition()) == slLine && this.getLineNumber(lineNode.getStartPosition() + lineNode.getLength()) == slLine) {
            lineNode = lineNode.getParent();
        }
        final List literals = Lists.newArrayList();
        lineNode.accept(new ASTVisitor(){

            public void endVisit(StringLiteral literal) {
                if (AstEditor.this.getLineNumber(literal.getStartPosition()) == slLine) {
                    literals.add(literal);
                }
            }
        });
        return literals.indexOf(stringLiteral);
    }

    public void addEndOfLineComment(int position, String comment) throws Exception {
        int endOfLinePosition = this.getLineEnd(position);
        this.replaceSubstring(endOfLinePosition, 0, comment);
    }

    public String getEndOfLineComment(int position) {
        int lineBegin = this.getLineBegin(position);
        int lineEnd = this.getLineEnd(position);
        int commentBegin = this.indexOf_noEx("//", lineBegin);
        if (commentBegin != -1 && commentBegin < lineEnd) {
            return this.getSource(commentBegin, lineEnd - commentBegin);
        }
        return null;
    }

    public void removeEndOfLineComment(int position, String commentToRemove) throws Exception {
        int lineBegin = this.getLineBegin(position);
        int lineEnd = this.getLineEnd(position);
        int commentBegin = this.indexOf_noEx(commentToRemove, lineBegin);
        if (commentBegin != -1 && commentBegin < lineEnd) {
            int commentEnd = commentBegin + commentToRemove.length();
            commentEnd = this.indexOfAnyBut(" \t", commentEnd);
            this.replaceSubstring(commentBegin, commentEnd - commentBegin, "");
            int newCommentBegin = this.indexOfAnyButBackward(" \t", commentBegin) + 1;
            if (newCommentBegin != commentBegin) {
                if (this.m_document.get(commentBegin, 2).equals("//")) {
                    ++newCommentBegin;
                }
                this.replaceSubstring(newCommentBegin, commentBegin - newCommentBegin, "");
            }
        }
    }

    Document getBuffer() {
        return this.m_document;
    }

    public String getSource() {
        return this.m_document.get();
    }

    public void setSource(String source) {
        this.m_document.set(source);
    }

    public String getSource(ASTNode node) {
        return this.getSource(node.getStartPosition(), node.getLength());
    }

    public String getSource(int start, int length) {
        try {
            return this.m_document.get(start, length);
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    public String getSourceBeginEnd(int begin, int end) {
        return this.getSource(begin, end - begin);
    }

    public String getExternalSource(final ASTNode theNode, final Function<ASTNode, String> transformer) {
        final StringBuffer buffer = new StringBuffer(this.getSource(theNode));
        final Map nodePositions = Maps.newHashMap();
        theNode.accept(new ASTVisitor(){

            public void postVisit(ASTNode _node) {
                nodePositions.put(_node, _node.getStartPosition());
            }
        });
        theNode.accept((ASTVisitor)new GenericVisitor(){

            protected boolean visitNode(ASTNode node) {
                String source;
                if (transformer != null && (source = (String)transformer.apply((Object)node)) != null) {
                    this.replace(node, source);
                    return false;
                }
                return true;
            }

            public void endVisit(SimpleName name) {
                StructuralPropertyDescriptor location;
                if (!(AstNodeUtils.isVariable((ASTNode)name) || (location = name.getLocationInParent()) != SimpleType.NAME_PROPERTY && location != QualifiedName.QUALIFIER_PROPERTY && location != ClassInstanceCreation.NAME_PROPERTY && location != MethodInvocation.EXPRESSION_PROPERTY)) {
                    String fullyQualifiedName = AstNodeUtils.getFullyQualifiedName((Expression)name, false);
                    this.replace((ASTNode)name, fullyQualifiedName);
                }
            }

            private void replace(ASTNode node, String newSource) {
                int nodePosition = (Integer)nodePositions.get(node);
                int sourceStart = nodePosition - theNode.getStartPosition();
                int n = sourceStart + node.getLength();
                buffer.replace(sourceStart, n, newSource);
                int lengthDelta = newSource.length() - node.getLength();
                for (Map.Entry entry : nodePositions.entrySet()) {
                    Integer position = (Integer)entry.getValue();
                    if (position <= nodePosition) continue;
                    entry.setValue(position + lengthDelta);
                }
            }
        });
        return buffer.toString();
    }

    public String getTypeBindingSource(ITypeBinding typeBinding) {
        String genericTypeName = AstNodeUtils.getFullyQualifiedName(typeBinding, false, true);
        genericTypeName = StringUtils.replace((String)genericTypeName, (String)",", (String)", ");
        return genericTypeName;
    }

    public void replaceSubstring(ASTNode node, String replacement) throws Exception {
        this.replaceSubstring(node.getStartPosition(), node.getLength(), replacement);
    }

    public void replaceSubstring(final int oldStart, int oldLength, String replacement) throws Exception {
        this.replaceSubstring_markRemovedComments(oldStart, oldLength);
        List<Comment> commentList = this.getCommentList();
        this.m_document.replace(oldStart, oldLength, replacement);
        int newLength = replacement.length();
        final int difference = newLength - oldLength;
        final int oldEnd = oldStart + oldLength;
        ASTVisitor visitor = new ASTVisitor(true){

            public void postVisit(ASTNode node) {
                AnonymousTypeDeclaration2 anonymous;
                int position = node.getStartPosition();
                int length = node.getLength();
                int end = position + length;
                if (position < oldStart && oldStart < end && oldEnd > end) {
                    throw new DesignerException(201, new String[0]);
                }
                if (position < oldEnd && oldEnd < end && oldStart < position) {
                    throw new DesignerException(201, new String[0]);
                }
                if (end > oldStart) {
                    if (position >= oldEnd && !(node instanceof CompilationUnit)) {
                        node.setSourceRange(position + difference, length);
                    } else if (position <= oldStart && position + length >= oldEnd) {
                        node.setSourceRange(position, length + difference);
                    }
                }
                if ((anonymous = (AnonymousTypeDeclaration2)node.getProperty("AnonymousTypeDeclaration")) != null) {
                    anonymous.setSourceRange(node.getStartPosition(), node.getLength());
                }
            }
        };
        this.m_astUnit.accept(visitor);
        for (Comment comment : commentList) {
            if (comment instanceof Javadoc) continue;
            comment.accept(visitor);
        }
    }

    private void replaceSubstring_markRemovedComments(int begin, int length) {
        List<Comment> comments = DomGenerics.getCommentList(this.m_astUnit);
        for (Comment comment : comments) {
            if (AstNodeUtils.getSourceBegin((ASTNode)comment) < begin || AstNodeUtils.getSourceEnd((ASTNode)comment) >= begin + length) continue;
            comment.setProperty(REMOVED_COMMENT, (Object)Boolean.TRUE);
        }
    }

    public List<Comment> getCommentList() throws Exception {
        List comments = Lists.newArrayList();
        comments.addAll(DomGenerics.getCommentList(this.m_astUnit));
        int documentLength = this.m_document.getLength();
        Iterator I = comments.iterator();
        while (I.hasNext()) {
            Comment comment = (Comment)I.next();
            if (comment.getProperty(REMOVED_COMMENT) != null) {
                I.remove();
                continue;
            }
            if (AstNodeUtils.getSourceBegin((ASTNode)comment) < 0 || AstNodeUtils.getSourceEnd((ASTNode)comment) > documentLength) {
                I.remove();
                continue;
            }
            if (comment instanceof LineComment) {
                if (this.getSource((ASTNode)comment).startsWith("//")) continue;
                I.remove();
                continue;
            }
            if (!(comment instanceof BlockComment) || this.getSource((ASTNode)comment).startsWith("/*")) continue;
            I.remove();
        }
        return Collections.unmodifiableList(comments);
    }

    public static void replaceNode(ASTNode originalNode, ASTNode replacementNode) throws Exception {
        ASTNode parent = originalNode.getParent();
        if (AstEditor.replaceNode_QualifiedName_to_FieldAccess(originalNode, replacementNode)) {
            return;
        }
        Class<?> parentClass = parent.getClass();
        Method[] methodArray = parentClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 0 && !m_invalidNodeMethods.contains(method)) {
                String methodName = method.getName();
                Class<?> returnType = method.getReturnType();
                try {
                    List elements;
                    int index;
                    if (methodName.startsWith("get") && returnType.isAssignableFrom(originalNode.getClass()) && method.invoke((Object)parent, new Object[0]) == originalNode) {
                        String setMethodName = "set" + methodName.substring("get".length());
                        Method setMethod = parentClass.getMethod(setMethodName, returnType);
                        setMethod.invoke((Object)parent, replacementNode);
                        break;
                    }
                    if (returnType == List.class && (index = (elements = (List)method.invoke((Object)parent, new Object[0])).indexOf(originalNode)) != -1) {
                        elements.set(index, replacementNode);
                        break;
                    }
                }
                catch (InvocationTargetException e) {
                    Assert.isTrue(e.getCause() instanceof UnsupportedOperationException);
                    m_invalidNodeMethods.add(method);
                }
            }
            ++n2;
        }
    }

    private static boolean replaceNode_QualifiedName_to_FieldAccess(ASTNode originalNode, ASTNode replacementNode) throws Exception {
        ASTNode parent = originalNode.getParent();
        if (parent instanceof QualifiedName && !(replacementNode instanceof Name)) {
            QualifiedName qualifiedName = (QualifiedName)parent;
            FieldAccess fieldAccess = originalNode.getAST().newFieldAccess();
            AstNodeUtils.copySourceRange((ASTNode)fieldAccess, (ASTNode)qualifiedName);
            fieldAccess.setExpression((Expression)replacementNode);
            SimpleName fieldName = qualifiedName.getName();
            qualifiedName.setName(originalNode.getAST().newSimpleName("__wbp_tmp"));
            fieldAccess.setName(fieldName);
            AstEditor.replaceNode((ASTNode)qualifiedName, (ASTNode)fieldAccess);
            return true;
        }
        return false;
    }

    public Expression replaceExpression(Expression oldExpression, String source) throws Exception {
        if (source.indexOf("\n") != -1) {
            String[] lines = StringUtils.split((String)source, (String)"\n");
            return this.replaceExpression(oldExpression, Arrays.asList(lines));
        }
        return this.replaceExpressionString(oldExpression, source);
    }

    public Expression replaceExpression(Expression oldExpression, List<String> lines) throws Exception {
        AstCodeGeneration generation = this.getGeneration();
        String singleIndent = generation.getIndentation(1);
        String eol = generation.getEndOfLine();
        Statement enclosingNode = null;
        enclosingNode = AstNodeUtils.getEnclosingStatement((ASTNode)oldExpression);
        if (enclosingNode == null) {
            enclosingNode = (ASTNode)AstNodeUtils.getEnclosingNode((ASTNode)oldExpression, BodyDeclaration.class);
        }
        Assert.isNotNull(enclosingNode, "No enclosing node found for " + oldExpression);
        String indent = this.getWhitespaceToLeft(enclosingNode.getStartPosition(), false);
        String source = AstEditor.getIndentedSource(lines, indent, singleIndent, eol);
        source = source.trim();
        return this.replaceExpressionString(oldExpression, source);
    }

    private Expression replaceExpressionString(Expression oldExpression, String source) throws Exception {
        int oldStart = oldExpression.getStartPosition();
        int oldLength = oldExpression.getLength();
        source = this.replaceSourceTemplates(oldStart, source);
        Expression newExpression = this.getParser().parseExpression(oldStart, source);
        this.replaceSubstring(oldStart, oldLength, source);
        AstEditor.replaceNode((ASTNode)oldExpression, (ASTNode)newExpression);
        this.resolveImports((ASTNode)newExpression);
        return newExpression;
    }

    public Expression replaceInvocationArgument(MethodInvocation invocation, int index, String source) throws Exception {
        Expression argument = DomGenerics.arguments(invocation).get(index);
        return this.replaceExpression(argument, source);
    }

    public void replaceVariableType(VariableDeclaration declaration, String newTypeName) throws Exception {
        Type type;
        VariableDeclarationStatement declarationStatement = null;
        FieldDeclaration fieldDeclaration = null;
        if (declaration.getLocationInParent() == VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
            declarationStatement = (VariableDeclarationStatement)declaration.getParent();
            type = declarationStatement.getType();
        } else if (declaration.getLocationInParent() == FieldDeclaration.FRAGMENTS_PROPERTY) {
            fieldDeclaration = (FieldDeclaration)declaration.getParent();
            type = fieldDeclaration.getType();
        } else {
            throw new IllegalArgumentException("Unknown argument: " + declaration.getClass());
        }
        Type newType = this.getParser().parseQualifiedType(type.getStartPosition(), newTypeName);
        this.replaceSubstring((ASTNode)type, newTypeName);
        if (declarationStatement != null) {
            declarationStatement.setType(newType);
        }
        if (fieldDeclaration != null) {
            fieldDeclaration.setType(newType);
        }
        this.resolveImports((ASTNode)newType);
    }

    public Object getGlobalValue(String key) {
        return this.m_globalMap.get(key);
    }

    public void putGlobalValue(String key, Object value) {
        this.m_globalMap.put(key, value);
    }

    public void removeGlobalValue(String key) {
        this.m_globalMap.remove(key);
    }

    public String getUniqueVariableName(int position, String baseName, VariableDeclaration excludedVariable) {
        List declarations = Lists.newArrayList();
        if (position != -1) {
            declarations.addAll(AstNodeUtils.getVariableDeclarationsVisibleAt((ASTNode)this.m_astUnit, position));
            declarations.addAll(AstNodeUtils.getVariableDeclarationsAfter((ASTNode)this.m_astUnit, position));
        } else {
            declarations.addAll(AstNodeUtils.getVariableDeclarationsAll((ASTNode)this.m_astUnit));
        }
        declarations.remove(excludedVariable);
        return AstEditor.getUniqueVariableName(declarations, baseName);
    }

    public static String getUniqueVariableName(List<VariableDeclaration> declarations, String baseName) {
        final Set existingIdentifiers = Sets.newTreeSet();
        for (VariableDeclaration declaration : declarations) {
            existingIdentifiers.add(declaration.getName().getIdentifier());
        }
        return CodeUtils.generateUniqueName(baseName, new Predicate<String>(){

            public boolean apply(String name) {
                return !existingIdentifiers.contains(name);
            }
        });
    }

    public String getUniqueMethodName(String baseName) {
        final Set existingMethods = Sets.newTreeSet();
        this.m_astUnit.accept(new ASTVisitor(){

            public void endVisit(MethodDeclaration node) {
                existingMethods.add(node.getName().getIdentifier());
            }

            public void endVisit(TypeDeclaration node) {
                AstEditor.addMethodNames(existingMethods, AstNodeUtils.getTypeBinding(node));
            }
        });
        return CodeUtils.generateUniqueName(baseName, new Predicate<String>(){

            public boolean apply(String name) {
                return !existingMethods.contains(name);
            }
        });
    }

    public String getUniqueTypeName(String baseName) {
        final Set existingTypes = Sets.newTreeSet();
        this.m_astUnit.accept(new ASTVisitor(){

            public void endVisit(TypeDeclaration node) {
                existingTypes.add(node.getName().getIdentifier());
            }
        });
        return CodeUtils.generateUniqueName(baseName, new Predicate<String>(){

            public boolean apply(String name) {
                return !existingTypes.contains(name);
            }
        });
    }

    private static void addMethodNames(Set<String> existingMethods, ITypeBinding typeBinding) {
        if (typeBinding != null) {
            IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                existingMethods.add(method.getName());
                ++n2;
            }
            AstEditor.addMethodNames(existingMethods, typeBinding.getSuperclass());
        }
    }

    public void setIdentifier(SimpleName simpleName, String newIdentifier) throws Exception {
        this.replaceSubstring((ASTNode)simpleName, newIdentifier);
        simpleName.setIdentifier(newIdentifier);
    }

    public BindingContext getBindingContext() {
        return this.m_bindingContext;
    }

    public AstParser getParser() {
        return this.m_parser;
    }

    public AstCodeGeneration getGeneration() {
        return this.m_generation;
    }

    private String replaceSourceTemplates(int position, String src) {
        String replacement;
        ASTNode coveringNode;
        if (src.indexOf("{wbp_class}") != -1) {
            coveringNode = this.getEnclosingNode(position);
            MethodDeclaration methodDeclaration = AstNodeUtils.getEnclosingMethod(coveringNode);
            Assert.isNotNull(methodDeclaration);
            IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(methodDeclaration);
            if (AstNodeUtils.isStatic(methodBinding)) {
                TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType(coveringNode);
                ITypeBinding typeBinding = typeDeclaration.resolveBinding();
                replacement = String.valueOf(AstNodeUtils.getFullyQualifiedName(typeBinding, false)) + ".class";
            } else {
                replacement = "getClass()";
            }
            src = StringUtils.replace((String)src, (String)"{wbp_class}", (String)replacement);
        }
        if (src.indexOf("{wbp_classTop}") != -1) {
            coveringNode = this.getEnclosingNode(position);
            TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingTypeTop(coveringNode);
            ITypeBinding typeBinding = typeDeclaration.resolveBinding();
            replacement = String.valueOf(AstNodeUtils.getFullyQualifiedName(typeBinding, false)) + ".class";
            src = StringUtils.replace((String)src, (String)"{wbp_classTop}", (String)replacement);
        }
        return src;
    }

    public void inlineParenthesizedExpression(Expression expression) throws Exception {
        while (expression.getParent() instanceof ParenthesizedExpression) {
            ParenthesizedExpression parent = (ParenthesizedExpression)expression.getParent();
            parent.setExpression((Expression)expression.getAST().newSimpleName("__wbp_tmp"));
            AstEditor.replaceNode((ASTNode)parent, (ASTNode)expression);
            this.replaceSubstring(parent.getStartPosition(), parent.getLength(), this.getSource((ASTNode)expression));
            AstNodeUtils.setSourceBegin((ASTNode)expression, parent.getStartPosition());
        }
    }

    public boolean hasEnclosingTryStatement(Statement statement, String requiredException) throws Exception {
        IType requiredExceptionType = this.getJavaProject().findType(requiredException);
        Assert.isNotNull2(requiredExceptionType, "No such exception type: {0}", requiredException);
        ITypeHierarchy requiredHierarchy = requiredExceptionType.newSupertypeHierarchy(null);
        while (true) {
            ASTNode parent;
            if ((parent = statement.getParent()) instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)parent;
                List<CatchClause> catchClauses = DomGenerics.catchClauses(tryStatement);
                for (CatchClause catchClause : catchClauses) {
                    SingleVariableDeclaration exception = catchClause.getException();
                    String exceptionName = AstNodeUtils.getFullyQualifiedName(exception, false);
                    IType exceptionType = this.getJavaProject().findType(exceptionName);
                    if (!requiredHierarchy.contains(exceptionType)) continue;
                    return true;
                }
            }
            if (!(parent instanceof Statement)) break;
            statement = (Statement)parent;
        }
        return false;
    }

    public TryStatement encloseInTryStatement(Statement statement, String catchExceptionType) throws Exception {
        String line_1 = "try {";
        String line_2 = "} catch (" + catchExceptionType + " e) {";
        String line_3 = "}";
        TryStatement tryStatement = (TryStatement)this.addStatement((List)ImmutableList.of((Object)line_1, (Object)line_2, (Object)line_3), new StatementTarget(statement, true));
        this.moveStatement(statement, new StatementTarget(tryStatement.getBody(), true));
        return tryStatement;
    }

    public void removeEmptyTryStatements() {
        this.m_astUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void endVisitEx(TryStatement node) throws Exception {
                if (node.getBody().statements().isEmpty()) {
                    AstEditor.this.removeStatement((Statement)node);
                }
            }
        });
    }

    public Block encloseInBlock(Statement statement) throws Exception {
        Block block = (Block)this.addStatement((List)ImmutableList.of((Object)"{", (Object)"}"), new StatementTarget(statement, true));
        this.moveStatement(statement, new StatementTarget(block, true));
        return block;
    }

    public void inlineBlock(Block block) throws Exception {
        StatementTarget target = new StatementTarget((Statement)block, true);
        List statements = Lists.newArrayList(DomGenerics.statements(block));
        for (Statement statement : statements) {
            this.moveStatement(statement, target);
        }
        this.removeStatement((Statement)block);
    }

    private Block ensureParentBlock(Statement statement) throws Exception {
        ASTNode parent = statement.getParent();
        if (parent instanceof Block) {
            return (Block)parent;
        }
        AstCodeGeneration generation = this.getGeneration();
        String singleIndent = generation.getIndentation(1);
        String eol = generation.getEndOfLine();
        String indent = this.getWhitespaceToLeft(parent.getStartPosition(), false);
        boolean statementIsLastInParent = AstNodeUtils.getSourceEnd(parent) == AstNodeUtils.getSourceEnd((ASTNode)statement);
        int statementBegin = statement.getStartPosition();
        int positionForBlock = this.indexOfAnyButBackward(" \t\r\n", statementBegin) + 1;
        String source = " {" + eol;
        source = String.valueOf(source) + indent + singleIndent;
        int positionForStatement = positionForBlock + source.length();
        source = String.valueOf(source) + eol;
        source = String.valueOf(source) + indent + "}";
        this.replaceSubstring(positionForBlock, statementBegin - positionForBlock, source);
        Block newBlock = (Block)this.getParser().parseStatement(positionForBlock, source);
        statementBegin = statement.getStartPosition();
        int statementEnd = this.getStatementEndIndex(statement);
        int statementLength = statementEnd - statementBegin;
        this.moveSource(positionForStatement, statementBegin, statementLength);
        AstNodeUtils.setSourceLength((ASTNode)newBlock, newBlock.getLength() + statementLength);
        AstEditor.replaceNode((ASTNode)statement, (ASTNode)newBlock);
        DomGenerics.statements(newBlock).add(statement);
        if (statementIsLastInParent) {
            AstNodeUtils.setSourceEnd(parent, (ASTNode)newBlock);
        }
        return newBlock;
    }

    public Statement addStatement(String source, StatementTarget target) throws Exception {
        String[] lines = StringUtils.split((String)source, (char)'\n');
        return this.addStatement(Arrays.asList(lines), target);
    }

    public Statement addStatement(List<String> lines, StatementTarget target) throws Exception {
        Statement newStatement;
        Assert.isNotNull(lines);
        Assert.isTrue(target.getBlock() != null || target.getStatement() != null);
        AstCodeGeneration generation = this.getGeneration();
        String singleIndent = generation.getIndentation(1);
        String eol = generation.getEndOfLine();
        if (target.getStatement() != null) {
            Statement newStatement2;
            Statement targetStatement = target.getStatement();
            Block targetBlock = this.ensureParentBlock(targetStatement);
            String indent = this.getWhitespaceToLeft(targetStatement.getStartPosition(), false);
            int index = targetBlock.statements().indexOf(targetStatement);
            String source = AstEditor.getIndentedSource(lines, indent, singleIndent, eol);
            source = this.replaceSourceTemplates(targetStatement.getStartPosition(), source);
            if (target.isBefore()) {
                int position = this.skipWhitespaceAndPureEOLCToLeft(targetStatement.getStartPosition());
                this.replaceSubstring(position, 0, String.valueOf(source) + eol);
                newStatement2 = this.getParser().parseStatement(position, source);
                DomGenerics.statements(targetBlock).add(index, newStatement2);
            } else {
                int position = this.getStatementEndIndex(targetStatement);
                source = String.valueOf(eol) + source;
                this.replaceSubstring(position, 0, source);
                newStatement2 = this.getParser().parseStatement(position, source);
                DomGenerics.statements(targetBlock).add(index + 1, newStatement2);
            }
            this.resolveImports((ASTNode)newStatement2);
            return newStatement2;
        }
        Block targetBlock = target.getBlock();
        String indent = targetBlock.getParent() instanceof MethodDeclaration ? this.getWhitespaceToLeft(targetBlock.getParent().getStartPosition(), false) : this.getWhitespaceToLeft(targetBlock.getStartPosition(), false);
        indent = String.valueOf(indent) + singleIndent;
        String source = AstEditor.getIndentedSource(lines, indent, singleIndent, eol);
        source = this.replaceSourceTemplates(targetBlock.getStartPosition(), source);
        if (target.isBefore()) {
            int position = targetBlock.getStartPosition();
            Assert.isTrue(position != -1);
            String prefix = eol;
            this.replaceSubstring(++position, 0, String.valueOf(prefix) + source);
            newStatement = this.getParser().parseStatement(position += prefix.length(), source);
            DomGenerics.statements(targetBlock).add(0, newStatement);
        } else {
            int position = AstNodeUtils.getSourceEnd((ASTNode)targetBlock) - 1;
            String endMethodIndent = this.getWhitespaceToLeft(position, false);
            this.replaceSubstring(position -= endMethodIndent.length(), 0, String.valueOf(source) + eol);
            newStatement = this.getParser().parseStatement(position, source);
            DomGenerics.statements(targetBlock).add(newStatement);
        }
        this.resolveImports((ASTNode)newStatement);
        return newStatement;
    }

    public void removeStatement(Statement statement) throws Exception {
        if (AstNodeUtils.isDanglingNode((ASTNode)statement)) {
            return;
        }
        Block block = (Block)statement.getParent();
        List<Statement> statements = DomGenerics.statements(block);
        if (statements.size() == 1 && block.getParent() instanceof Block) {
            this.removeStatement((Statement)block);
        } else {
            int startIndex;
            int index = statements.indexOf(statement);
            if (index != 0) {
                Statement prevStatement = statements.get(index - 1);
                startIndex = AstNodeUtils.getSourceEnd((ASTNode)prevStatement);
            } else {
                startIndex = block.getStartPosition() + "{".length();
            }
            int endIndex = this.getStatementEndIndex(statement);
            statements.remove(statement);
            this.replaceSubstring(startIndex, endIndex - startIndex, "");
        }
    }

    public void removeEnclosingStatement(ASTNode node) throws Exception {
        Statement statement = AstNodeUtils.getEnclosingStatement(node);
        this.removeStatement(statement);
    }

    private void reindentSource(int sourceStart, int sourceLength, String indent, String eol) throws Exception {
        String source = this.getSource(sourceStart, sourceLength);
        String[] lines = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)source, (String)eol);
        int position = sourceStart;
        String oldIndent = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String lineIndent = "";
            int endOfIndent = StringUtils.indexOfAnyBut((String)line, (String)"\t ");
            lineIndent = endOfIndent != -1 ? line.substring(0, endOfIndent) : line;
            if (oldIndent == null) {
                oldIndent = lineIndent;
            }
            if (lineIndent.startsWith(oldIndent)) {
                this.replaceSubstring(position, oldIndent.length(), indent);
                position += indent.length() - oldIndent.length();
            }
            position += line.length() + eol.length();
            ++n2;
        }
    }

    public void moveStatement(Statement statement, StatementTarget target) throws Exception {
        Assert.isTrue(target.getBlock() != null || target.getStatement() != null);
        if (target.getStatement() != null) {
            Statement targetStatement = target.getStatement();
            if (targetStatement == statement) {
                return;
            }
            Block targetBlock = (Block)targetStatement.getParent();
            List<Statement> targetStatements = DomGenerics.statements(targetBlock);
            if (statement.getParent() == targetStatement.getParent() && (target.isBefore() ? targetStatements.indexOf(statement) == targetStatements.indexOf(targetStatement) - 1 : targetStatements.indexOf(statement) == targetStatements.indexOf(targetStatement) + 1)) {
                return;
            }
        } else {
            Block targetBlock = target.getBlock();
            List<Statement> targetStatements = DomGenerics.statements(targetBlock);
            if (statement.getParent() == targetBlock && (target.isBefore() ? targetStatements.indexOf(statement) == 0 : targetStatements.indexOf(statement) == targetStatements.size() - 1)) {
                return;
            }
        }
        AstCodeGeneration generation = this.getGeneration();
        String singleIndent = generation.getIndentation(1);
        String eol = generation.getEndOfLine();
        Block sourceBlock = (Block)statement.getParent();
        int sourceBegin = this.skipWhitespaceAndPureEOLCToLeft(statement.getStartPosition());
        int sourceLength = this.getStatementEndIndex(statement) - sourceBegin;
        int leftEOLEnd = sourceBegin;
        int leftEOLBegin = this.skipSingleEOLToLeft(leftEOLEnd);
        int leftEOLLength = leftEOLEnd - leftEOLBegin;
        this.replaceSubstring(leftEOLBegin, leftEOLLength, "");
        sourceBegin -= leftEOLLength;
        if (target.getStatement() != null) {
            int position;
            Statement targetStatement = target.getStatement();
            String indent = this.getWhitespaceToLeft(targetStatement.getStartPosition(), false);
            if (target.isBefore()) {
                position = this.skipWhitespaceAndPureEOLCToLeft(targetStatement.getStartPosition());
                position = this.moveSource(position, sourceBegin, sourceLength);
                this.replaceSubstring(position + sourceLength, 0, eol);
            } else {
                position = this.getStatementEndIndex(targetStatement);
                position = this.moveSource(position, sourceBegin, sourceLength);
                this.replaceSubstring(position, 0, eol);
                position += eol.length();
            }
            Block targetBlock = (Block)targetStatement.getParent();
            int index = targetBlock.statements().indexOf(targetStatement);
            if (!target.isBefore()) {
                ++index;
            }
            if (sourceBlock == targetBlock && sourceBlock.statements().indexOf(statement) < index) {
                --index;
            }
            sourceBlock.statements().remove(statement);
            DomGenerics.statements(targetBlock).add(index, statement);
            this.reindentSource(position, sourceLength, indent, eol);
        } else {
            int position;
            Block targetBlock;
            Block indentNode = targetBlock = target.getBlock();
            if (targetBlock.getLocationInParent() == MethodDeclaration.BODY_PROPERTY || targetBlock.getLocationInParent() == TryStatement.BODY_PROPERTY) {
                indentNode = targetBlock.getParent();
            }
            String indent = this.getWhitespaceToLeft(indentNode.getStartPosition(), false);
            indent = String.valueOf(indent) + singleIndent;
            if (target.isBefore()) {
                position = targetBlock.getStartPosition();
                Assert.isTrue(position != -1);
                ++position;
                position = this.moveSource(position, sourceBegin, sourceLength);
                this.replaceSubstring(position, 0, eol);
                position += eol.length();
                sourceBlock.statements().remove(statement);
                DomGenerics.statements(targetBlock).add(0, statement);
            } else {
                position = AstNodeUtils.getSourceEnd((ASTNode)targetBlock) - 1;
                String endMethodIndent = this.getWhitespaceToLeft(position, false);
                position -= endMethodIndent.length();
                position = this.moveSource(position, sourceBegin, sourceLength);
                this.replaceSubstring(position + sourceLength, 0, eol);
                sourceBlock.statements().remove(statement);
                DomGenerics.statements(targetBlock).add(statement);
            }
            this.reindentSource(position, sourceLength, indent, eol);
        }
    }

    private int moveSource(int target, int start, int length) throws Exception {
        String source = this.getSource(start, length);
        final int b_pos = start;
        final int b_len = length;
        final int b_end = b_pos + b_len;
        final int t_pos = target;
        if (b_pos > t_pos) {
            this.m_document.replace(b_pos, b_len, "");
            this.m_document.replace(t_pos, 0, source);
            this.m_astUnit.accept(new ASTVisitor(true){

                public void postVisit(ASTNode node) {
                    int n_pos = node.getStartPosition();
                    int n_len = node.getLength();
                    int n_end = n_pos + n_len;
                    if (n_pos >= b_end) {
                        return;
                    }
                    if (n_end <= t_pos) {
                        return;
                    }
                    if (n_pos < t_pos && n_end > b_end) {
                        return;
                    }
                    if (n_pos >= b_pos && n_end <= b_end) {
                        node.setSourceRange(t_pos + n_pos - b_pos, n_len);
                        return;
                    }
                    if (n_pos >= t_pos && n_end <= b_pos) {
                        node.setSourceRange(n_pos + b_len, n_len);
                        return;
                    }
                    if (n_pos < t_pos && n_end > t_pos) {
                        node.setSourceRange(n_pos, n_len + b_len);
                        return;
                    }
                    node.setSourceRange(n_pos + b_len, n_len - b_len);
                }
            });
        } else {
            this.m_document.replace(t_pos, 0, source);
            this.m_document.replace(b_pos, b_len, "");
            this.m_astUnit.accept(new ASTVisitor(true){

                public void postVisit(ASTNode node) {
                    int n_len;
                    int n_pos = node.getStartPosition();
                    int n_end = n_pos + (n_len = node.getLength());
                    if (n_end <= b_pos) {
                        return;
                    }
                    if (n_pos >= t_pos) {
                        return;
                    }
                    if (n_pos < b_pos && n_end > t_pos) {
                        return;
                    }
                    if (n_pos >= b_pos && n_end <= b_end) {
                        node.setSourceRange(t_pos - b_len + n_pos - b_pos, n_len);
                        return;
                    }
                    if (n_pos >= b_end && n_end <= t_pos) {
                        node.setSourceRange(n_pos - b_len, n_len);
                        return;
                    }
                    if (n_pos < t_pos && n_end > t_pos) {
                        node.setSourceRange(n_pos - b_len, n_len + b_len);
                        return;
                    }
                    node.setSourceRange(n_pos, n_len - b_len);
                }
            });
        }
        if (start < target) {
            target -= length;
        }
        return target;
    }

    public int getStatementEndIndex(Statement statement) {
        char c;
        int index = statement.getStartPosition() + statement.getLength();
        while (Character.isWhitespace(c = this.getChar(index++)) && c != '\r' && c != '\n') {
        }
        if (c == '/' && this.getChar(index) == '/') {
            while ((c = this.getChar(index++)) != '\r' && c != '\n') {
            }
        }
        return index - 1;
    }

    public FieldDeclaration addFieldDeclaration(String source, BodyDeclarationTarget target) throws Exception {
        return this.addFieldDeclaration((List)ImmutableList.of((Object)source), target);
    }

    public FieldDeclaration addFieldDeclaration(List<String> lines, BodyDeclarationTarget target) throws Exception {
        return (FieldDeclaration)this.addBodyDeclaration(lines, target);
    }

    public MethodDeclaration addMethodDeclaration(String header, List<String> bodyLines, BodyDeclarationTarget target) throws Exception {
        return this.addMethodDeclaration((List)ImmutableList.of(), header, bodyLines, target);
    }

    public MethodDeclaration addMethodDeclaration(List<String> annotations, String header, List<String> bodyLines, BodyDeclarationTarget target) throws Exception {
        List lines = Lists.newArrayList();
        lines.addAll(annotations);
        if (bodyLines != null) {
            lines.add(String.valueOf(header) + " {");
            String singleIndent = this.getGeneration().getIndentation(1);
            for (String bodyLine : bodyLines) {
                lines.add(String.valueOf(singleIndent) + bodyLine);
            }
            lines.add("}");
        } else {
            lines.add(header);
        }
        return (MethodDeclaration)this.addBodyDeclaration(lines, target);
    }

    public MethodDeclaration addInterfaceMethodDeclaration(String header, BodyDeclarationTarget target) throws Exception {
        List lines = (List)ImmutableList.of((Object)(String.valueOf(header) + ";"));
        return (MethodDeclaration)this.addBodyDeclaration(lines, target);
    }

    public String getParametersSource(MethodDeclaration method) {
        StringBuffer sb = new StringBuffer();
        for (SingleVariableDeclaration parameter : DomGenerics.parameters(method)) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(this.getSource((ASTNode)parameter));
        }
        return sb.toString();
    }

    public String[] getParameterNames(MethodDeclaration method) {
        List<SingleVariableDeclaration> parameters = DomGenerics.parameters(method);
        String[] names = new String[parameters.size()];
        int i = 0;
        while (i < names.length) {
            SingleVariableDeclaration parameter = parameters.get(i);
            names[i] = parameter.getName().getIdentifier();
            ++i;
        }
        return names;
    }

    public void replaceMethodName(MethodDeclaration method, String newName) throws Exception {
        this.setIdentifier(method.getName(), newName);
        this.replaceMethodBinding(method);
    }

    private void replaceMethodBinding(MethodDeclaration method) throws Exception {
        MethodDeclaration parsedMethod = this.parseExistingMethod(method);
        this.replaceMethodBinding((ASTNode)method, (ASTNode)parsedMethod);
    }

    private MethodDeclaration parseExistingMethod(MethodDeclaration method) throws Exception {
        method.setProperty("Ignore this method for parsing context", (Object)Boolean.TRUE);
        try {
            MethodDeclaration methodDeclaration = (MethodDeclaration)this.m_parser.parseBodyDeclaration(method.getStartPosition(), "");
            return methodDeclaration;
        }
        finally {
            method.setProperty("Ignore this method for parsing context", null);
        }
    }

    public void replaceMethodType(MethodDeclaration method, String newTypeName) throws Exception {
        Type oldType = method.getReturnType2();
        Type newType = this.getParser().parseQualifiedType(oldType.getStartPosition(), newTypeName);
        this.replaceSubstring((ASTNode)oldType, newTypeName);
        method.setReturnType2(newType);
        this.resolveImports((ASTNode)newType);
        this.replaceMethodBinding(method);
    }

    public String getMethodStubSource(MethodDeclaration methodDeclaration) throws Exception {
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(methodDeclaration);
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        sb.append(this.getMethodHeaderSource(methodDeclaration));
        sb.append(" {\n");
        ITypeBinding returnType = methodBinding.getReturnType();
        String returnTypeName = AstNodeUtils.getFullyQualifiedName(returnType, false);
        if (!returnTypeName.equals("void")) {
            sb.append("\t\treturn ");
            sb.append(AstParser.getDefaultValue(returnTypeName));
            sb.append(";\n");
        }
        sb.append("\t}");
        return sb.toString();
    }

    public String getMethodHeaderSource(MethodDeclaration method) {
        StringBuffer sb = new StringBuffer();
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(method);
        List<ASTNode> modifiersNodes = DomGenerics.modifiersNodes((BodyDeclaration)method);
        List<Modifier> modifiers = GenericsUtils.select(modifiersNodes, Modifier.class);
        for (Modifier modifier : modifiers) {
            sb.append(modifier);
            sb.append(" ");
        }
        ITypeBinding returnType = methodBinding.getReturnType();
        String returnTypeName = AstNodeUtils.getFullyQualifiedName(returnType, false);
        sb.append(returnTypeName);
        sb.append(" ");
        sb.append(method.getName().getIdentifier());
        sb.append("(");
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        List<SingleVariableDeclaration> parameters = DomGenerics.parameters(method);
        int i = 0;
        while (i < parameterTypes.length) {
            ITypeBinding parameterType = parameterTypes[i];
            String parameterTypeName = AstNodeUtils.getFullyQualifiedName(parameterType, false);
            String parameterName = parameters.get(i).getName().getIdentifier();
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(parameterTypeName);
            sb.append(" ");
            sb.append(parameterName);
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public String getTypeArgumentsSource(ITypeBinding[] typeArguments) {
        if (typeArguments.length == 0) {
            return "";
        }
        StringBuilder typeArgumentsBuilder = new StringBuilder();
        typeArgumentsBuilder.append("<");
        ITypeBinding[] iTypeBindingArray = typeArguments;
        int n = typeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArgument = iTypeBindingArray[n2];
            if (typeArgumentsBuilder.length() > 1) {
                typeArgumentsBuilder.append(", ");
            }
            typeArgumentsBuilder.append(AstNodeUtils.getFullyQualifiedName(typeArgument, false));
            ++n2;
        }
        typeArgumentsBuilder.append(">");
        return typeArgumentsBuilder.toString();
    }

    public String getTypeArgumentsSource(ClassInstanceCreation creation) {
        AnonymousClassDeclaration anonymousDeclaration = creation.getAnonymousClassDeclaration();
        ITypeBinding typeBinding = anonymousDeclaration != null ? AstNodeUtils.getTypeBinding(anonymousDeclaration).getSuperclass() : AstNodeUtils.getTypeBinding((Expression)creation);
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        return this.getTypeArgumentsSource(typeArguments);
    }

    public TypeDeclaration addTypeDeclaration(List<String> lines, BodyDeclarationTarget target) throws Exception {
        return (TypeDeclaration)this.addBodyDeclaration(lines, target);
    }

    public boolean ensureInterfaceImplementation(TypeDeclaration type, String interfaceClassName) throws Exception {
        String codePrefix;
        int pos;
        Type lastInterface = null;
        for (Type interfaceType : DomGenerics.superInterfaces(type)) {
            String implementedInterface = AstNodeUtils.getFullyQualifiedName(interfaceType, true);
            if (implementedInterface.equals(interfaceClassName)) {
                return false;
            }
            lastInterface = interfaceType;
        }
        if (lastInterface == null) {
            SimpleName typeName = type.getName();
            if (type.getSuperclassType() != null) {
                typeName = type.getSuperclassType();
            }
            pos = typeName.getStartPosition() + typeName.getLength();
            codePrefix = " implements ";
        } else {
            pos = lastInterface.getStartPosition() + lastInterface.getLength();
            codePrefix = ", ";
        }
        TypeLiteral typeLiteral = (TypeLiteral)this.m_parser.parseExpression(type.getStartPosition(), String.valueOf(interfaceClassName) + ".class");
        AstNodeUtils.moveNode((ASTNode)typeLiteral, pos + codePrefix.length());
        SimpleType interfaceType = (SimpleType)typeLiteral.getType();
        typeLiteral.setType((Type)typeLiteral.getAST().newPrimitiveType(PrimitiveType.BOOLEAN));
        this.replaceSubstring(pos, 0, String.valueOf(codePrefix) + interfaceClassName);
        DomGenerics.superInterfaces(type).add((Type)interfaceType);
        ITypeBinding interfaceBinding = AstNodeUtils.getTypeBinding((Type)interfaceType);
        DesignerTypeBinding typeBinding = this.getDesignerTypeBinding((ASTNode)type);
        typeBinding.addInterface(interfaceBinding);
        this.resolveImports((ASTNode)interfaceType);
        return true;
    }

    public void ensureThrownException(MethodDeclaration method, String requiredException) throws Exception {
        String codePrefix;
        int pos;
        IType requiredExceptionType = this.getJavaProject().findType(requiredException);
        Assert.isNotNull2(requiredExceptionType, "No such exception type: {0}", requiredException);
        ITypeHierarchy requiredHierarchy = requiredExceptionType.newSupertypeHierarchy(null);
        Name lastName = null;
        for (Name declaredTypeName : DomGenerics.thrownExceptions(method)) {
            String declaredName = AstNodeUtils.getFullyQualifiedName((Expression)declaredTypeName, false);
            IType declaredType = this.getJavaProject().findType(declaredName);
            if (requiredHierarchy.contains(declaredType)) {
                return;
            }
            lastName = declaredTypeName;
        }
        if (lastName == null) {
            SimpleName name = method.getName();
            pos = AstNodeUtils.getSourceEnd((ASTNode)name);
            pos = this.indexOf(")", pos) + 1;
            codePrefix = " throws ";
        } else {
            pos = AstNodeUtils.getSourceEnd(lastName);
            codePrefix = ", ";
        }
        TypeLiteral typeLiteral = (TypeLiteral)this.m_parser.parseExpression(pos, String.valueOf(requiredException) + ".class");
        AstNodeUtils.moveNode((ASTNode)typeLiteral, pos + codePrefix.length());
        SimpleType newExceptionType = (SimpleType)typeLiteral.getType();
        Name newExceptionTypeName = newExceptionType.getName();
        newExceptionType.setName((Name)typeLiteral.getAST().newSimpleName("filler"));
        this.replaceSubstring(pos, 0, String.valueOf(codePrefix) + requiredException);
        DomGenerics.thrownExceptions(method).add(newExceptionTypeName);
        ITypeBinding newExceptionBinding = AstNodeUtils.getTypeBinding((Type)newExceptionType);
        DesignerMethodBinding methodBinding = this.getDesignerMethodBinding((ASTNode)method);
        methodBinding.addExceptionType(newExceptionBinding);
        this.resolveImports((ASTNode)method);
    }

    private BodyDeclaration addBodyDeclaration(List<String> lines, BodyDeclarationTarget target) throws Exception {
        BodyDeclaration newDeclaration;
        Assert.isNotNull(lines);
        Assert.isNotNull(target);
        TypeDeclaration targetType = target.getType();
        BodyDeclaration targetDecl = target.getDeclaration();
        Assert.isTrue(targetType != null || targetDecl != null);
        AstCodeGeneration generation = this.getGeneration();
        String singleIndent = generation.getIndentation(1);
        String eol = generation.getEndOfLine();
        if (targetDecl != null) {
            BodyDeclaration newDeclaration2;
            targetType = (TypeDeclaration)targetDecl.getParent();
            String indent = this.getWhitespaceToLeft(targetDecl.getStartPosition(), false);
            int index = targetType.bodyDeclarations().indexOf(targetDecl);
            String source = AstEditor.getIndentedSource(lines, indent, singleIndent, eol);
            if (target.isBefore()) {
                int position = this.skipWhitespaceAndPureEOLCToLeft(targetDecl.getStartPosition());
                source = String.valueOf(source) + eol;
                newDeclaration2 = this.getParser().parseBodyDeclaration(position, source);
                this.replaceSubstring(position, 0, source);
                DomGenerics.bodyDeclarations(targetType).add(index, newDeclaration2);
            } else {
                int position = AstNodeUtils.getSourceEnd((ASTNode)targetDecl);
                position = this.skipWhitespaceEOLCToRight(position);
                source = String.valueOf(eol) + source;
                newDeclaration2 = this.getParser().parseBodyDeclaration(position, source);
                this.replaceSubstring(position, 0, source);
                DomGenerics.bodyDeclarations(targetType).add(index + 1, newDeclaration2);
            }
            this.resolveImports((ASTNode)newDeclaration2);
            return newDeclaration2;
        }
        this.removeDanglingJavadoc();
        Object indentNode = targetType instanceof AnonymousTypeDeclaration2 ? AstNodeUtils.getEnclosingStatement((ASTNode)targetType) : targetType;
        String indent = String.valueOf(this.getWhitespaceToLeft(indentNode.getStartPosition(), false)) + singleIndent;
        String source = AstEditor.getIndentedSource(lines, indent, singleIndent, eol);
        if (target.isBefore()) {
            int position = this.indexOfAny("{", targetType.getName().getStartPosition()) + 1;
            source = String.valueOf(eol) + source;
            newDeclaration = this.getParser().parseBodyDeclaration(position, source);
            this.replaceSubstring(position, 0, source);
            DomGenerics.bodyDeclarations(targetType).add(0, newDeclaration);
        } else {
            int position = AstNodeUtils.getSourceEnd((ASTNode)targetType) - 1;
            position -= this.getWhitespaceToLeft(position, false).length();
            source = String.valueOf(source) + eol;
            newDeclaration = this.getParser().parseBodyDeclaration(position, source);
            this.replaceSubstring(position, 0, source);
            DomGenerics.bodyDeclarations(targetType).add(newDeclaration);
        }
        this.resolveImports((ASTNode)newDeclaration);
        return newDeclaration;
    }

    public void removeBodyDeclaration(BodyDeclaration declaration) throws Exception {
        int startIndex;
        List<BodyDeclaration> declarations;
        if (declaration.getParent() instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration.getParent();
            declarations = DomGenerics.bodyDeclarations(typeDeclaration);
        } else {
            declarations = DomGenerics.bodyDeclarations((AnonymousClassDeclaration)declaration.getParent());
        }
        int index = declarations.indexOf(declaration);
        if (index != 0) {
            BodyDeclaration prevDeclaration = declarations.get(index - 1);
            startIndex = prevDeclaration.getStartPosition() + prevDeclaration.getLength();
            startIndex = this.skipWhitespaceEOLCToRight(startIndex);
        } else if (declaration.getParent() instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration.getParent();
            startIndex = this.indexOfAny("{", typeDeclaration.getName().getStartPosition()) + 1;
        } else {
            startIndex = this.indexOfAny("{", declaration.getParent().getStartPosition()) + 1;
        }
        int endIndex = declaration.getStartPosition() + declaration.getLength();
        endIndex = this.skipWhitespaceEOLCToRight(endIndex);
        declarations.remove(declaration);
        this.replaceSubstring(startIndex, endIndex - startIndex, "");
    }

    private int skipWhitespaceEOLCToRight(int position) throws BadLocationException, Exception {
        char c;
        while ((c = this.m_document.getChar(position)) != '\r' && c != '\n') {
            if (!Character.isWhitespace(c)) {
                if (c != '/' || this.m_document.getChar(position + 1) != '/') break;
                position = this.getLineEnd(position);
                break;
            }
            ++position;
        }
        return position;
    }

    public void removeVariableDeclaration(VariableDeclaration declaration) throws Exception {
        ASTNode parent = declaration.getParent();
        if (parent instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)parent;
            List<VariableDeclarationFragment> fragments = DomGenerics.fragments(fieldDeclaration);
            if (fragments.size() == 1) {
                this.removeBodyDeclaration((BodyDeclaration)fieldDeclaration);
            } else {
                this.removeVariableDeclaration((ASTNode)fieldDeclaration, fragments, fragments.indexOf(declaration));
            }
        } else if (parent instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement variableDeclaration = (VariableDeclarationStatement)declaration.getParent();
            List<VariableDeclarationFragment> fragments = DomGenerics.fragments(variableDeclaration);
            if (fragments.size() == 1) {
                this.removeEnclosingStatement((ASTNode)declaration);
            } else {
                this.removeVariableDeclaration((ASTNode)variableDeclaration, fragments, fragments.indexOf(declaration));
            }
        } else {
            throw new IllegalArgumentException("Can not remove VariableDeclaration '" + declaration.toString() + "'");
        }
    }

    private void removeVariableDeclaration(ASTNode parent, List<VariableDeclarationFragment> fragments, int index) throws Exception {
        VariableDeclarationFragment declaration = fragments.get(index);
        Assert.isTrue(fragments.size() > 1, "Last variable must be removed with parent body.", this.getSource((ASTNode)declaration), this.getSource(parent));
        int sourceBegin = AstNodeUtils.getSourceBegin((ASTNode)declaration);
        int sourceEnd = AstNodeUtils.getSourceEnd((ASTNode)declaration);
        if (index == 0) {
            if (fragments.size() > 1) {
                sourceEnd = this.indexOfAnyBut(", \t\r\n", sourceEnd);
            }
        } else {
            sourceBegin = this.indexOfAnyButBackward(", \t\r\n", sourceBegin) + 1;
        }
        fragments.remove(index);
        this.replaceSubstring(sourceBegin, sourceEnd - sourceBegin, "");
    }

    public void removeDanglingJavadoc() {
        this.m_astUnit.accept((ASTVisitor)new AstVisitorEx(){

            public void endVisitEx(TypeDeclaration node) throws Exception {
                int javadocEnd;
                int typeEnd = AstNodeUtils.getSourceEnd((ASTNode)node) - 1;
                int trailingJavadocEnd = AstEditor.this.skipWhitespaceAndPureEOLCToLeft(typeEnd);
                trailingJavadocEnd = AstEditor.this.skipWhitespaceToLeft(trailingJavadocEnd, true);
                String source = AstEditor.this.getSource().substring(0, typeEnd);
                int javadocBegin = source.lastIndexOf("/**");
                if (javadocBegin != -1 && (javadocEnd = source.indexOf("*/", javadocBegin) + "*/".length()) == trailingJavadocEnd) {
                    javadocBegin = AstEditor.this.skipWhitespaceToLeft(javadocBegin, false);
                    AstEditor.this.replaceSubstring(javadocBegin, typeEnd - javadocBegin, "");
                }
            }
        });
    }

    public TagElement setJavadocTagText(BodyDeclaration declaration, String tagName, String tagText) throws Exception {
        Assert.isNotNull(tagName);
        Assert.isLegal(tagName.length() != 0, "Empty name of tag.");
        Assert.isLegal(tagName.startsWith("@"), "Tag name should start with '@'.");
        Javadoc javadoc = declaration.getJavadoc();
        if (tagText != null) {
            if (javadoc != null) {
                for (TagElement tagElement : DomGenerics.tags(javadoc)) {
                    if (!tagName.equals(tagElement.getTagName())) continue;
                    this.setJavadocTagText_replaceFragments(tagElement, tagText);
                    return tagElement;
                }
                List<TagElement> tags = DomGenerics.tags(javadoc);
                int javadocPosition = javadoc.getStartPosition();
                String prefix = this.getWhitespaceToLeft(javadocPosition, false);
                String endOfLine = this.getGeneration().getEndOfLine();
                int position = tags.isEmpty() ? javadocPosition + "/**".length() : AstNodeUtils.getSourceEnd((ASTNode)tags.get(tags.size() - 1));
                String newCommentLine = String.valueOf(endOfLine) + prefix + " * ";
                this.replaceSubstring(position, 0, newCommentLine);
                String tagSource = String.valueOf(tagName) + tagText;
                this.replaceSubstring(position += newCommentLine.length(), 0, tagSource);
                TagElement tagElement = javadoc.getAST().newTagElement();
                tagElement.setSourceRange(position, tagSource.length());
                tagElement.setTagName(tagName);
                tags.add(tagElement);
                TextElement textElement = javadoc.getAST().newTextElement();
                textElement.setSourceRange(position + tagName.length(), tagText.length());
                textElement.setText(tagText);
                DomGenerics.fragments(tagElement).add((ASTNode)textElement);
                return tagElement;
            }
            javadoc = this.setJavadoc(declaration, new String[]{String.valueOf(tagName) + tagText});
            return DomGenerics.tags(javadoc).get(0);
        }
        if (javadoc != null) {
            Iterator<TagElement> I = DomGenerics.tags(javadoc).iterator();
            while (I.hasNext()) {
                TagElement tagElement = I.next();
                if (!tagName.equals(tagElement.getTagName())) continue;
                int begin = AstNodeUtils.getSourceBegin((ASTNode)tagElement);
                int end = AstNodeUtils.getSourceEnd((ASTNode)tagElement);
                if (this.getChar(end = this.indexOfAnyBut(" \t\r\n*", end + 1)) == '/') {
                    begin = this.indexOfAnyButBackward("*", begin);
                }
                this.replaceSubstring(begin, end - begin, "");
                I.remove();
                if (!DomGenerics.tags(javadoc).isEmpty()) break;
                this.setJavadoc(declaration, null);
                break;
            }
        }
        return null;
    }

    private void setJavadocTagText_replaceFragments(TagElement tagElement, String tagText) throws Exception {
        int fragmentsPosition;
        List<ASTNode> fragments = DomGenerics.fragments(tagElement);
        if (!fragments.isEmpty()) {
            ASTNode firstFragment = fragments.get(0);
            fragmentsPosition = AstNodeUtils.getSourceBegin(firstFragment);
            int fragmentsLength = AstNodeUtils.getSourceEnd((ASTNode)tagElement) - fragmentsPosition;
            this.replaceSubstring(fragmentsPosition, fragmentsLength, tagText);
        } else {
            fragmentsPosition = AstNodeUtils.getSourceEnd((ASTNode)tagElement);
            this.replaceSubstring(fragmentsPosition, 0, tagText);
            AstNodeUtils.setSourceLength((ASTNode)tagElement, tagElement.getLength() + tagText.length());
        }
        fragments.clear();
        TextElement textElement = tagElement.getAST().newTextElement();
        textElement.setSourceRange(fragmentsPosition, tagText.length());
        textElement.setText(tagText);
        fragments.add((ASTNode)textElement);
    }

    public Javadoc setJavadoc(BodyDeclaration declaration, String[] lines) throws Exception {
        Javadoc oldJavadoc = declaration.getJavadoc();
        if (lines != null) {
            int position = declaration.getStartPosition();
            AstCodeGeneration generation = this.getGeneration();
            String eol = generation.getEndOfLine();
            String indent = this.getWhitespaceToLeft(declaration.getStartPosition(), false);
            StringBuilder sb = new StringBuilder();
            sb.append("/**");
            sb.append(eol);
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                sb.append(indent);
                sb.append(" * ");
                sb.append(line);
                sb.append(eol);
                ++n2;
            }
            sb.append(indent);
            sb.append(" */");
            String comment = sb.toString();
            BodyDeclaration tmpMethod = this.getParser().parseBodyDeclaration(position, String.valueOf(comment) + " void __wbp_tmpMethod() {}");
            Javadoc javadoc = tmpMethod.getJavadoc();
            tmpMethod.setJavadoc(null);
            if (oldJavadoc != null) {
                int oldLength = oldJavadoc.getLength();
                this.replaceSubstring(position, oldLength, comment);
            } else {
                comment = String.valueOf(comment) + eol + indent;
                this.replaceSubstring(position, 0, comment);
                declaration.setSourceRange(position, comment.length() + declaration.getLength());
            }
            declaration.setJavadoc(javadoc);
            return javadoc;
        }
        if (oldJavadoc != null) {
            int sourceBegin = oldJavadoc.getStartPosition();
            int sourceEnd = sourceBegin + oldJavadoc.getLength();
            sourceEnd = this.indexOfAnyBut(" \t\r\n", sourceEnd);
            this.replaceSubstring(sourceBegin, sourceEnd - sourceBegin, "");
            declaration.setJavadoc(null);
        }
        return null;
    }

    public String ensureClassImport2(final String className) throws Exception {
        int position;
        String importName;
        final String shortClassName = CodeUtils.getShortClass(className);
        List<ImportDeclaration> imports = DomGenerics.imports(this.m_astUnit);
        String packageName = CodeUtils.getPackage(className);
        if ("java.lang".equals(packageName)) {
            return shortClassName;
        }
        for (ImportDeclaration currentImport : imports) {
            importName = currentImport.getName().toString();
            if (!importName.equals(className) && (!currentImport.isOnDemand() || !importName.equals(packageName))) continue;
            return shortClassName;
        }
        IPackageDeclaration[] packageDeclarations = this.m_modelUnit.getPackageDeclarations();
        if (packageDeclarations.length != 0 && packageDeclarations[0].getElementName().equals(packageName)) {
            return shortClassName;
        }
        final AtomicBoolean hasInner = new AtomicBoolean();
        this.m_astUnit.accept(new ASTVisitor(){

            public boolean visit(Block node) {
                return false;
            }

            public void endVisit(TypeDeclaration node) {
                String qualifiedTypeName = AstNodeUtils.getFullyQualifiedName(node, false);
                if (qualifiedTypeName.equals(className)) {
                    hasInner.set(true);
                }
            }
        });
        if (hasInner.get()) {
            return shortClassName;
        }
        boolean hasOnDemand = false;
        for (ImportDeclaration currentImport : imports) {
            if (currentImport.isOnDemand()) {
                hasOnDemand = true;
                break;
            }
            importName = currentImport.getName().getFullyQualifiedName();
            if (!CodeUtils.getShortClass(importName).equals(shortClassName)) continue;
            return className;
        }
        if (hasOnDemand) {
            final AtomicBoolean conflict = new AtomicBoolean();
            this.m_astUnit.accept(new ASTVisitor(){

                public void endVisit(SimpleType node) {
                    if (!conflict.get()) {
                        String qualifiedTypeName = AstNodeUtils.getFullyQualifiedName((Type)node, false);
                        boolean isQualified = qualifiedTypeName.equals(AstEditor.this.getSource((ASTNode)node));
                        boolean hasSameShort = CodeUtils.getShortClass(qualifiedTypeName).equals(shortClassName);
                        if (!isQualified && hasSameShort) {
                            conflict.set(true);
                        }
                    }
                }
            });
            if (conflict.get()) {
                return className;
            }
        }
        final AtomicBoolean hasTypeDeclarationWithSameShort = new AtomicBoolean();
        this.m_astUnit.accept(new ASTVisitor(){

            public boolean visit(Block node) {
                return false;
            }

            public void endVisit(TypeDeclaration node) {
                if (node.getName().getIdentifier().equals(shortClassName)) {
                    hasTypeDeclarationWithSameShort.set(true);
                }
            }
        });
        if (hasTypeDeclarationWithSameShort.get()) {
            return className;
        }
        String eol = this.getGeneration().getEndOfLine();
        String sourcePrefix = "";
        String sourceSuffix = "";
        if (!imports.isEmpty()) {
            ImportDeclaration lastImport = imports.get(imports.size() - 1);
            position = AstNodeUtils.getSourceEnd((ASTNode)lastImport);
            sourcePrefix = eol;
        } else if (this.m_astUnit.getPackage() != null) {
            position = AstNodeUtils.getSourceEnd((ASTNode)this.m_astUnit.getPackage());
            sourcePrefix = eol;
        } else {
            position = 0;
            sourceSuffix = eol;
        }
        String source = String.valueOf(sourcePrefix) + "import " + className + ";" + sourceSuffix;
        this.replaceSubstring(position, 0, source);
        int importPosition = position + sourcePrefix.length();
        ImportDeclaration newImport = this.getParser().parseImportDeclaration(importPosition, className);
        imports.add(newImport);
        return shortClassName;
    }

    public void setResolveImports(boolean resolveImports) {
        this.m_resolveImports = resolveImports;
    }

    public void resolveImports(ASTNode node) {
        if (!this.m_resolveImports) {
            return;
        }
        node.accept((ASTVisitor)new AstVisitorEx(){

            public boolean visitEx(QualifiedName qualifiedName) throws Exception {
                String shortClassName;
                String qualifiedClassName = qualifiedName.getFullyQualifiedName();
                if (AstEditor.this.getJavaProject().findType(qualifiedClassName) != null && !(shortClassName = AstEditor.this.ensureClassImport2(qualifiedClassName)).equals(qualifiedClassName)) {
                    int sourceBegin = AstNodeUtils.getSourceBegin((ASTNode)qualifiedName);
                    AstEditor.this.replaceSubstring((ASTNode)qualifiedName, shortClassName);
                    ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((Expression)qualifiedName);
                    SimpleName simpleName = AstEditor.this.m_parser.parseSimpleName(sourceBegin, shortClassName);
                    simpleName.setProperty("TYPE_BINDING", (Object)typeBinding);
                    AstEditor.replaceNode((ASTNode)qualifiedName, (ASTNode)simpleName);
                    return false;
                }
                return true;
            }
        });
    }

    public void removeInvocationArgument(MethodInvocation invocation, int index) throws Exception {
        this.removeInvocationArgument((ASTNode)invocation, DomGenerics.arguments(invocation), index);
    }

    public void removeCreationArgument(ClassInstanceCreation creation, int index) throws Exception {
        this.removeInvocationArgument((ASTNode)creation, DomGenerics.arguments(creation), index);
    }

    private void removeInvocationArgument(ASTNode parent, List<Expression> arguments, int index) throws Exception {
        Expression argument = arguments.get(index);
        int sourceBegin = AstNodeUtils.getSourceBegin((ASTNode)argument);
        int sourceEnd = AstNodeUtils.getSourceEnd((ASTNode)argument);
        if (index == 0) {
            sourceEnd = arguments.size() == 1 ? this.indexOf(")", sourceEnd) : this.indexOfAnyBut(", \t\r\n", sourceEnd);
        } else {
            sourceBegin = this.indexOfAnyButBackward(", \t\r\n", sourceBegin) + 1;
        }
        arguments.remove(index);
        DesignerMethodBinding methodBinding = this.getDesignerMethodBinding(parent);
        if (index < methodBinding.getParameterTypes().length) {
            methodBinding.removeParameterType(index);
        }
        this.replaceSubstring(sourceBegin, sourceEnd - sourceBegin, "");
    }

    public Expression addInvocationArgument(MethodInvocation invocation, int index, String source) throws Exception {
        return this.addInvocationArgument((Expression)invocation, DomGenerics.arguments(invocation), index, source);
    }

    public Expression addCreationArgument(ClassInstanceCreation creation, int index, String source) throws Exception {
        return this.addInvocationArgument((Expression)creation, DomGenerics.arguments(creation), index, source);
    }

    public Expression moveInvocationArgument(MethodInvocation invocation, int oldIndex, int newIndex) throws Exception {
        List<Expression> arguments = DomGenerics.arguments(invocation);
        Expression expression = arguments.get(oldIndex);
        String source = this.getSource((ASTNode)expression);
        this.removeInvocationArgument(invocation, oldIndex);
        int position = this.insertToInvocationBody((Expression)invocation, arguments, newIndex, source);
        arguments.add(newIndex, expression);
        AstNodeUtils.moveNode((ASTNode)expression, position);
        return expression;
    }

    private Expression addInvocationArgument(Expression parent, List<Expression> arguments, int index, String source) throws Exception {
        int position = this.insertToInvocationBody(parent, arguments, index, source);
        Expression argument = this.getParser().parseExpression(position, source);
        arguments.add(index, argument);
        this.replaceInvocationBinding(parent);
        this.resolveImports((ASTNode)argument);
        return argument;
    }

    private int insertToInvocationBody(Expression parent, List<Expression> arguments, int index, String source) throws Exception {
        int position;
        String sourcePrefix = "";
        String sourceSuffix = "";
        if (index == 0) {
            if (arguments.size() == 0) {
                position = AstNodeUtils.getSourceEnd((ASTNode)parent) - 1;
            } else {
                Expression firstArgument = arguments.get(index);
                position = AstNodeUtils.getSourceBegin((ASTNode)firstArgument);
                sourceSuffix = ", ";
            }
        } else {
            Expression prevArgument = arguments.get(index - 1);
            position = AstNodeUtils.getSourceEnd((ASTNode)prevArgument);
            sourcePrefix = ", ";
        }
        this.replaceSubstring(position, 0, String.valueOf(sourcePrefix) + source + sourceSuffix);
        return position += sourcePrefix.length();
    }

    public void replaceCreationArguments(ClassInstanceCreation creation, List<String> lines) throws Exception {
        this.replaceInvocationArguments((Expression)creation, (ASTNode)creation.getType(), DomGenerics.arguments(creation), lines);
    }

    public void replaceInvocationArguments(MethodInvocation invocation, List<String> lines) throws Exception {
        this.replaceInvocationArguments((Expression)invocation, (ASTNode)invocation.getName(), DomGenerics.arguments(invocation), lines);
    }

    private void replaceInvocationArguments(Expression parent, ASTNode nameNode, List<Expression> arguments, List<String> lines) throws Exception {
        AstCodeGeneration generation = this.getGeneration();
        String singleIndent = generation.getIndentation(1);
        String eol = generation.getEndOfLine();
        Statement statement = AstNodeUtils.getEnclosingStatement((ASTNode)parent);
        String indent = this.getWhitespaceToLeft(statement.getStartPosition(), false);
        String source = AstEditor.getIndentedSource(lines, indent, singleIndent, eol);
        source = source.trim();
        int sourceBegin = this.indexOf("(", AstNodeUtils.getSourceBegin(nameNode)) + 1;
        int sourceEnd = AstNodeUtils.getSourceEnd((ASTNode)parent) - 1;
        this.replaceSubstring(sourceBegin, sourceEnd - sourceBegin, source);
        ASTNode newInvocation = this.replaceInvocationBinding(parent);
        List<Expression> newArguments = DomGenerics.arguments(newInvocation);
        ArrayList<Expression> newArgumentsCopy = new ArrayList<Expression>(newArguments);
        newArguments.clear();
        arguments.clear();
        arguments.addAll(newArgumentsCopy);
        this.resolveImports((ASTNode)parent);
    }

    public void replaceInvocationName(MethodInvocation invocation, String newIdentifier) throws Exception {
        this.setIdentifier(invocation.getName(), newIdentifier);
        this.replaceInvocationBinding((Expression)invocation);
    }

    public void replaceInvocationExpression(MethodInvocation invocation, String newExpressionSource) throws Exception {
        if (invocation.getExpression() != null) {
            this.replaceExpression(invocation.getExpression(), newExpressionSource);
        } else {
            int position = invocation.getStartPosition();
            Expression newExpression = this.getParser().parseExpression(position, newExpressionSource);
            this.replaceSubstring(position, 0, String.valueOf(newExpressionSource) + ".");
            invocation.setExpression(newExpression);
            int newInvocationPosition = invocation.getStartPosition();
            MethodInvocation node = invocation;
            while (node.getStartPosition() == newInvocationPosition) {
                AstNodeUtils.setSourceBegin_keepEnd((ASTNode)node, position);
                node = node.getParent();
            }
        }
        this.replaceInvocationBinding((Expression)invocation);
    }

    public ASTNode replaceInvocationBinding(Expression invocation) throws Exception {
        Assert.isLegal(invocation instanceof MethodInvocation || invocation instanceof ClassInstanceCreation);
        Expression parsedInvocation = this.m_parser.parseExpression(invocation.getStartPosition(), this.getSource((ASTNode)invocation));
        this.replaceMethodBinding((ASTNode)invocation, (ASTNode)parsedInvocation);
        return parsedInvocation;
    }

    private void replaceMethodBinding(ASTNode oldNode, ASTNode parsedNode) {
        IMethodBinding parsedBinding = (IMethodBinding)parsedNode.getProperty("METHOD_BINDING");
        Assert.isTrue(parsedBinding instanceof DesignerMethodBinding);
        oldNode.setProperty("METHOD_BINDING", (Object)parsedBinding);
    }

    public void addAnonymousClassDeclaration(ClassInstanceCreation creation) throws Exception {
        Assert.isNull2(creation.getAnonymousClassDeclaration(), "Already has anonymous: {0}", creation);
        Statement statement = AstNodeUtils.getEnclosingStatement((ASTNode)creation);
        String indent = this.getWhitespaceToLeft(statement.getStartPosition(), false);
        int begin = AstNodeUtils.getSourceBegin((ASTNode)creation);
        int end = AstNodeUtils.getSourceEnd((ASTNode)creation);
        String eol = this.m_generation.getEndOfLine();
        String sourceInsert = " {" + eol + indent + "}";
        String sourceNewCreation = String.valueOf(this.getSource((ASTNode)creation)) + sourceInsert;
        this.replaceSubstring(end, 0, sourceInsert);
        ClassInstanceCreation newCreation = (ClassInstanceCreation)this.getParser().parseExpression(begin, sourceNewCreation);
        AnonymousClassDeclaration newAnonymous = newCreation.getAnonymousClassDeclaration();
        newCreation.setAnonymousClassDeclaration(null);
        creation.setAnonymousClassDeclaration(newAnonymous);
        ClassInstanceCreation enclosingNode = creation;
        while (AstNodeUtils.getSourceEnd((ASTNode)enclosingNode) == end) {
            AstNodeUtils.setSourceEnd((ASTNode)enclosingNode, (ASTNode)newAnonymous);
            enclosingNode = enclosingNode.getParent();
        }
    }

    private DesignerTypeBinding getDesignerTypeBinding(ASTNode node) {
        ITypeBinding currentBinding = AstNodeUtils.getTypeBinding((TypeDeclaration)node);
        DesignerTypeBinding designerBinding = this.m_bindingContext.getCopy(currentBinding);
        node.setProperty("TYPE_BINDING", (Object)designerBinding);
        return designerBinding;
    }

    private DesignerMethodBinding getDesignerMethodBinding(ASTNode node) {
        IMethodBinding currentMethodBinding = node instanceof MethodDeclaration ? AstNodeUtils.getMethodBinding((MethodDeclaration)node) : (node instanceof MethodInvocation ? AstNodeUtils.getMethodBinding((MethodInvocation)node) : AstNodeUtils.getCreationBinding((ClassInstanceCreation)node));
        if (currentMethodBinding instanceof DesignerMethodBinding) {
            return (DesignerMethodBinding)currentMethodBinding;
        }
        DesignerMethodBinding designerMethodBinding = this.m_bindingContext.get(currentMethodBinding);
        node.setProperty("METHOD_BINDING", (Object)designerMethodBinding);
        return designerMethodBinding;
    }

    public Expression addArrayElement(ArrayInitializer arrayInitializer, int index, String source) throws Exception {
        int position = this.insertToArrayBody(arrayInitializer, index, source);
        Expression element = this.getParser().parseExpression(position, source);
        List<Expression> elements = DomGenerics.expressions(arrayInitializer);
        elements.add(index, element);
        this.resolveImports((ASTNode)element);
        return element;
    }

    public Expression moveArrayElement(ArrayInitializer oldArray, ArrayInitializer newArray, int oldIndex, int newIndex) throws Exception {
        Expression expression = DomGenerics.expressions(oldArray).get(oldIndex);
        String source = this.getSource((ASTNode)expression);
        this.removeArrayElement(oldArray, oldIndex);
        int position = this.insertToArrayBody(newArray, newIndex, source);
        DomGenerics.expressions(newArray).add(newIndex, expression);
        AstNodeUtils.moveNode((ASTNode)expression, position);
        return expression;
    }

    private int insertToArrayBody(ArrayInitializer arrayInitializer, int index, String source) throws Exception {
        int position;
        List<Expression> elements = DomGenerics.expressions(arrayInitializer);
        String sourcePrefix = "";
        String sourceSuffix = "";
        if (index == 0) {
            if (elements.size() == 0) {
                position = AstNodeUtils.getSourceEnd((ASTNode)arrayInitializer) - 1;
            } else {
                Expression firstElement = elements.get(index);
                position = AstNodeUtils.getSourceBegin((ASTNode)firstElement);
                sourceSuffix = ", ";
            }
        } else {
            Expression prevElement = elements.get(index - 1);
            position = AstNodeUtils.getSourceEnd((ASTNode)prevElement);
            sourcePrefix = ", ";
        }
        this.replaceSubstring(position, 0, String.valueOf(sourcePrefix) + source + sourceSuffix);
        return position += sourcePrefix.length();
    }

    public void removeArrayElement(ArrayInitializer arrayInitializer, int index) throws Exception {
        List<Expression> elements = DomGenerics.expressions(arrayInitializer);
        if (index >= elements.size()) {
            return;
        }
        Expression element = elements.get(index);
        int sourceBegin = AstNodeUtils.getSourceBegin((ASTNode)element);
        int sourceEnd = AstNodeUtils.getSourceEnd((ASTNode)element);
        if (index == 0) {
            sourceEnd = elements.size() == 1 ? this.indexOf("}", sourceEnd) : this.indexOfAnyBut(", \t\r\n", sourceEnd);
        } else {
            sourceBegin = this.indexOfAnyButBackward(", \t\r\n", sourceBegin) + 1;
        }
        elements.remove(index);
        this.replaceSubstring(sourceBegin, sourceEnd - sourceBegin, "");
    }

    public void exchangeArrayElements(ArrayInitializer arrayInitializer, int index_1, int index_2) throws Exception {
        List<Expression> elements = DomGenerics.expressions(arrayInitializer);
        Expression element_1 = elements.get(index_1);
        Expression element_2 = elements.get(index_2);
        String source_1 = this.getSource((ASTNode)element_1);
        String source_2 = this.getSource((ASTNode)element_2);
        int position_1 = element_1.getStartPosition();
        int position_2 = element_2.getStartPosition();
        int length_1 = element_1.getLength();
        int length_2 = element_2.getLength();
        elements.set(index_1, (Expression)arrayInitializer.getAST().newSimpleName("foo_1"));
        elements.set(index_2, (Expression)arrayInitializer.getAST().newSimpleName("foo_2"));
        if (position_1 < position_2) {
            this.replaceSubstring(position_2, length_2, source_1);
            this.replaceSubstring(position_1, length_1, source_2);
            position_2 += length_2 - length_1;
        } else {
            this.replaceSubstring(position_1, length_1, source_2);
            this.replaceSubstring(position_2, length_2, source_1);
            position_1 += length_1 - length_2;
        }
        AstNodeUtils.moveNode((ASTNode)element_1, position_2);
        AstNodeUtils.moveNode((ASTNode)element_2, position_1);
        elements.set(index_1, element_2);
        elements.set(index_2, element_1);
    }
}

