/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.java6.model;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.layout.absolute.IImageProvider;
import org.eclipse.wb.internal.core.utils.IAdaptable;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.layout.group.model.GroupLayoutClipboardCommand;
import org.eclipse.wb.internal.layout.group.model.GroupLayoutCodeSupport;
import org.eclipse.wb.internal.layout.group.model.GroupLayoutSupport;
import org.eclipse.wb.internal.layout.group.model.IGroupLayoutInfo;
import org.eclipse.wb.internal.swing.java6.Activator;
import org.eclipse.wb.internal.swing.java6.model.GroupLayoutAssociation;
import org.eclipse.wb.internal.swing.java6.model.SwingGroupLayoutCodeSupport;
import org.eclipse.wb.internal.swing.java6.model.SwingVisualMapper;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutClipboardCommand;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

public final class GroupLayoutInfo2
extends LayoutInfo
implements IAdaptable {
    public static final String FLAG_IS_MORPHING = "FLAG_IS_MORPHING";
    private GroupLayoutSupport m_layoutSupport;

    public GroupLayoutInfo2(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.addBroadcastListener(new JavaEventListener(){

            public void replaceChildAfter(JavaInfo parent, JavaInfo oldChild, JavaInfo newChild) throws Exception {
                if (oldChild == GroupLayoutInfo2.this) {
                    GroupLayoutInfo2 newLayout = (GroupLayoutInfo2)newChild;
                    newLayout.m_layoutSupport = GroupLayoutInfo2.this.m_layoutSupport;
                }
            }
        });
        if (!description.hasTrueTag(FLAG_IS_MORPHING)) {
            this.m_layoutSupport = new SwingGroupLayoutSupport(this, new SwingGroupLayoutCodeSupport(this), new SwingVisualMapper(this));
        }
    }

    protected void clipboardCopy_addContainerCommands(List<ClipboardCommand> commands) throws Exception {
        super.clipboardCopy_addContainerCommands(commands);
        commands.add((ClipboardCommand)new GroupLayoutClipboardCommand(this.m_layoutSupport){
            private static final long serialVersionUID = 0L;

            protected GroupLayoutSupport getLayoutSupport(JavaInfo container) {
                ContainerInfo host = (ContainerInfo)container;
                GroupLayoutInfo2 layout = (GroupLayoutInfo2)host.getLayout();
                return layout.m_layoutSupport;
            }
        });
    }

    protected void clipboardCopy_addComponentCommands(ComponentInfo component, List<ClipboardCommand> commands) throws Exception {
        commands.add((ClipboardCommand)new LayoutClipboardCommand<GroupLayoutInfo2>(component){
            private static final long serialVersionUID = 0L;

            protected void add(GroupLayoutInfo2 layout, ComponentInfo component) throws Exception {
                layout.m_layoutSupport.addComponentImpl((AbstractComponentInfo)component);
            }
        });
    }

    public void onSet() throws Exception {
        this.m_layoutSupport.onSet();
    }

    protected void onDelete() throws Exception {
        List components = this.m_layoutSupport.getLayoutChildren();
        for (AbstractComponentInfo component : components) {
            InvocationChildAssociation association = new InvocationChildAssociation("%parent%.add(%child%)");
            association.add((JavaInfo)component, JavaInfoUtils.getTarget((JavaInfo)this.getContainer()), null);
        }
        super.onDelete();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (JavaInfo.class.isAssignableFrom(adapter)) {
            return adapter.cast((Object)this);
        }
        if (GroupLayoutSupport.class.isAssignableFrom(adapter) || IGroupLayoutInfo.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.m_layoutSupport);
        }
        return null;
    }

    private static final class ImageProvider
    implements IImageProvider {
        static final IImageProvider INSTANCE = new ImageProvider();

        private ImageProvider() {
        }

        public Image getImage(String path) {
            return Activator.getImage(path);
        }
    }

    private static final class SwingGroupLayoutSupport
    extends GroupLayoutSupport {
        private SwingGroupLayoutSupport(GroupLayoutInfo2 layout, GroupLayoutCodeSupport codeSupport, VisualMapper visualMapper) {
            super((JavaInfo)layout, codeSupport, visualMapper);
        }

        protected List<?> getComponents() {
            return this.getGroupLayout().getComponents();
        }

        public Insets getContainerInsets() {
            return this.getGroupLayout().getContainer().getInsets();
        }

        public AbstractComponentInfo getLayoutContainer() {
            return this.getGroupLayout().getContainer();
        }

        public boolean isRelatedComponent(ObjectInfo component) {
            return this.getGroupLayout().isManagedComponent(component);
        }

        protected AssociationObject getAssociationObject() {
            return new AssociationObject("GroupLayout Empty", (Association)new GroupLayoutAssociation(), false);
        }

        protected IImageProvider getImageProvider() {
            return ImageProvider.INSTANCE;
        }

        private GroupLayoutInfo2 getGroupLayout() {
            return (GroupLayoutInfo2)this.getLayout();
        }
    }
}

