/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.core;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wb.internal.discovery.core.Messages;
import org.eclipse.wb.internal.discovery.core.WBDiscoveryCorePlugin;
import org.eclipse.wb.internal.discovery.core.WBToolkitRegistry;

class WBToolkitRegistryUpdateJob
extends Job {
    private static final String UPDATE_URL = "http://dev.eclipse.org/svnroot/tools/org.eclipse.windowbuilder/trunk/org.eclipse.wb.discovery.core/resources/toolkits.xml";

    public WBToolkitRegistryUpdateJob() {
        super(Messages.WBToolkitRegistryUpdateJob_updateJobTitle);
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.doUpdate(monitor);
        }
        catch (RuntimeException re) {
            WBDiscoveryCorePlugin.logError(re);
        }
        return Status.OK_STATUS;
    }

    private void doUpdate(IProgressMonitor monitor) {
        block3: {
            try {
                long lastCachedModified;
                URL url = this.getURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("HEAD");
                int responseCode = connection.getResponseCode();
                long lastModified = connection.getHeaderFieldDate("Last-Modified", 0L);
                connection.disconnect();
                if (responseCode == 200 && lastModified > (lastCachedModified = WBToolkitRegistry.getRegistry().getLastCachedModified())) {
                    WBToolkitRegistry.getRegistry().updateCacheFrom(url);
                }
            }
            catch (IOException ioe) {
                if (!WBDiscoveryCorePlugin.DEBUG) break block3;
                WBDiscoveryCorePlugin.logError("Error polling toolkits.xml", ioe);
            }
        }
    }

    private URL getURL() {
        try {
            return new URL(UPDATE_URL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

