/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.ui;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.discovery.core.WBToolkit;
import org.eclipse.wb.internal.discovery.core.WBToolkitRegistry;
import org.eclipse.wb.internal.discovery.ui.P2Provisioner;
import org.eclipse.wb.internal.discovery.ui.util.ToolkitPingJob;
import org.eclipse.wb.internal.discovery.ui.wizard.DynamicRegistryHelper;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBDiscoveryUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wb.discovery.ui";
    public static final boolean DEBUG = Boolean.getBoolean("org.eclipse.wb.discovery.debug");
    public static final String CONTRIBUTE_WIZARD_ENTRIES_PREF = "contributeWizardEntries";
    private static WBDiscoveryUiPlugin plugin;
    private static LocalResourceManager resourceManager;
    private WBToolkitRegistry.IRegistryChangeListener registryListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initializeDefaultPreferences(this.getPreferenceStore());
        try {
            this.contributeWizardEntries();
            this.listenForToolkitUpdates();
        }
        catch (Throwable t) {
            WBDiscoveryUiPlugin.logError(t);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.registryListener != null) {
            WBToolkitRegistry.getRegistry().removeRegistryListener(this.registryListener);
            this.registryListener = null;
        }
        plugin = null;
        super.stop(context);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(CONTRIBUTE_WIZARD_ENTRIES_PREF, true);
    }

    public static WBDiscoveryUiPlugin getPlugin() {
        return plugin;
    }

    public static void logError(Throwable t) {
        WBDiscoveryUiPlugin.getPlugin().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.toString(), t));
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        if (resourceManager == null) {
            resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return resourceManager.createImage(imageDescriptor);
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void installToolkits(List<WBToolkit> toolkits, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        P2Provisioner provisioner = new P2Provisioner(toolkits);
        this.ping(toolkits);
        provisioner.installToolkits(monitor);
    }

    public void uninstallToolkits(List<WBToolkit> toolkits, IProgressMonitor monitor) throws ProvisionException, OperationCanceledException {
        P2Provisioner provisioner = new P2Provisioner(toolkits);
        provisioner.uninstallToolkits(monitor);
    }

    public boolean getContributeToWizards() {
        return this.getPreferenceStore().getBoolean(CONTRIBUTE_WIZARD_ENTRIES_PREF);
    }

    protected void listenForToolkitUpdates() {
        this.registryListener = new WBToolkitRegistry.IRegistryChangeListener(){

            public void handleRegistryChange() {
                DynamicRegistryHelper.getRegistryHelper().removeRegistrations();
                DynamicRegistryHelper.getRegistryHelper().registerWizards();
            }
        };
    }

    protected void contributeWizardEntries() {
        if (this.getContributeToWizards()) {
            DynamicRegistryHelper.getRegistryHelper().registerWizards();
        }
    }

    private void ping(List<WBToolkit> toolkits) {
        ToolkitPingJob job = new ToolkitPingJob(toolkits);
        job.schedule();
    }
}

