/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model;

import com.jgoodies.forms.layout.CellConstraints;
import java.util.List;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.util.surround.LayoutSurroundSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormLayoutSurroundSupport
extends LayoutSurroundSupport {
    static final String CELLS_KEY = "SurroundSupport_CELLS";
    private final FormLayoutInfo m_layout;
    private Rectangle m_enclosingCells;

    public FormLayoutSurroundSupport(FormLayoutInfo layout) {
        super((LayoutInfo)layout);
        this.m_layout = layout;
    }

    protected boolean validateComponents(List<ComponentInfo> components) throws Exception {
        this.m_enclosingCells = FormLayoutSurroundSupport.getCells(components.get(0));
        for (ComponentInfo component : components) {
            this.m_enclosingCells.union(FormLayoutSurroundSupport.getCells(component));
        }
        for (ComponentInfo component : this.m_layout.getContainer().getChildrenComponents()) {
            if (components.contains(component) || !this.m_enclosingCells.intersects(FormLayoutSurroundSupport.getCells(component))) continue;
            return false;
        }
        return super.validateComponents(components);
    }

    protected void addContainer(ContainerInfo container, List<ComponentInfo> components) throws Exception {
        container.putArbitraryValue((Object)CELLS_KEY, (Object)this.m_enclosingCells);
        JavaInfoUtils.setParameter((JavaInfo)container, (String)"gridLayout.grabHorizontal", (String)"false");
        JavaInfoUtils.setParameter((JavaInfo)container, (String)"gridLayout.grabVertical", (String)"false");
        this.m_layout.command_CREATE((ComponentInfo)container, this.m_enclosingCells.x, false, this.m_enclosingCells.y, false);
        FormLayoutSurroundSupport.setCells((ComponentInfo)container, this.m_enclosingCells);
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints((ComponentInfo)container);
        constraints.alignH = CellConstraints.FILL;
        constraints.alignV = CellConstraints.FILL;
        constraints.write();
    }

    protected void moveDone(ContainerInfo container, List<ComponentInfo> components) throws Exception {
        super.moveDone((AbstractComponentInfo)container, components);
        this.m_layout.normalizeSpanning();
    }

    static void setCells(ComponentInfo component, Rectangle cells) throws Exception {
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
        constraints.x = cells.x;
        constraints.y = cells.y;
        constraints.width = cells.width;
        constraints.height = cells.height;
        constraints.write();
    }

    static Rectangle getCells(ComponentInfo component) throws Exception {
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints(component);
        return new Rectangle(constraints.x, constraints.y, constraints.width, constraints.height);
    }
}

