/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model;

import com.google.common.collect.Maps;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlLoadingContext
implements ILoadingContext {
    private final EditorContext m_editorContext;
    private final Map<String, Object> m_globalMap = Maps.newHashMap();

    public XmlLoadingContext(EditorContext editorContext) {
        this.m_editorContext = editorContext;
    }

    public String getToolkitId() {
        return this.m_editorContext.getToolkit().getId();
    }

    public URL getResource(String name) throws Exception {
        URL resource = this.m_editorContext.getClassLoader().getResource(name);
        if (resource != null) {
            return resource;
        }
        resource = XmlLoadingContext.getResource(this.m_editorContext.getJavaProject(), name);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    public List<IDescriptionVersionsProvider> getDescriptionVersionsProviders() {
        return this.m_editorContext.getDescriptionVersionsProviders();
    }

    public Object getGlobalValue(String key) {
        return this.m_globalMap.get(key);
    }

    public void putGlobalValue(String key, Object value) {
        this.m_globalMap.put(key, value);
    }

    private static URL getResource(IJavaProject javaProject, String name) throws Exception {
        List files = ProjectUtils.findFiles((IJavaProject)javaProject, (String)("wbp-meta/" + name));
        if (!files.isEmpty()) {
            IFile file = (IFile)files.get(0);
            return file.getLocation().toFile().toURL();
        }
        return null;
    }
}

