/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description.rules;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.digester.Rule;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.property.accessor.MethodExpressionAccessor;
import org.eclipse.wb.internal.core.xml.model.property.converter.ExpressionConverter;
import org.xml.sax.Attributes;

public final class CreatePropertiesPropertyDescriptorRule
extends Rule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        ComponentDescription componentDescription = (ComponentDescription)this.digester.peek();
        List descriptors = ReflectionUtils.getPropertyDescriptors(null, componentDescription.getComponentClass());
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            this.addSingleProperty(componentDescription, propertyDescriptor);
        }
    }

    private void addSingleProperty(ComponentDescription componentDescription, PropertyDescriptor propertyDescriptor) throws Exception {
        Method setMethod = propertyDescriptor.getWriteMethod();
        if (setMethod == null) {
            return;
        }
        if (!ReflectionUtils.isPublic((Method)setMethod)) {
            return;
        }
        String title = propertyDescriptor.getName();
        String attribute = StringUtils.substringBeforeLast((String)StringUtils.uncapitalize((String)title), (String)"(");
        Method getMethod = propertyDescriptor.getReadMethod();
        Class<?> propertyType = propertyDescriptor.getPropertyType();
        String id = ReflectionUtils.getMethodSignature((Method)setMethod);
        MethodExpressionAccessor accessor = new MethodExpressionAccessor(attribute, setMethod, getMethod);
        ExpressionConverter converter = DescriptionPropertiesHelper.getConverterForType(propertyType);
        PropertyEditor editor = DescriptionPropertiesHelper.getEditorForType(propertyType);
        GenericPropertyDescription property = new GenericPropertyDescription(id, title, propertyType, accessor);
        property.setConverter(converter);
        property.setEditor(editor);
        componentDescription.addProperty(property);
    }
}

