/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.generic;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.generic.FlowContainerConfiguration;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public final class FlowContainerConfigurable
implements FlowContainer {
    private final XmlObjectInfo m_container;
    private final FlowContainerConfiguration m_configuration;

    public FlowContainerConfigurable(XmlObjectInfo container, FlowContainerConfiguration configuration) {
        this.m_container = container;
        this.m_configuration = configuration;
    }

    public boolean isHorizontal() {
        return this.m_configuration.getHorizontalPredicate().apply((Object)this.m_container);
    }

    public boolean validateComponent(Object component) {
        return this.m_configuration.getComponentValidator().validate((Object)this.m_container, component);
    }

    public boolean validateReference(Object reference) {
        return this.m_configuration.getReferenceValidator().validate((Object)this.m_container, reference);
    }

    public void command_CREATE(Object newObject, Object referenceObject) throws Exception {
        if (!this.tryDuckTyping("command_CREATE", newObject, referenceObject)) {
            this.command_CREATE_default(newObject, referenceObject);
        }
        this.tryDuckTyping("command_CREATE_after", newObject, referenceObject);
        this.tryDuckTyping("command_APPEND_after", newObject, referenceObject);
        this.tryDuckTyping("command_TARGET_after", newObject, referenceObject);
    }

    public void command_MOVE(Object moveObject, Object referenceObject) throws Exception {
        if (!this.tryDuckTyping("command_MOVE", moveObject, referenceObject)) {
            this.command_MOVE_default(moveObject, referenceObject);
        }
        this.tryDuckTyping("command_MOVE_after", moveObject, referenceObject);
        this.tryDuckTyping("command_TARGET_after", moveObject, referenceObject);
    }

    private void command_CREATE_default(Object newObject, Object referenceObject) throws Exception {
        XmlObjectInfo component = (XmlObjectInfo)((Object)newObject);
        XmlObjectInfo nextComponent = (XmlObjectInfo)((Object)referenceObject);
        Association association = this.m_configuration.getAssociation();
        XmlObjectUtils.add(component, association, this.m_container, nextComponent);
    }

    private void command_MOVE_default(Object moveObject, Object referenceObject) throws Exception {
        XmlObjectInfo component = (XmlObjectInfo)((Object)moveObject);
        XmlObjectInfo oldParent = (XmlObjectInfo)component.getParent();
        XmlObjectInfo nextComponent = (XmlObjectInfo)((Object)referenceObject);
        if (System.getProperty("flowContainer.simulateMove") == null) {
            Association association = this.m_configuration.getAssociation();
            XmlObjectUtils.move(component, association, this.m_container, nextComponent);
        }
        if (oldParent != this.m_container) {
            this.tryDuckTyping("command_ADD_after", (Object)component, referenceObject);
            this.tryDuckTyping("command_APPEND_after", (Object)component, referenceObject);
        }
    }

    private boolean tryDuckTyping(String methodName, Object object, Object referenceObject) throws Exception {
        Method method = this.getCommandMethod(methodName, object, referenceObject);
        if (method != null) {
            method.invoke((Object)this.m_container, object, referenceObject);
            return true;
        }
        return false;
    }

    private Method getCommandMethod(String methodName, Object object, Object referenceObject) {
        List methods = Lists.newArrayList();
        Method[] methodArray = ((Object)((Object)this.m_container)).getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypes;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && (parameterTypes = method.getParameterTypes()).length == 2 && ReflectionUtils.isAssignableFrom(parameterTypes[0], (Object)object) && ReflectionUtils.isAssignableFrom(parameterTypes[1], (Object)referenceObject)) {
                methods.add(method);
            }
            ++n2;
        }
        return ReflectionUtils.getMostSpecific((List)methods);
    }
}

