/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.builder;

import com.atlassw.tools.eclipse.checkstyle.CheckstylePlugin;
import com.atlassw.tools.eclipse.checkstyle.config.FileSet;
import com.atlassw.tools.eclipse.checkstyle.config.MetadataFactory;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;

class Auditor {
    private static final int MONITOR_INTERVAL = 10;
    private IProject mProject;
    private FileSet[] mFileSets;

    Auditor(IProject iProject, List list) {
        this.mProject = iProject;
        this.mFileSets = list.toArray(new FileSet[list.size()]);
    }

    void checkFiles(Collection collection, ClassLoader classLoader, IProgressMonitor iProgressMonitor) throws CheckstylePluginException, CoreException {
        IFile iFile;
        Object object;
        File[] fileArray;
        int n;
        this.mProject.deleteMarkers("com.atlassw.tools.eclipse.checkstyle.CheckstyleMarker", true, 0);
        if (this.mFileSets.length <= 0) {
            this.mProject.deleteMarkers("com.atlassw.tools.eclipse.checkstyle.CheckstyleMarker", true, 2);
            return;
        }
        CheckstyleAuditListener checkstyleAuditListener = new CheckstyleAuditListener();
        Preferences preferences = CheckstylePlugin.getDefault().getPluginPreferences();
        boolean bl = preferences.getBoolean("include.rule.names");
        checkstyleAuditListener.setAddRuleName(bl);
        Checker[] checkerArray = new Checker[this.mFileSets.length];
        for (n = 0; n < checkerArray.length; ++n) {
            try {
                checkerArray[n] = new Checker();
                checkerArray[n].addListener((AuditListener)checkstyleAuditListener);
                fileArray = this.mFileSets[n].getCheckConfig();
                if (fileArray == null) {
                    object = "Checkstyle CheckConfig '" + this.mFileSets[n].getCheckConfigName() + "' not found";
                    iFile = this.mProject.createMarker("com.atlassw.tools.eclipse.checkstyle.CheckstyleMarker");
                    iFile.setAttribute("message", object);
                    iFile.setAttribute("priority", 1);
                    iFile.setAttribute("severity", 2);
                    continue;
                }
                checkerArray[n].setClassloader(classLoader);
                checkerArray[n].configure((Configuration)fileArray);
                continue;
            }
            catch (CheckstyleException checkstyleException) {
                CheckstyleLog.error("Failed to create Checkstyle Checker", checkstyleException);
                throw new CheckstylePluginException("Failed to create Checkstyle Checker");
            }
        }
        n = 0;
        fileArray = new File[1];
        object = collection.iterator();
        while (object.hasNext()) {
            iFile = (IFile)object.next();
            iFile.deleteMarkers("com.atlassw.tools.eclipse.checkstyle.CheckstyleMarker", true, 2);
            for (int i = 0; i < this.mFileSets.length; ++i) {
                if (!this.mFileSets[i].includesFile(iFile)) continue;
                String string = iFile.getLocation().toOSString();
                fileArray[0] = new File(string);
                checkstyleAuditListener.setFile(iFile);
                checkerArray[i].process(fileArray);
            }
            if (iProgressMonitor == null || ++n % 10 != 0) continue;
            iProgressMonitor.worked(10);
            IPath iPath = iFile.getFullPath();
            int n2 = iPath.segmentCount();
            iPath = iPath.uptoSegment(n2 - 1);
            String string = iPath.toString();
            string = string.substring(1, string.length());
            iProgressMonitor.subTask("Checking " + string);
            if (!iProgressMonitor.isCanceled()) continue;
            break;
        }
    }

    private static class CheckstyleAuditListener
    implements AuditListener {
        private IFile mFile;
        private boolean mAddRuleName = false;
        private Map mClassToNameMap = MetadataFactory.getClassToNameMap();

        private CheckstyleAuditListener() {
        }

        public void addError(AuditEvent auditEvent) {
            try {
                SeverityLevel severityLevel = auditEvent.getSeverityLevel();
                if (!severityLevel.equals((Object)SeverityLevel.IGNORE)) {
                    IMarker iMarker = this.mFile.createMarker("com.atlassw.tools.eclipse.checkstyle.CheckstyleMarker");
                    iMarker.setAttribute("lineNumber", auditEvent.getLine());
                    iMarker.setAttribute("priority", 1);
                    iMarker.setAttribute("severity", this.getSeverityValue(severityLevel));
                    iMarker.setAttribute("message", (Object)this.getMessage(auditEvent));
                }
            }
            catch (CoreException coreException) {
                CheckstyleLog.error("Exception while adding Checkstyle marker to file", coreException);
            }
        }

        public void addException(AuditEvent auditEvent, Throwable throwable) {
            CheckstyleLog.warning("Exception while auditing, file=" + this.mFile.getName() + " exception=" + throwable.getMessage());
        }

        public void auditFinished(AuditEvent auditEvent) {
        }

        public void auditStarted(AuditEvent auditEvent) {
        }

        public void fileFinished(AuditEvent auditEvent) {
        }

        public void fileStarted(AuditEvent auditEvent) {
        }

        public IFile getFile() {
            return this.mFile;
        }

        public void setFile(IFile iFile) {
            this.mFile = iFile;
        }

        private int getSeverityValue(SeverityLevel severityLevel) {
            int n = 1;
            if (severityLevel.equals((Object)SeverityLevel.INFO)) {
                n = 0;
            } else if (severityLevel.equals((Object)SeverityLevel.WARNING)) {
                n = 1;
            } else if (severityLevel.equals((Object)SeverityLevel.ERROR)) {
                n = 2;
            }
            return n;
        }

        private String getMessage(AuditEvent auditEvent) {
            String string = auditEvent.getMessage();
            if (this.mAddRuleName) {
                StringBuffer stringBuffer = new StringBuffer(this.getRuleName(auditEvent));
                stringBuffer.append(": ").append(string);
                string = stringBuffer.toString();
            }
            return string;
        }

        private String getRuleName(AuditEvent auditEvent) {
            String string = (String)this.mClassToNameMap.get(auditEvent.getSourceName());
            if (string == null) {
                string = "Unknown";
            }
            return string;
        }

        public boolean getAddRuleName() {
            return this.mAddRuleName;
        }

        public void setAddRuleName(boolean bl) {
            this.mAddRuleName = bl;
        }
    }
}

