/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.builder;

import com.atlassw.tools.eclipse.checkstyle.builder.Auditor;
import com.atlassw.tools.eclipse.checkstyle.config.FileSetFactory;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CheckstyleBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.atlassw.tools.eclipse.checkstyle.CheckstyleBuilder";
    private static final String JAVA_SUFFIX = ".java";
    private boolean mEclipse_2_1_Safe = false;
    private boolean mEclipseVersionDetermined = false;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        switch (n) {
            case 9: {
                this.doAutoBuild(map, iProgressMonitor);
                break;
            }
            case 6: {
                this.doFullBuild(map, iProgressMonitor);
                break;
            }
            case 10: {
                this.doIncrementalBuild(map, iProgressMonitor);
                break;
            }
            default: {
                this.doFullBuild(map, iProgressMonitor);
            }
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        super.setInitializationData(iConfigurationElement, string, object);
    }

    private void doAutoBuild(Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.doBuild(map, iProgressMonitor);
    }

    private void doFullBuild(Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.doBuild(map, iProgressMonitor);
    }

    private void doIncrementalBuild(Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.doBuild(map, iProgressMonitor);
    }

    private void doBuild(Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        IProject iProject = this.getProject();
        if (iProject == null) {
            CheckstyleLog.warning("project is null");
            return;
        }
        List list = null;
        try {
            list = FileSetFactory.getEnabledFileSets(iProject);
        }
        catch (CheckstylePluginException checkstylePluginException) {
            String string = checkstylePluginException.getMessage();
            CheckstyleLog.error(string, checkstylePluginException);
            Status status = new Status(4, "com.atlassw.tools.eclipse.checkstyle", 4, string, (Throwable)checkstylePluginException);
            throw new CoreException((IStatus)status);
        }
        if (list.size() <= 0) {
            iProject.deleteMarkers("com.atlassw.tools.eclipse.checkstyle.CheckstyleMarker", true, 2);
            return;
        }
        Collection collection = null;
        IResourceDelta iResourceDelta = this.getDelta(iProject);
        collection = iResourceDelta != null ? this.getFiles(iResourceDelta) : this.getFiles((IContainer)iProject);
        if (collection.size() <= 0) {
            return;
        }
        URLClassLoader uRLClassLoader = null;
        IJavaProject iJavaProject = (IJavaProject)iProject.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = CheckstyleBuilder.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        try {
            object = this.getClasspathURLs(iJavaProject, false);
            URL[] uRLArray = object.toArray(new URL[object.size()]);
            uRLClassLoader = new URLClassLoader(uRLArray);
        }
        catch (CoreException coreException) {
            throw coreException;
        }
        catch (Throwable throwable) {
            CheckstyleLog.error("Unable to create a classloader for the project", throwable);
            uRLClassLoader = null;
        }
        iProgressMonitor.beginTask("Checkstyle", collection.size());
        object = new Auditor(this.getProject(), list);
        try {
            ((Auditor)object).checkFiles(collection, uRLClassLoader, iProgressMonitor);
        }
        catch (CheckstylePluginException checkstylePluginException) {
            String string = "Error occured while checking file: " + checkstylePluginException.getMessage();
            CheckstyleLog.error(string, checkstylePluginException);
            Status status = new Status(4, "com.atlassw.tools.eclipse.checkstyle", 4, string, (Throwable)checkstylePluginException);
            throw new CoreException((IStatus)status);
        }
    }

    private Collection getFiles(IResourceDelta iResourceDelta) throws CoreException {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(0);
        ArrayList<IResourceDelta> arrayList2 = new ArrayList<IResourceDelta>(0);
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        for (int i = 0; i < iResourceDeltaArray.length; ++i) {
            IResourceDelta iResourceDelta2 = iResourceDeltaArray[i];
            IResource iResource = iResourceDelta2.getResource();
            int n = iResource.getType();
            if (n == 1) {
                int n2 = iResourceDelta2.getKind();
                if (n2 != 1 && n2 != 4 || !iResource.getName().endsWith(JAVA_SUFFIX)) continue;
                arrayList.add(iResource);
                continue;
            }
            if (n != 2) continue;
            arrayList2.add(iResourceDelta2);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getFiles((IResourceDelta)iterator.next()));
        }
        return arrayList;
    }

    private Collection getFiles(IContainer iContainer) throws CoreException {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(0);
        ArrayList<IResource> arrayList2 = new ArrayList<IResource>(0);
        IResource[] iResourceArray = iContainer.members();
        for (int i = 0; i < iResourceArray.length; ++i) {
            IResource iResource = iResourceArray[i];
            int n = iResource.getType();
            if (n == 1) {
                if (!iResource.getName().endsWith(JAVA_SUFFIX)) continue;
                arrayList.add(iResource);
                continue;
            }
            if (n != 2) continue;
            arrayList2.add(iResource);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getFiles((IContainer)iterator.next()));
        }
        return arrayList;
    }

    private List getClasspathURLs(IJavaProject iJavaProject, boolean bl) throws JavaModelException, MalformedURLException, CoreException {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
        boolean bl2 = false;
        block5: for (int i = 0; i < iClasspathEntryArray.length; ++i) {
            if (bl && !iClasspathEntryArray[i].isExported() && iClasspathEntryArray[i].getEntryKind() != 3) continue;
            switch (iClasspathEntryArray[i].getEntryKind()) {
                case 3: {
                    IPath iPath = null;
                    if (this.isEclipse_2_1_Safe()) {
                        iPath = iClasspathEntryArray[i].getOutputLocation();
                    }
                    if (iPath == null && !bl2) {
                        bl2 = true;
                        iPath = iJavaProject.getOutputLocation();
                    }
                    if (iPath == null) continue block5;
                    iPath = iPath.segmentCount() == 1 ? iJavaProject.getProject().getLocation() : iJavaProject.getProject().getParent().getFile(iPath).getLocation();
                    linkedList.add(iPath.addTrailingSeparator().toFile().toURL());
                    continue block5;
                }
                case 1: {
                    IContainer iContainer = iJavaProject.getProject().getParent();
                    IPath iPath = iContainer.getFile(iClasspathEntryArray[i].getPath()).getLocation();
                    if (iPath == null) {
                        iPath = iClasspathEntryArray[i].getPath();
                    }
                    linkedList.add(new URL("file:/" + iPath.toOSString()));
                    continue block5;
                }
                case 2: {
                    IJavaProject iJavaProject2 = (IJavaProject)ResourcesPlugin.getWorkspace().getRoot().getProject(iClasspathEntryArray[i].getPath().segment(0)).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? CheckstyleBuilder.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement);
                    linkedList.addAll(this.getClasspathURLs(iJavaProject2, true));
                    continue block5;
                }
                default: {
                    String string = "Encountered unexpected classpath entry : " + iClasspathEntryArray[i].getEntryKind();
                    CheckstyleLog.error(string);
                    Status status = new Status(4, "com.atlassw.tools.eclipse.checkstyle", 4, string, null);
                    throw new CoreException((IStatus)status);
                }
            }
        }
        return linkedList;
    }

    private void printUrls(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            System.out.println(uRL.toString());
        }
    }

    public static void buildProject(IProject iProject, Shell shell) throws CheckstylePluginException {
        IProject[] iProjectArray = new IProject[]{iProject};
        CheckstyleBuilder.buildProjects(iProjectArray, shell);
    }

    public static void buildAllProjects(Shell shell) throws CheckstylePluginException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        CheckstyleBuilder.buildProjects(iProjectArray, shell);
    }

    private static void buildProjects(IProject[] iProjectArray, Shell shell) throws CheckstylePluginException {
        Object object;
        BuildRunnable buildRunnable = new BuildRunnable();
        for (int i = 0; i < iProjectArray.length; ++i) {
            object = iProjectArray[i];
            if (!object.isOpen()) continue;
            try {
                if (!object.hasNature("com.atlassw.tools.eclipse.checkstyle.CheckstyleNature")) continue;
                buildRunnable.addProject((IProject)object);
                continue;
            }
            catch (CoreException coreException) {
                String string = "Error while building projects: " + coreException.getMessage();
                CheckstyleLog.error(string, coreException);
                throw new CheckstylePluginException(string);
            }
        }
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)buildRunnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = "Error while building projects: " + invocationTargetException.getMessage();
            CheckstyleLog.error((String)object, invocationTargetException);
            throw new CheckstylePluginException((String)object);
        }
        catch (InterruptedException interruptedException) {
            object = "Error while building projects: " + interruptedException.getMessage();
            CheckstyleLog.error((String)object, interruptedException);
            throw new CheckstylePluginException((String)object);
        }
    }

    private boolean isEclipse_2_1_Safe() {
        if (!this.mEclipseVersionDetermined) {
            Plugin plugin = Platform.getPlugin((String)"org.eclipse.jdt.core");
            if (plugin != null) {
                PluginVersionIdentifier pluginVersionIdentifier = plugin.getDescriptor().getVersionIdentifier();
                this.mEclipse_2_1_Safe = pluginVersionIdentifier.isGreaterOrEqualTo(new PluginVersionIdentifier("2.1"));
            }
            this.mEclipseVersionDetermined = true;
        }
        return this.mEclipse_2_1_Safe;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class BuildRunnable
    implements IRunnableWithProgress {
        private List mProjects = new LinkedList();

        private BuildRunnable() {
        }

        void addProject(IProject iProject) {
            this.mProjects.add(iProject);
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            Iterator iterator = this.mProjects.iterator();
            while (iterator.hasNext()) {
                IProject iProject = (IProject)iterator.next();
                try {
                    iProject.build(6, CheckstyleBuilder.BUILDER_ID, null, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        }
    }
}

