/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.config.CheckConfiguration;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigProperty;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyMetadata;
import com.atlassw.tools.eclipse.checkstyle.config.MetadataFactory;
import com.atlassw.tools.eclipse.checkstyle.config.ResolvableProperty;
import com.atlassw.tools.eclipse.checkstyle.config.RuleConfiguration;
import com.atlassw.tools.eclipse.checkstyle.config.RuleMetadata;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CheckConfigConverter {
    private static final String CHECKER_TAG = "Checker";
    private static final String TREE_WALKER_TAG = "TreeWalker";
    private static final String CORR_TAG_ROOT = "com.atlassw.property.to.resolve.";
    private static final SeverityLevel DEFAULT_SEVERITY = SeverityLevel.WARNING;
    private String mFilePath;
    private Configuration mChecker = null;
    private Configuration mTreeWalker = null;
    private HashMap mCheckerProps = new HashMap();
    private HashMap mTreeWalkerProps = new HashMap();
    private List mPropsToResolve = new LinkedList();
    private int mPropSequence = 0;
    private HashMap mResolvedProps = new HashMap();

    public void loadConfig(String string) throws CheckstylePluginException {
        this.mFilePath = string;
        try {
            this.mChecker = ConfigurationLoader.loadConfiguration((String)string, (PropertyResolver)new CSPropertyResolver());
            if (!this.mChecker.getName().equals(CHECKER_TAG)) {
                String string2 = "Root configuration node is not \"Checker\"";
                CheckstyleLog.warning(string2);
                throw new CheckstylePluginException(string2);
            }
        }
        catch (CheckstyleException checkstyleException) {
            String string3 = "Error loading check configuration";
            CheckstyleLog.warning(string3, checkstyleException);
            throw new CheckstylePluginException(string3 + checkstyleException.getMessage());
        }
        Configuration[] configurationArray = this.mChecker.getChildren();
        for (int i = 0; i < configurationArray.length; ++i) {
            if (!configurationArray[i].getName().equals(TREE_WALKER_TAG)) continue;
            this.mTreeWalker = configurationArray[i];
            break;
        }
        if (this.mTreeWalker == null) {
            String string4 = "Failed to find config node \"TreeWalker\"";
            CheckstyleLog.warning(string4);
            throw new CheckstylePluginException(string4);
        }
        try {
            int n;
            String[] stringArray = this.mChecker.getAttributeNames();
            for (n = 0; n < stringArray.length; ++n) {
                this.mCheckerProps.put(stringArray[n], this.mChecker.getAttribute(stringArray[n]));
            }
            stringArray = this.mTreeWalker.getAttributeNames();
            for (n = 0; n < stringArray.length; ++n) {
                this.mTreeWalkerProps.put(stringArray[n], this.mTreeWalker.getAttribute(stringArray[n]));
            }
        }
        catch (CheckstyleException checkstyleException) {
            String string5 = "Error loading check configuration";
            CheckstyleLog.warning(string5, checkstyleException);
            throw new CheckstylePluginException(string5 + checkstyleException.getMessage());
        }
    }

    public List getPropsToResolve() {
        return this.mPropsToResolve;
    }

    public CheckConfiguration getCheckConfiguration() throws CheckstylePluginException {
        this.buildResolvedHashMap();
        this.resolveProps(this.mCheckerProps);
        this.resolveProps(this.mTreeWalkerProps);
        List list = this.buildRules();
        File file = new File(this.mFilePath);
        String string = file.getName();
        CheckConfiguration checkConfiguration = new CheckConfiguration();
        checkConfiguration.setRuleConfigs(list);
        checkConfiguration.setName(string);
        return checkConfiguration;
    }

    private void buildResolvedHashMap() {
        Iterator iterator = this.mPropsToResolve.iterator();
        while (iterator.hasNext()) {
            ResolvableProperty resolvableProperty = (ResolvableProperty)iterator.next();
            this.mResolvedProps.put(resolvableProperty.getCorrelationTag(), resolvableProperty.getValue());
        }
    }

    private void resolveProps(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            Iterator iterator2 = this.mResolvedProps.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                if (string2.indexOf(string3) == -1) continue;
                string2 = this.replaceAll(string2, string3, string4);
            }
            hashMap.put(string, string2);
        }
    }

    private List buildRules() throws CheckstylePluginException {
        ModuleFactory moduleFactory;
        LinkedList<RuleConfiguration> linkedList = new LinkedList<RuleConfiguration>();
        try {
            moduleFactory = PackageNamesLoader.loadModuleFactory((ClassLoader)this.mTreeWalker.getClass().getClassLoader());
        }
        catch (CheckstyleException checkstyleException) {
            String string = "Failed to load module factory";
            CheckstyleLog.warning(string);
            throw new CheckstylePluginException(string);
        }
        Configuration[] configurationArray = this.mTreeWalker.getChildren();
        for (int i = 0; i < configurationArray.length; ++i) {
            RuleConfiguration ruleConfiguration = this.buildRuleConfig(configurationArray[i], moduleFactory);
            if (ruleConfiguration == null) continue;
            linkedList.add(ruleConfiguration);
        }
        return linkedList;
    }

    private RuleConfiguration buildRuleConfig(Configuration configuration, ModuleFactory moduleFactory) throws CheckstylePluginException {
        HashMap<String, String> hashMap;
        String string = null;
        try {
            hashMap = moduleFactory.createModule(configuration.getName());
            string = hashMap.getClass().getName();
        }
        catch (CheckstyleException checkstyleException) {
            String string2 = "Unable to load class for rule " + configuration.getName();
            CheckstyleLog.warning(string2, checkstyleException);
            throw new CheckstylePluginException(string2 + checkstyleException.getMessage());
        }
        hashMap = new HashMap<String, String>();
        String[] stringArray = configuration.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                hashMap.put(stringArray[i], configuration.getAttribute(stringArray[i]));
                continue;
            }
            catch (CheckstyleException checkstyleException) {
                CheckstyleLog.warning("Failed to find module attribute " + stringArray[i], checkstyleException);
            }
        }
        this.resolveProps(hashMap);
        SeverityLevel severityLevel = this.getSeverityLevel(hashMap);
        this.checkRuleMetadata(string, hashMap);
        RuleConfiguration ruleConfiguration = new RuleConfiguration(string);
        ruleConfiguration.setSeverityLevel(severityLevel);
        ruleConfiguration.setConfigProperties(this.buildConfigProperties(hashMap));
        return ruleConfiguration;
    }

    private SeverityLevel getSeverityLevel(HashMap hashMap) {
        String string = (String)hashMap.get("severity");
        hashMap.remove("severity");
        if (string == null && (string = (String)this.mTreeWalkerProps.get("severity")) == null) {
            string = (String)this.mCheckerProps.get("severity");
        }
        SeverityLevel severityLevel = DEFAULT_SEVERITY;
        if (string != null) {
            try {
                severityLevel = SeverityLevel.getInstance((String)string);
            }
            catch (Exception exception) {
                severityLevel = DEFAULT_SEVERITY;
            }
        }
        return severityLevel;
    }

    private void checkRuleMetadata(String string, HashMap hashMap) {
        RuleMetadata ruleMetadata = MetadataFactory.getRuleMetadata(string);
        if (ruleMetadata == null) {
            return;
        }
        Iterator iterator = ruleMetadata.getConfigItemMetadata().iterator();
        while (iterator.hasNext()) {
            ConfigPropertyMetadata configPropertyMetadata = (ConfigPropertyMetadata)iterator.next();
            String string2 = configPropertyMetadata.getName();
            String string3 = (String)hashMap.get(string2);
            if (string3 != null) continue;
            string3 = (String)this.mTreeWalkerProps.get(string2);
            if (string3 != null) {
                hashMap.put(string2, string3);
                continue;
            }
            string3 = (String)this.mCheckerProps.get(string2);
            if (string3 == null) continue;
            hashMap.put(string2, string3);
        }
    }

    private HashMap buildConfigProperties(HashMap hashMap) {
        HashMap<String, ConfigProperty> hashMap2 = new HashMap<String, ConfigProperty>();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            hashMap2.put(string, new ConfigProperty(string, string2));
        }
        return hashMap2;
    }

    private String replaceAll(String string, String string2, String string3) {
        String string4 = string;
        int n = string4.indexOf(string2);
        while (n >= 0) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + string2.length());
            n = string4.indexOf(string2);
        }
        return string4;
    }

    private class CSPropertyResolver
    implements PropertyResolver {
        private CSPropertyResolver() {
        }

        public String resolve(String string) {
            Object object;
            Iterator iterator = CheckConfigConverter.this.mPropsToResolve.iterator();
            while (iterator.hasNext()) {
                object = (ResolvableProperty)iterator.next();
                if (!string.equals(((ResolvableProperty)object).getPropertyName())) continue;
                return ((ResolvableProperty)object).getCorrelationTag();
            }
            object = CheckConfigConverter.CORR_TAG_ROOT + Integer.toString(CheckConfigConverter.this.mPropSequence++);
            ResolvableProperty resolvableProperty = new ResolvableProperty();
            resolvableProperty.setPropertyName(string);
            resolvableProperty.setCorrelationTag((String)object);
            CheckConfigConverter.this.mPropsToResolve.add(resolvableProperty);
            return object;
        }
    }
}

