/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.config.RuleConfiguration;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CheckConfiguration
implements Cloneable,
Configuration,
Comparable {
    private String mConfigName;
    private List mRuleConfigs = new LinkedList();
    private TreeWalker mTreeWalker = new TreeWalker();

    CheckConfiguration() {
    }

    public CheckConfiguration(Node node) throws CheckstylePluginException {
        this.mConfigName = XMLUtil.getNodeAttributeValue(node, "name");
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("rule-configuration")) continue;
            RuleConfiguration ruleConfiguration = null;
            try {
                ruleConfiguration = new RuleConfiguration(node2);
            }
            catch (CheckstylePluginException checkstylePluginException) {
                ruleConfiguration = null;
                CheckstyleLog.warning("Failed to create rule configuration, ignoring rule");
            }
            if (ruleConfiguration == null) continue;
            this.mRuleConfigs.add(ruleConfiguration);
        }
    }

    public String getConfigName() {
        return this.mConfigName;
    }

    public void setName(String string) {
        this.mConfigName = string;
    }

    public List getRuleConfigs() {
        return this.mRuleConfigs;
    }

    public void setRuleConfigs(List list) {
        this.mRuleConfigs = list;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Node toDOMNode(Document document) {
        Element element = null;
        try {
            element = document.createElement("check-configuration");
            element.setAttribute("name", this.mConfigName);
            Collections.sort(this.mRuleConfigs);
            Iterator iterator = this.mRuleConfigs.iterator();
            while (iterator.hasNext()) {
                RuleConfiguration ruleConfiguration = (RuleConfiguration)iterator.next();
                Node node = ruleConfiguration.toDOMNode(document);
                if (node == null) {
                    CheckstyleLog.warning("Audit rule lost");
                    continue;
                }
                element.appendChild(node);
            }
        }
        catch (DOMException dOMException) {
            element = null;
            CheckstyleLog.warning("Failed to create XML DOM node for audit configuration", dOMException);
        }
        return element;
    }

    public String getAttribute(String string) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public Configuration[] getChildren() {
        Configuration[] configurationArray = new Configuration[]{this.mTreeWalker};
        return configurationArray;
    }

    public String getName() {
        return "Checker";
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof CheckConfiguration) {
            String string = this.getConfigName();
            String string2 = ((CheckConfiguration)object).getConfigName();
            n = string.compareToIgnoreCase(string2);
        }
        return n;
    }

    private class TreeWalker
    implements Configuration {
        private TreeWalker() {
        }

        public String getAttribute(String string) {
            return null;
        }

        public String[] getAttributeNames() {
            return new String[0];
        }

        public Configuration[] getChildren() {
            Configuration[] configurationArray = new Configuration[CheckConfiguration.this.mRuleConfigs.size()];
            Collections.sort(CheckConfiguration.this.mRuleConfigs);
            configurationArray = CheckConfiguration.this.mRuleConfigs.toArray(configurationArray);
            return configurationArray;
        }

        public String getName() {
            return "TreeWalker";
        }
    }
}

