/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileMatchPattern
implements Cloneable {
    private static RECompiler sRECompiler = new RECompiler();
    private String mMatchPattern;
    private boolean mIsIncludePattern = true;
    private REProgram mProgram;
    private RE mProcessor;

    public FileMatchPattern(String string) throws CheckstylePluginException {
        this.setMatchPattern(string);
    }

    public FileMatchPattern(Node node) throws CheckstylePluginException {
        String string = XMLUtil.getNodeAttributeValue(node, "match-pattern");
        if (string != null) {
            this.setMatchPattern(string.trim());
        } else {
            CheckstyleLog.warning("FileMatchPattern pattern is null");
        }
        string = XMLUtil.getNodeAttributeValue(node, "include-pattern");
        if (string != null) {
            this.mIsIncludePattern = Boolean.valueOf(string.trim());
        } else {
            CheckstyleLog.warning("FileSet enabled is null");
        }
    }

    public String getMatchPattern() {
        return this.mMatchPattern;
    }

    public void setMatchPattern(String string) throws CheckstylePluginException {
        if (string == null || string.trim().length() == 0) {
            throw new CheckstylePluginException("Empty or null pattern");
        }
        REProgram rEProgram = null;
        try {
            rEProgram = sRECompiler.compile(string);
        }
        catch (RESyntaxException rESyntaxException) {
            throw new CheckstylePluginException(rESyntaxException.getMessage());
        }
        this.mProcessor = new RE(rEProgram);
        this.mProgram = rEProgram;
        this.mMatchPattern = string;
    }

    public boolean isMatch(String string) {
        boolean bl = false;
        bl = this.mProcessor.match(string);
        return bl;
    }

    public boolean isIncludePattern() {
        return this.mIsIncludePattern;
    }

    public void setIsIncludePattern(boolean bl) {
        this.mIsIncludePattern = bl;
    }

    public Node toDOMNode(Document document) {
        Element element = null;
        try {
            element = document.createElement("file-match-pattern");
            element.setAttribute("match-pattern", this.mMatchPattern);
            Boolean bl = new Boolean(this.mIsIncludePattern);
            element.setAttribute("include-pattern", bl.toString());
        }
        catch (DOMException dOMException) {
            element = null;
            CheckstyleLog.warning("Failed to create XML DOM node for FileMatchPattern", dOMException);
        }
        return element;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

