/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.config.CheckConfiguration;
import com.atlassw.tools.eclipse.checkstyle.config.CheckConfigurationFactory;
import com.atlassw.tools.eclipse.checkstyle.config.FileMatchPattern;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileSet
implements Cloneable {
    private String mName;
    private String mCheckConfigName = "";
    private CheckConfiguration mCheckConfig;
    private boolean mEnabled = true;
    private List mFileMatchPatterns = new LinkedList();

    public FileSet(String string, CheckConfiguration checkConfiguration) {
        this.mName = string;
        if (checkConfiguration != null) {
            this.mCheckConfigName = checkConfiguration.getName();
        }
        this.mCheckConfig = checkConfiguration;
    }

    public FileSet(Node node) throws CheckstylePluginException {
        String string = XMLUtil.getNodeAttributeValue(node, "name");
        if (string != null) {
            this.mName = string.trim();
        } else {
            CheckstyleLog.warning("FileSet name is null");
        }
        string = XMLUtil.getNodeAttributeValue(node, "enabled");
        if (string != null) {
            this.mEnabled = Boolean.valueOf(string.trim());
        } else {
            CheckstyleLog.warning("FileSet enabled is null");
        }
        string = XMLUtil.getNodeAttributeValue(node, "check-config-name");
        if (string == null) {
            String string2 = "FileSet check configuration name is null";
            CheckstyleLog.warning(string2);
            throw new CheckstylePluginException(string2);
        }
        this.mCheckConfigName = string.trim();
        this.mCheckConfig = CheckConfigurationFactory.getByName(this.mCheckConfigName);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("file-match-pattern")) continue;
            FileMatchPattern fileMatchPattern = null;
            try {
                fileMatchPattern = new FileMatchPattern(node2);
            }
            catch (CheckstylePluginException checkstylePluginException) {
                fileMatchPattern = null;
                CheckstyleLog.warning("Failed to create file match pattern, ignoring");
            }
            if (fileMatchPattern == null) continue;
            this.mFileMatchPatterns.add(fileMatchPattern);
        }
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public List getFileMatchPatterns() {
        return this.mFileMatchPatterns;
    }

    public void setFileMatchPatterns(List list) {
        this.mFileMatchPatterns = list;
    }

    public CheckConfiguration getCheckConfig() {
        CheckConfiguration checkConfiguration = null;
        try {
            checkConfiguration = CheckConfigurationFactory.getByName(this.mCheckConfigName);
        }
        catch (CheckstylePluginException checkstylePluginException) {
            // empty catch block
        }
        return checkConfiguration;
    }

    public String getName() {
        return this.mName;
    }

    public void setEnabled(boolean bl) {
        this.mEnabled = bl;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public Node toDOMNode(Document document) {
        Element element = null;
        try {
            element = document.createElement("fileset");
            element.setAttribute("name", this.mName);
            Boolean bl = new Boolean(this.mEnabled);
            element.setAttribute("enabled", bl.toString());
            element.setAttribute("check-config-name", this.mCheckConfig.getConfigName());
            Iterator iterator = this.mFileMatchPatterns.iterator();
            while (iterator.hasNext()) {
                FileMatchPattern fileMatchPattern = (FileMatchPattern)iterator.next();
                Node node = fileMatchPattern.toDOMNode(document);
                if (node == null) {
                    CheckstyleLog.warning("FileSetPattern lost");
                    continue;
                }
                element.appendChild(node);
            }
        }
        catch (DOMException dOMException) {
            element = null;
            CheckstyleLog.warning("Failed to create XML DOM node for FileSet", dOMException);
        }
        return element;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean includesFile(IFile iFile) throws CheckstylePluginException {
        boolean bl = false;
        String string = iFile.getProjectRelativePath().toString();
        Iterator iterator = this.mFileMatchPatterns.iterator();
        while (iterator.hasNext()) {
            FileMatchPattern fileMatchPattern = (FileMatchPattern)iterator.next();
            boolean bl2 = fileMatchPattern.isMatch(string);
            if (!bl2) continue;
            if (fileMatchPattern.isIncludePattern()) {
                bl = true;
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public String getCheckConfigName() {
        return this.mCheckConfigName;
    }
}

