/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.config.FileSet;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FileSetFactory {
    private static final String FILESET_FILE = ".checkstyle";
    private static final String CURRENT_FILE_FORMAT_VERSION = "1.0.0";

    private FileSetFactory() {
    }

    public static List getFileSets(IProject iProject) throws CheckstylePluginException {
        List list = FileSetFactory.loadFromPersistence(iProject);
        return list;
    }

    public static List getEnabledFileSets(IProject iProject) throws CheckstylePluginException {
        List list = FileSetFactory.loadFromPersistence(iProject);
        LinkedList<FileSet> linkedList = new LinkedList<FileSet>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            if (!fileSet.isEnabled()) continue;
            linkedList.add(fileSet);
        }
        return linkedList;
    }

    public static void setFileSets(List list, IProject iProject) throws CheckstylePluginException {
        FileSetFactory.storeToPersistence(list, iProject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List loadFromPersistence(IProject iProject) throws CheckstylePluginException {
        LinkedList<FileSet> linkedList = new LinkedList<FileSet>();
        IFile iFile = iProject.getFile(FILESET_FILE);
        boolean bl = iFile.exists();
        if (!bl) {
            return linkedList;
        }
        InputStream inputStream = null;
        try {
            try {
                inputStream = iFile.getContents();
                Document document = XMLUtil.newDocument(inputStream);
                if (document == null) {
                    String string = "Failed to read and parse FileSets";
                    CheckstyleLog.warning(string);
                    throw new CheckstylePluginException(string);
                }
                Node node = FileSetFactory.checkFileFormatVersion(document);
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = nodeList.item(i);
                    if (!node2.getNodeName().equals("fileset")) continue;
                    FileSet fileSet = new FileSet(node2);
                    if (fileSet == null) {
                        CheckstyleLog.warning("Failed to load FileSet, ignoring");
                        continue;
                    }
                    linkedList.add(fileSet);
                }
                Object var13_15 = null;
                if (inputStream == null) return linkedList;
            }
            catch (CoreException coreException) {
                String string = "Failed to read FileSets: " + coreException.getMessage();
                CheckstyleLog.warning(string, coreException);
                throw new CheckstylePluginException(string);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        inputStream.close();
        return linkedList;
    }

    private static void storeToPersistence(List list, IProject iProject) throws CheckstylePluginException {
        try {
            Node node;
            Object object;
            Document document = XMLUtil.newDocument();
            Element element = document.createElement("fileset-config");
            document.appendChild(element);
            element.setAttribute("file-format-version", CURRENT_FILE_FORMAT_VERSION);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (FileSet)iterator.next();
                node = ((FileSet)object).toDOMNode(document);
                element.appendChild(node);
            }
            object = XMLUtil.serializeDocument(document, true);
            node = iProject.getFile(FILESET_FILE);
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes("utf-8"));
                if (!node.exists()) {
                    node.create(byteArrayInputStream, true, null);
                    node.setLocal(true, 2, null);
                } else {
                    node.setContents(byteArrayInputStream, true, true, null);
                }
            }
            catch (CoreException coreException) {
                String string = "Failed to write FileSet file: " + coreException.getMessage();
                CheckstyleLog.warning(string, coreException);
                throw new CheckstylePluginException(string);
            }
            finally {
                byteArrayInputStream.close();
            }
        }
        catch (Exception exception) {
            String string = "Failed to write audit configuration file: " + exception.getMessage();
            CheckstyleLog.warning(string, exception);
            throw new CheckstylePluginException(string);
        }
    }

    private static Node checkFileFormatVersion(Document document) {
        return document.getDocumentElement();
    }

    public static boolean isCheckConfigInUse(String string) throws CheckstylePluginException {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        block0: for (int i = 0; i < iProjectArray.length && !bl; ++i) {
            List list = FileSetFactory.getFileSets(iProjectArray[i]);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FileSet fileSet = (FileSet)iterator.next();
                if (!string.equals(fileSet.getCheckConfigName())) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }
}

