/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.config.ConfigProperty;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuleConfiguration
implements Cloneable,
Configuration,
Comparable {
    private String mImplClassname;
    private String mComment = "";
    private SeverityLevel mSeverityLevel;
    private HashMap mConfigProperties = new HashMap();

    public RuleConfiguration(String string) {
        this.mImplClassname = string;
    }

    RuleConfiguration(Node node) throws CheckstylePluginException {
        String string = XMLUtil.getNodeAttributeValue(node, "classname");
        if (string == null) {
            String string2 = "Rule missing implementation classname";
            CheckstyleLog.warning(string2);
            throw new CheckstylePluginException(string2);
        }
        this.mImplClassname = string.trim();
        string = XMLUtil.getNodeAttributeValue(node, "severity");
        if (string == null) {
            String string3 = "Rule missing severity level in metadata";
            CheckstyleLog.warning(string3);
            throw new CheckstylePluginException(string3);
        }
        this.mSeverityLevel = SeverityLevel.getInstance((String)string.trim());
        string = XMLUtil.getNodeAttributeValue(node, "comment");
        if (string != null) {
            this.mComment = string;
        }
        Node node2 = XMLUtil.getChildNode(node, "config-properties");
        NodeList nodeList = node2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeName().equals("config-property")) {
                ConfigProperty configProperty = new ConfigProperty(node3);
                this.mConfigProperties.put(configProperty.getName(), configProperty);
                continue;
            }
            if (!node3.getNodeName().equals("comment")) continue;
            this.mComment = XMLUtil.getNodeTextValue(node3);
        }
    }

    public ConfigProperty getConfigProperty(String string) {
        return (ConfigProperty)this.mConfigProperties.get(string);
    }

    public void setConfigProperties(HashMap hashMap) {
        this.mConfigProperties = hashMap;
    }

    public SeverityLevel getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        String string;
        this.mSeverityLevel = severityLevel;
        ConfigProperty configProperty = (ConfigProperty)this.mConfigProperties.get("severity");
        String string2 = string = severityLevel == null ? null : severityLevel.getName();
        if (configProperty == null) {
            configProperty = new ConfigProperty("severity", string);
            this.mConfigProperties.put("severity", configProperty);
        } else {
            configProperty.setValue(string);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getImplClassname() {
        return this.mImplClassname;
    }

    void setImplClassname(String string) {
        this.mImplClassname = string;
    }

    Node toDOMNode(Document document) {
        Element element = null;
        try {
            element = document.createElement("rule-configuration");
            element.setAttribute("classname", this.mImplClassname);
            String string = this.mSeverityLevel.getName();
            element.setAttribute("severity", string);
            if (this.mComment != null && this.mComment.trim().length() > 0) {
                element.setAttribute("comment", this.mComment);
            }
            Element element2 = document.createElement("config-properties");
            element.appendChild(element2);
            LinkedList linkedList = new LinkedList(this.mConfigProperties.values());
            Collections.sort(linkedList);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                ConfigProperty configProperty = (ConfigProperty)iterator.next();
                if (configProperty.getName().equals("severity")) continue;
                Node node = configProperty.toDOMNode(document);
                element2.appendChild(node);
            }
        }
        catch (DOMException dOMException) {
            element = null;
            CheckstyleLog.warning("Failed to create XML DOM node for rule, ignoring rule");
        }
        return element;
    }

    public String getAttribute(String string) throws CheckstyleException {
        if (string.equals("severity")) {
            return this.mSeverityLevel.getName();
        }
        ConfigProperty configProperty = (ConfigProperty)this.mConfigProperties.get(string);
        if (configProperty == null) {
            String string2 = "Invalid attribute name";
            throw new CheckstyleException(string2);
        }
        String string3 = configProperty.getValue();
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        return string3;
    }

    public String[] getAttributeNames() {
        String[] stringArray;
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.mConfigProperties.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            String string = stringArray.getValue();
            if (string == null || string.length() <= 0) continue;
            linkedList.add(stringArray.getName());
        }
        if (!linkedList.contains("severity")) {
            linkedList.add("severity");
        }
        stringArray = new String[linkedList.size()];
        Collections.sort(linkedList);
        stringArray = linkedList.toArray(stringArray);
        return stringArray;
    }

    public Configuration[] getChildren() {
        Configuration[] configurationArray = new Configuration[]{};
        return configurationArray;
    }

    public String getName() {
        return this.getImplClassname();
    }

    public String getComment() {
        return this.mComment;
    }

    public void setComment(String string) {
        this.mComment = string;
    }

    public int compareTo(Object object) {
        int n = 0;
        RuleConfiguration ruleConfiguration = (RuleConfiguration)object;
        n = this.mImplClassname.compareTo(ruleConfiguration.mImplClassname);
        if (n == 0) {
            n = this.mSeverityLevel.getName().compareTo(ruleConfiguration.mSeverityLevel.getName());
        }
        return n;
    }
}

