/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.preferences;

import com.atlassw.tools.eclipse.checkstyle.CheckstylePlugin;
import com.atlassw.tools.eclipse.checkstyle.builder.CheckstyleBuilder;
import com.atlassw.tools.eclipse.checkstyle.config.CheckConfigConverter;
import com.atlassw.tools.eclipse.checkstyle.config.CheckConfiguration;
import com.atlassw.tools.eclipse.checkstyle.config.CheckConfigurationFactory;
import com.atlassw.tools.eclipse.checkstyle.config.FileSetFactory;
import com.atlassw.tools.eclipse.checkstyle.preferences.CheckConfigurationEditDialog;
import com.atlassw.tools.eclipse.checkstyle.preferences.CheckConfigurationLabelProvider;
import com.atlassw.tools.eclipse.checkstyle.preferences.CheckConfigurationProvider;
import com.atlassw.tools.eclipse.checkstyle.preferences.CheckConfigurationViewerSorter;
import com.atlassw.tools.eclipse.checkstyle.preferences.ResolvePropertyValuesDialog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CheckstylePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite mParentComposite;
    private TableViewer mViewer;
    private Button mAddButton;
    private Button mEditButton;
    private Button mCopyButton;
    private Button mRemoveButton;
    private Button mImportPluginButton;
    private Button mExportPluginButton;
    private Button mImportCheckstyleButton;
    private Button mExportCheckstyleButton;
    private Button mIncludeRuleNamesButton;
    private List mCheckConfigurations;
    private boolean mNeedRebuild = false;

    public CheckstylePreferencePage() {
        this.setPreferenceStore(CheckstylePlugin.getDefault().getPreferenceStore());
        this.setDescription("Checkstyle Settings:");
        this.initializeDefaults();
    }

    private void initializeDefaults() {
    }

    public Control createContents(Composite composite) {
        this.noDefaultAndApplyButton();
        try {
            this.initializeCheckConfigs();
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to create preferences window, " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return composite;
        }
        this.mParentComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.mParentComposite.setLayout((Layout)gridLayout);
        this.createGeneralContents(this.mParentComposite);
        this.createCheckConfigContents(this.mParentComposite);
        return this.mParentComposite;
    }

    private void createGeneralContents(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(" General Settings ");
        group.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        Preferences preferences = CheckstylePlugin.getDefault().getPluginPreferences();
        this.mIncludeRuleNamesButton = new Button((Composite)group, 32);
        this.mIncludeRuleNamesButton.setText("Include rule names in violation messages");
        this.mIncludeRuleNamesButton.setSelection(preferences.getBoolean("include.rule.names"));
    }

    private void createCheckConfigContents(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(" Check Configurations ");
        group.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        Table table = new Table((Composite)group, 67588);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Check Configuration");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        this.mViewer = new TableViewer(table);
        this.mViewer.setLabelProvider((IBaseLabelProvider)new CheckConfigurationLabelProvider());
        this.mViewer.setContentProvider((IContentProvider)new CheckConfigurationProvider());
        this.mViewer.setSorter((ViewerSorter)new CheckConfigurationViewerSorter());
        this.mViewer.setInput((Object)this.mCheckConfigurations);
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                CheckstylePreferencePage.this.editCheckConfig();
            }
        });
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.mAddButton = this.createPushButton(composite2, "Add...");
        this.mAddButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePreferencePage.this.addCheckConfig(null);
            }
        });
        this.mEditButton = this.createPushButton(composite2, "Edit...");
        this.mEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePreferencePage.this.editCheckConfig();
            }
        });
        this.mCopyButton = this.createPushButton(composite2, "Copy...");
        this.mCopyButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePreferencePage.this.copyCheckConfig();
            }
        });
        this.mRemoveButton = this.createPushButton(composite2, "Remove");
        this.mRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePreferencePage.this.removeCheckConfig();
            }
        });
        Composite composite3 = new Composite((Composite)group, 0);
        composite3.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.mImportPluginButton = this.createPushButton(composite3, "Import Plugin Config ...");
        this.mImportPluginButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePreferencePage.this.importPluginCheckConfig();
            }
        });
        this.mExportPluginButton = this.createPushButton(composite3, "Export Plugin Config ...");
        this.mExportPluginButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePreferencePage.this.exportPluginCheckConfig();
            }
        });
        this.mImportCheckstyleButton = this.createPushButton(composite3, "Import Checkstyle Config ...");
        this.mImportCheckstyleButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePreferencePage.this.importCheckstyleCheckConfig();
            }
        });
        this.mExportCheckstyleButton = this.createPushButton(composite3, "Export Checkstyle Config ...");
        this.mExportCheckstyleButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePreferencePage.this.exportCheckstyleCheckConfig();
            }
        });
    }

    public void init(IWorkbench iWorkbench) {
    }

    public boolean performOk() {
        try {
            CheckConfigurationFactory.setCheckConfigurations(this.mCheckConfigurations);
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to save CheckConfigurations, " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
        }
        Preferences preferences = CheckstylePlugin.getDefault().getPluginPreferences();
        boolean bl = this.mIncludeRuleNamesButton.getSelection();
        boolean bl2 = preferences.getBoolean("include.rule.names");
        preferences.setValue("include.rule.names", bl);
        this.mNeedRebuild |= bl ^ bl2;
        if (this.mNeedRebuild) {
            try {
                CheckstyleBuilder.buildAllProjects(this.getShell());
            }
            catch (CheckstylePluginException checkstylePluginException) {
                CheckstyleLog.error("Failed to rebuild projects, " + checkstylePluginException.getMessage(), checkstylePluginException);
                CheckstyleLog.internalErrorDialog();
            }
        }
        return true;
    }

    private Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 72);
        button.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void addCheckConfig(CheckConfiguration checkConfiguration) {
        CheckConfigurationEditDialog checkConfigurationEditDialog = null;
        try {
            checkConfigurationEditDialog = new CheckConfigurationEditDialog(this.mParentComposite.getShell(), checkConfiguration, this.mCheckConfigurations);
            checkConfigurationEditDialog.open();
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to open CheckConfigurationEditDialog, " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        if (checkConfigurationEditDialog.okWasPressed()) {
            CheckConfiguration checkConfiguration2 = checkConfigurationEditDialog.getFinalConfiguration();
            if (checkConfiguration2 != null) {
                Iterator iterator = this.mCheckConfigurations.iterator();
                while (iterator.hasNext()) {
                    CheckConfiguration checkConfiguration3 = (CheckConfiguration)iterator.next();
                    if (!checkConfiguration3.getConfigName().equals(checkConfiguration2.getConfigName())) continue;
                    boolean bl = CheckstyleLog.questionDialog(this.getShell(), "The configuration '" + checkConfiguration3.getConfigName() + "' already exists. Do you want to replace it?");
                    if (bl) {
                        iterator.remove();
                        continue;
                    }
                    return;
                }
                this.mCheckConfigurations.add(checkConfiguration2);
                this.mViewer.refresh();
                try {
                    if (FileSetFactory.isCheckConfigInUse(checkConfiguration2.getConfigName())) {
                        this.mNeedRebuild = true;
                    }
                }
                catch (CheckstylePluginException checkstylePluginException) {
                    this.mNeedRebuild = true;
                    CheckstyleLog.warning("Exception while checking for check config use", checkstylePluginException);
                }
            } else {
                CheckstyleLog.error("New check configuration is null");
                CheckstyleLog.internalErrorDialog();
            }
        }
    }

    private void editCheckConfig() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        CheckConfiguration checkConfiguration = (CheckConfiguration)iStructuredSelection.getFirstElement();
        if (checkConfiguration == null) {
            return;
        }
        CheckConfigurationEditDialog checkConfigurationEditDialog = null;
        try {
            checkConfigurationEditDialog = new CheckConfigurationEditDialog(this.mParentComposite.getShell(), checkConfiguration, this.mCheckConfigurations);
            checkConfigurationEditDialog.open();
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to open CheckConfigurationEditDialog, " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        if (checkConfigurationEditDialog.okWasPressed()) {
            CheckConfiguration checkConfiguration2 = checkConfigurationEditDialog.getFinalConfiguration();
            if (checkConfiguration2 != null) {
                this.mCheckConfigurations.remove(checkConfiguration);
                this.mCheckConfigurations.add(checkConfiguration2);
                try {
                    if (FileSetFactory.isCheckConfigInUse(checkConfiguration2.getConfigName())) {
                        this.mNeedRebuild = true;
                    }
                }
                catch (CheckstylePluginException checkstylePluginException) {
                    this.mNeedRebuild = true;
                    CheckstyleLog.warning("Exception while checking for check config use", checkstylePluginException);
                }
                this.mViewer.refresh();
            } else {
                CheckstyleLog.error("Edited check configuration is null");
                CheckstyleLog.internalErrorDialog();
            }
        }
    }

    private void copyCheckConfig() {
        Object object;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        CheckConfiguration checkConfiguration = (CheckConfiguration)iStructuredSelection.getFirstElement();
        if (checkConfiguration == null) {
            return;
        }
        try {
            checkConfiguration = (CheckConfiguration)checkConfiguration.clone();
            object = "Copy of " + checkConfiguration.getConfigName();
            checkConfiguration.setName((String)object);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CheckstyleLog.error("Failed to clone CheckConfiguration");
            CheckstyleLog.internalErrorDialog();
            return;
        }
        object = null;
        try {
            object = new CheckConfigurationEditDialog(this.mParentComposite.getShell(), checkConfiguration, this.mCheckConfigurations);
            object.open();
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to open CheckConfigurationEditDialog, " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        if (((CheckConfigurationEditDialog)((Object)object)).okWasPressed()) {
            CheckConfiguration checkConfiguration2 = ((CheckConfigurationEditDialog)((Object)object)).getFinalConfiguration();
            if (checkConfiguration2 != null) {
                this.mCheckConfigurations.add(checkConfiguration2);
                this.mViewer.refresh();
            } else {
                CheckstyleLog.error("Copied check configuration is null");
                CheckstyleLog.internalErrorDialog();
            }
        }
    }

    private void removeCheckConfig() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        CheckConfiguration checkConfiguration = (CheckConfiguration)iStructuredSelection.getFirstElement();
        if (checkConfiguration == null) {
            return;
        }
        try {
            if (FileSetFactory.isCheckConfigInUse(checkConfiguration.getConfigName())) {
                MessageDialog.openInformation((Shell)this.mParentComposite.getShell(), (String)"Can't Delete", (String)("The Check Configuration '" + checkConfiguration.getConfigName() + "' is currently in use by a project." + "  It must be removed from all project " + "configurations before it can be deleted."));
                return;
            }
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.warning("Exception while checking for check config use", checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        boolean bl = MessageDialog.openQuestion((Shell)this.mParentComposite.getShell(), (String)"Confirm Delete", (String)("Remove check configuration '" + checkConfiguration.getConfigName() + "'?"));
        if (bl) {
            this.mCheckConfigurations.remove(checkConfiguration);
            this.mViewer.refresh();
        }
    }

    private void importPluginCheckConfig() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText("Import Plug-in Check Configuration");
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        File file = new File(string);
        try {
            List list = CheckConfigurationFactory.importPluginCheckConfigurations(file);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addCheckConfig((CheckConfiguration)iterator.next());
            }
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to import CheckConfigurations from external file", checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
        }
    }

    private void exportPluginCheckConfig() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        CheckConfiguration checkConfiguration = (CheckConfiguration)iStructuredSelection.getFirstElement();
        if (checkConfiguration == null) {
            MessageDialog.openInformation((Shell)this.mParentComposite.getShell(), (String)"No Selection", (String)"No Check Configuration Selected");
            return;
        }
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText("Export Plug-in Check Configuration");
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        File file = new File(string);
        try {
            CheckConfigurationFactory.exportPluginCheckConfigurations(file, checkConfiguration);
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to export CheckConfigurations to external file", checkstylePluginException);
            MessageDialog.openError((Shell)this.mParentComposite.getShell(), (String)"Checkstyle Error", (String)"Failed to export CheckConfigurations to external file");
        }
    }

    private void exportCheckstyleCheckConfig() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        CheckConfiguration checkConfiguration = (CheckConfiguration)iStructuredSelection.getFirstElement();
        if (checkConfiguration == null) {
            MessageDialog.openInformation((Shell)this.mParentComposite.getShell(), (String)"No Selection", (String)"No Check Configuration Selected");
            return;
        }
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText("Export Checkstyle Check Configuration");
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        File file = new File(string);
        try {
            CheckConfigurationFactory.exportCheckstyleCheckConfigurations(file, checkConfiguration);
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to export CheckConfigurations to external file", checkstylePluginException);
            MessageDialog.openError((Shell)this.mParentComposite.getShell(), (String)"Checkstyle Error", (String)"Failed to export CheckConfigurations to external file");
        }
    }

    private void importCheckstyleCheckConfig() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setText("Import Checkstyle Check Configuration");
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        try {
            Object object;
            CheckConfigConverter checkConfigConverter = new CheckConfigConverter();
            checkConfigConverter.loadConfig(string);
            List list = checkConfigConverter.getPropsToResolve();
            if (list.size() > 0) {
                object = new ResolvePropertyValuesDialog(this.getShell(), list);
                object.open();
            }
            object = checkConfigConverter.getCheckConfiguration();
            this.addCheckConfig((CheckConfiguration)object);
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to import CheckConfigurations from external file", checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
        }
    }

    private void initializeCheckConfigs() throws CheckstylePluginException {
        this.mCheckConfigurations = new LinkedList();
        try {
            List list = CheckConfigurationFactory.getCheckConfigurations();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CheckConfiguration checkConfiguration = (CheckConfiguration)iterator.next();
                CheckConfiguration checkConfiguration2 = (CheckConfiguration)checkConfiguration.clone();
                this.mCheckConfigurations.add(checkConfiguration2);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CheckstyleLog.error("Failed to clone CheckConfiguration", cloneNotSupportedException);
            throw new CheckstylePluginException("Failed to clone CheckConfiguration, " + cloneNotSupportedException.getMessage());
        }
    }
}

