/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.preferences;

import com.atlassw.tools.eclipse.checkstyle.config.ConfigProperty;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyMetadata;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyType;
import com.atlassw.tools.eclipse.checkstyle.preferences.IConfigPropertyWidget;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class ConfigPropertyWidgetAbstractBase
implements IConfigPropertyWidget {
    private ConfigPropertyType mType;
    private ConfigProperty mProp;
    private ConfigPropertyMetadata mMetadata;
    private Composite mParent;

    protected ConfigPropertyWidgetAbstractBase(ConfigPropertyType configPropertyType, Composite composite, ConfigProperty configProperty, ConfigPropertyMetadata configPropertyMetadata) {
        this.mParent = composite;
        this.mType = configPropertyType;
        this.mProp = configProperty;
        this.mMetadata = configPropertyMetadata;
    }

    public ConfigPropertyType getConfigPropertyType() {
        return this.mType;
    }

    public abstract String getValue();

    protected String getInitValue() {
        String string = null;
        if (this.mProp != null) {
            string = this.mProp.getValue();
        }
        if (string == null) {
            string = this.mMetadata.getDefaultValue();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public ConfigProperty getConfigProperty() {
        return this.mProp;
    }

    public ConfigPropertyMetadata getMetadata() {
        return this.mMetadata;
    }

    protected void addPropertyLabel(int n) {
        Label label = new Label(this.mParent, n);
        label.setText("   ");
        label = new Label(this.mParent, n);
        label.setText(this.mMetadata.getName());
    }

    protected void addDescriptionButton(int n) {
        Button button = new Button(this.mParent, n | 8);
        button.setText("Description");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigPropertyWidgetAbstractBase.this.propDescription(event);
            }
        });
    }

    private void propDescription(Event event) {
        MessageDialog.openInformation((Shell)this.mParent.getShell(), (String)"Description", (String)this.mMetadata.getDescription());
    }
}

