/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.preferences;

import com.atlassw.tools.eclipse.checkstyle.config.ConfigProperty;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyMetadata;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyType;
import com.atlassw.tools.eclipse.checkstyle.preferences.ConfigPropertyWidgetAbstractBase;
import com.atlassw.tools.eclipse.checkstyle.preferences.ConfigPropertyWidgetBoolean;
import com.atlassw.tools.eclipse.checkstyle.preferences.ConfigPropertyWidgetHidden;
import com.atlassw.tools.eclipse.checkstyle.preferences.ConfigPropertyWidgetMultiCheck;
import com.atlassw.tools.eclipse.checkstyle.preferences.ConfigPropertyWidgetSingleSelect;
import com.atlassw.tools.eclipse.checkstyle.preferences.ConfigPropertyWidgetString;
import com.atlassw.tools.eclipse.checkstyle.preferences.IConfigPropertyWidget;
import org.eclipse.swt.widgets.Composite;

public final class ConfigPropertyWidgetFactory {
    private ConfigPropertyWidgetFactory() {
    }

    static IConfigPropertyWidget createWidget(Composite composite, ConfigPropertyMetadata configPropertyMetadata, ConfigProperty configProperty) {
        ConfigPropertyWidgetAbstractBase configPropertyWidgetAbstractBase = null;
        ConfigPropertyType configPropertyType = configPropertyMetadata.getDatatype();
        if (configPropertyType.equals(ConfigPropertyType.STRING)) {
            configPropertyWidgetAbstractBase = new ConfigPropertyWidgetString(composite, configProperty, configPropertyMetadata);
        }
        if (configPropertyType.equals(ConfigPropertyType.STRING_ARRAY)) {
            configPropertyWidgetAbstractBase = new ConfigPropertyWidgetString(composite, configProperty, configPropertyMetadata);
        } else if (configPropertyType.equals(ConfigPropertyType.INTEGER)) {
            configPropertyWidgetAbstractBase = new ConfigPropertyWidgetString(composite, configProperty, configPropertyMetadata);
        } else if (configPropertyType.equals(ConfigPropertyType.SINGLE_SELECT)) {
            configPropertyWidgetAbstractBase = new ConfigPropertyWidgetSingleSelect(composite, configProperty, configPropertyMetadata);
        } else if (configPropertyType.equals(ConfigPropertyType.BOOLEAN)) {
            configPropertyWidgetAbstractBase = new ConfigPropertyWidgetBoolean(composite, configProperty, configPropertyMetadata);
        } else if (configPropertyType.equals(ConfigPropertyType.MULTI_CHECK)) {
            configPropertyWidgetAbstractBase = new ConfigPropertyWidgetMultiCheck(composite, configProperty, configPropertyMetadata);
        } else if (configPropertyType.equals(ConfigPropertyType.HIDDEN)) {
            configPropertyWidgetAbstractBase = new ConfigPropertyWidgetHidden(composite, configProperty, configPropertyMetadata);
        }
        return configPropertyWidgetAbstractBase;
    }
}

