/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ASTUtil;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IDefinition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Occurrence;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Reference;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ScopeIndex;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTable;
import java.io.File;
import java.util.Iterator;

public class QueryEngine {
    private SymbolTable symbolTable;
    private ScopeIndex index;

    public QueryEngine(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        this.setIndex();
    }

    private void setIndex() {
        this.index = this.symbolTable.getScopeIndex();
    }

    public Reference getSymbol(String name, Occurrence location) {
        Scope enclosingScope = this.index.lookup(location);
        Reference result = enclosingScope.getSymbol(name, location);
        if (result == null) {
            result = enclosingScope.getParentScope().getSymbol(name, location);
        }
        return result;
    }

    public IDefinition getDefinition(String name, Occurrence location) {
        Reference symbol = this.getSymbol(name, location);
        return this.resolveDefinition(symbol);
    }

    public IDefinition getDefinition(Occurrence location) {
        IDefinition result = null;
        SymTabAST node = this.getWordNodeAtOccurrence(location);
        if (node != null) {
            result = node.getDefinition();
        }
        return result;
    }

    private IDefinition resolveDefinition(Reference reference) {
        IDefinition result = null;
        if (reference != null) {
            result = reference.getDefinition();
        }
        return result;
    }

    public Iterator getReferences(String name, Occurrence location) {
        Reference symbol = this.getSymbol(name, location);
        return this.resolveReferences(symbol);
    }

    public Iterator getReferences(Occurrence location) {
        Iterator result = null;
        SymTabAST node = this.getWordNodeAtOccurrence(location);
        if (node != null && node.getDefinition() != null) {
            result = node.getDefinition().getReferences();
        }
        return result;
    }

    private Iterator resolveReferences(Reference reference) {
        return reference.getDefinition().getReferences();
    }

    public SymTabAST getFileNode(File file) {
        return ASTUtil.getFileNode(this.symbolTable.getTree(), file);
    }

    private SymTabAST getWordNodeAtOccurrence(Occurrence location) {
        SymTabAST node;
        SymTabAST result = null;
        SymTabAST fileNode = this.getFileNode(location.getFile());
        if (fileNode != null && (node = fileNode.getEnclosingNode(location.getLine(), location.getColumn())) != null && node.getType() == 58) {
            result = node;
        }
        return result;
    }

    public String getWordAtOccurrence(Occurrence location) {
        String result = null;
        SymTabAST node = this.getWordNodeAtOccurrence(location);
        if (node != null) {
            result = node.getText();
        }
        return result;
    }
}

