/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Occurrence;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class ScopeIndex {
    private Hashtable indexOfFiles = new Hashtable();

    public Hashtable getIndex() {
        return this.indexOfFiles;
    }

    public Scope lookup(Occurrence occ) {
        String key = occ.getFile().getAbsolutePath();
        Vector scopeList = this.getFileVector(key);
        Scope result = this.findScope(scopeList, occ);
        return result;
    }

    public Scope findScope(Vector scopeList, Occurrence occ) {
        int i = 0;
        Scope bestSoFar = (Scope)scopeList.elementAt(i);
        while (!bestSoFar.getTreeNode().getSpan().contains(occ.getLine(), occ.getColumn())) {
            bestSoFar = (Scope)scopeList.elementAt(++i);
        }
        while (i < scopeList.size()) {
            Scope currentScope = (Scope)scopeList.elementAt(i);
            if (currentScope.getTreeNode().getSpan().contains(occ.getLine(), occ.getColumn()) && bestSoFar.getTreeNode().getSpan().contains(currentScope.getTreeNode().getSpan())) {
                bestSoFar = currentScope;
            }
            ++i;
        }
        return bestSoFar;
    }

    public void addScope(Scope scope) {
        SymTabAST SymTabAST2 = scope.getTreeNode();
        File file = SymTabAST2.getFile();
        Vector fileVector = this.getFileVector(scope.getTreeNode().getFile().getAbsolutePath());
        fileVector.addElement(scope);
    }

    private Vector getFileVector(String fileName) {
        Vector result = (Vector)this.indexOfFiles.get(fileName);
        if (result == null) {
            result = new Vector();
            this.indexOfFiles.put(fileName, result);
        }
        return result;
    }
}

