/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import org.apache.regexp.RE;

public class GenericIllegalRegexpCheck
extends AbstractFormatCheck {
    private String mMessage = "";
    private boolean mIgnoreCase;
    private boolean mIgnoreComments;

    public void setMessage(String aMessage) {
        if (aMessage == null) {
            aMessage = "";
        }
        this.mMessage = aMessage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setIgnoreCase(boolean aCaseInsensitive) {
        this.mIgnoreCase = aCaseInsensitive;
    }

    public void setIgnoreComments(boolean aIgnoreComments) {
        this.mIgnoreComments = aIgnoreComments;
    }

    public GenericIllegalRegexpCheck() {
        super("$^");
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        String[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            boolean foundMatch = this.mIgnoreComments ? this.findNonCommentMatch(line, i + 1, 0) : this.getRegexp().match(line);
            if (!foundMatch) continue;
            if ("".equals(this.mMessage)) {
                this.log(i + 1, "illegal.regexp", (Object)this.getFormat());
                continue;
            }
            this.log(i + 1, this.mMessage);
        }
    }

    private boolean findNonCommentMatch(String aLine, int aLineNumber, int aStartPosition) {
        RE regexp = this.getRegexp();
        boolean foundMatch = regexp.match(aLine, aStartPosition);
        if (foundMatch) {
            int startCol = regexp.getParenStart(0);
            int endCol = regexp.getParenEnd(0);
            FileContents fileContents = this.getFileContents();
            if (fileContents.hasIntersectionWithComment(aLineNumber, startCol, aLineNumber, endCol)) {
                if (endCol < aLine.length()) {
                    return this.findNonCommentMatch(aLine, aLineNumber, endCol);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public RE getRegexp() {
        RE regexp = super.getRegexp();
        if (this.mIgnoreCase) {
            regexp.setMatchFlags(1);
        } else {
            regexp.setMatchFlags(0);
        }
        return regexp;
    }
}

